/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.minecolonies.coremod.colony.ColonyManager;
import java.util.UUID;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public final class GetColonyAndCitizen {
    private static final String ONLY_NUMBERS = "Please only use numbers for the %s ID!";
    private static final String TOO_MANY_ARGUMENTS = "Too many arguments!";
    private static final String UNKNOWN_ERROR = "Unknown Error!";
    private static final String NOT_FOUND = "%s not found!";
    private static final String NO_COLONY = "You haven't got a colony!";
    private static final int SHORT_ARGUMENT_LENGTH = 1;
    private static final int NORMAL_ARGUMENT_LENGTH = 2;
    private static final int NAME_ARGUMENT_LENGTH = 3;
    private static final int ID_AND_NAME_ARGUMENT_LENGTH = 4;
    private static final int TOO_MANY_ARGUMENTS_LENGTH = 5;
    private static final int ARGUMENT_ZERO = 0;
    private static final int ARGUMENT_ONE = 1;
    private static final int ARGUMENT_TWO = 2;
    private static final int ARGUMENT_THREE = 3;
    private static final int STANDARD_CITIZEN_ID = 0;

    private GetColonyAndCitizen() {
        throw new IllegalAccessError("Utility Class");
    }

    public static int getColonyId(@NotNull UUID mayorID, @NotNull World world, String ... args) {
        int colonyId;
        if (args.length == 2 || args.length == 4) {
            try {
                colonyId = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format(ONLY_NUMBERS, "colony"));
            }
        } else if (args.length == 1 || args.length == 3) {
            if (ColonyManager.getIColonyByOwner(world, mayorID) == null) {
                throw new IllegalArgumentException(NO_COLONY);
            }
            colonyId = ColonyManager.getIColonyByOwner(world, mayorID).getID();
        } else {
            if (args.length >= 5) {
                throw new IllegalArgumentException(TOO_MANY_ARGUMENTS);
            }
            throw new IllegalArgumentException(UNKNOWN_ERROR);
        }
        if (colonyId >= 0 && ColonyManager.getColony(colonyId) == null) {
            throw new IllegalArgumentException(String.format(NOT_FOUND, "Colony"));
        }
        return colonyId;
    }

    public static int getCitizenId(@NotNull int colonyId, String ... args) {
        int citizenId = 0;
        if (args.length == 2) {
            try {
                citizenId = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format(ONLY_NUMBERS, "citizen"));
            }
        } else if (args.length == 1) {
            try {
                citizenId = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format(ONLY_NUMBERS, "citizen"));
            }
        } else if (args.length == 3 && colonyId >= 0) {
            String citizenName = args[0] + " " + args[1] + " " + args[2];
            for (int i = 1; i <= ColonyManager.getColony(colonyId).getCitizenManager().getCitizens().size(); ++i) {
                if (ColonyManager.getColony(colonyId).getCitizenManager().getCitizen(i).getName() == null || !ColonyManager.getColony(colonyId).getCitizenManager().getCitizen(i).getName().equals(citizenName)) continue;
                citizenId = i;
            }
        } else if (args.length == 4 && colonyId >= 0) {
            String citizenName = args[1] + " " + args[2] + " " + args[3];
            for (int i = 1; i <= ColonyManager.getColony(colonyId).getCitizenManager().getCitizens().size(); ++i) {
                if (!ColonyManager.getColony(colonyId).getCitizenManager().getCitizen(i).getName().equals(citizenName)) continue;
                citizenId = i;
            }
        } else {
            if (args.length >= 5) {
                throw new IllegalArgumentException(TOO_MANY_ARGUMENTS);
            }
            throw new IllegalArgumentException(UNKNOWN_ERROR);
        }
        if (citizenId >= 0 && colonyId >= 0 && ColonyManager.getColony(colonyId).getCitizenManager().getCitizen(citizenId) == null) {
            throw new IllegalArgumentException(String.format(NOT_FOUND, "Citizen"));
        }
        return citizenId;
    }
}

