/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers.core;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.blockout.Log;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractBuildingDependentRequestResolver;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCraftingRequestResolver
extends AbstractBuildingDependentRequestResolver<Stack> {
    public AbstractCraftingRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    public TypeToken<? extends Stack> getRequestType() {
        return TypeToken.of(Stack.class);
    }

    @Override
    public boolean canResolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends Stack> request, @NotNull AbstractBuilding building) {
        if (this.createsCraftingCycle(manager, request, request)) {
            return false;
        }
        return building instanceof AbstractBuildingWorker && this.canBuildingCraftStack((AbstractBuildingWorker)building, request.getRequest().getStack());
    }

    protected boolean createsCraftingCycle(@NotNull IRequestManager manager, @NotNull IRequest<?> request, @NotNull IRequest<? extends Stack> target) {
        return this.createsCraftingCycle(manager, request, target, 0);
    }

    protected boolean createsCraftingCycle(@NotNull IRequestManager manager, @NotNull IRequest<?> request, @NotNull IRequest<? extends Stack> target, int count) {
        if (count > 20) {
            return false;
        }
        if (!request.equals(target) && request.getRequest().equals(target.getRequest())) {
            return true;
        }
        if (!request.hasParent()) {
            return false;
        }
        return this.createsCraftingCycle(manager, manager.getRequestForToken((IToken<?>)request.getParent()), target, count + 1);
    }

    public abstract boolean canBuildingCraftStack(@NotNull AbstractBuildingWorker var1, ItemStack var2);

    @Override
    @Nullable
    public List<IToken<?>> attemptResolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends Stack> request, @NotNull AbstractBuilding building) {
        AbstractBuildingWorker buildingWorker = (AbstractBuildingWorker)building;
        return this.attemptResolveForBuildingAndStack(manager, buildingWorker, request.getRequest().getStack());
    }

    @Nullable
    protected List<IToken<?>> attemptResolveForBuildingAndStack(@NotNull IRequestManager manager, @NotNull AbstractBuildingWorker building, ItemStack stack) {
        IRecipeStorage fullfillableCrafting = building.getFirstFullFillableRecipe(stack);
        if (fullfillableCrafting != null) {
            return ImmutableList.of();
        }
        IRecipeStorage craftableCrafting = building.getFirstRecipe(stack);
        if (craftableCrafting == null) {
            return null;
        }
        return this.createRequestsForRecipe(manager, building, stack, craftableCrafting);
    }

    protected int calculateMaxCraftingCount(@NotNull ItemStack outputStack, @NotNull IRecipeStorage storage) {
        int craftingCount = Math.max(ItemStackUtils.getSize(outputStack), ItemStackUtils.getSize(storage.getPrimaryOutput())) / ItemStackUtils.getSize(storage.getPrimaryOutput());
        for (ItemStack ingredient : storage.getInput()) {
            int ingredientInputCount = ItemStackUtils.getSize(ingredient) * craftingCount;
            if (ingredientInputCount <= ingredient.func_77976_d()) continue;
            craftingCount = Math.max(ingredient.func_77976_d(), ItemStackUtils.getSize(storage.getPrimaryOutput())) / ItemStackUtils.getSize(storage.getPrimaryOutput());
        }
        return craftingCount;
    }

    @Nullable
    protected List<IToken<?>> createRequestsForRecipe(@NotNull IRequestManager manager, @NotNull AbstractBuildingWorker building, ItemStack requestStack, @NotNull IRecipeStorage storage) {
        int craftingCount = this.calculateMaxCraftingCount(requestStack, storage);
        return storage.getInput().stream().filter(s -> ItemStackUtils.isEmpty(s) == false).map(stack -> {
            ItemStack craftingHelperStack = stack.func_77946_l();
            ItemStackUtils.setSize(craftingHelperStack, ItemStackUtils.getSize(craftingHelperStack) * craftingCount);
            return this.createNewRequestForStack(manager, craftingHelperStack);
        }).collect(Collectors.toList());
    }

    @Nullable
    protected IToken<?> createNewRequestForStack(@NotNull IRequestManager manager, ItemStack stack) {
        return manager.createRequest(this, new Stack(stack.func_77946_l()));
    }

    @Override
    public void resolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends Stack> request, @NotNull AbstractBuilding building) {
        AbstractBuildingWorker buildingWorker = (AbstractBuildingWorker)building;
        IRecipeStorage storage = buildingWorker.getFirstFullFillableRecipe(request.getRequest().getStack());
        if (storage == null) {
            Log.getLogger().error("Failed to craft a crafting recipe of: " + request.getRequest().getStack().toString() + ". Its ingredients are missing.");
            return;
        }
        int craftingCount = this.calculateMaxCraftingCount(request.getRequest().getStack(), storage);
        for (int i = 0; i < craftingCount; ++i) {
            buildingWorker.fullFillRecipe(storage);
        }
        manager.updateRequestState((IToken<?>)request.getToken(), RequestState.COMPLETED);
    }
}

