/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.requestsystem.requesters.BuildingBasedRequester;
import com.minecolonies.coremod.util.ServerUtils;
import com.minecolonies.coremod.util.text.NonSiblingFormattingTextComponent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardPlayerRequestResolver
implements IPlayerRequestResolver {
    @NotNull
    private final ILocation location;
    @NotNull
    private final IToken token;
    @NotNull
    private final Set<IToken<?>> assignedRequests = new HashSet();

    public StandardPlayerRequestResolver(@NotNull ILocation location, @NotNull IToken token) {
        this.location = location;
        this.token = token;
    }

    @Override
    public TypeToken<IRequestable> getRequestType() {
        return TypeConstants.REQUESTABLE;
    }

    @Override
    public boolean canResolve(@NotNull IRequestManager manager, IRequest requestToCheck) {
        return !manager.getColony().getWorld().field_72995_K;
    }

    @Override
    @Nullable
    public List<IToken<?>> attemptResolve(@NotNull IRequestManager manager, @NotNull IRequest request) {
        if (this.canResolve(manager, request)) {
            return Lists.newArrayList();
        }
        return null;
    }

    @Override
    @Nullable
    public void resolve(@NotNull IRequestManager manager, @NotNull IRequest request) throws RuntimeException {
        IColony colony = manager.getColony();
        if (colony instanceof Colony) {
            if (Configurations.requestSystem.creativeResolve && request.getRequest() instanceof IDeliverable && request.getRequester() instanceof BuildingBasedRequester && ((BuildingBasedRequester)request.getRequester()).getBuilding(manager, (IToken<?>)request.getToken()).isPresent() && ((BuildingBasedRequester)request.getRequester()).getBuilding(manager, (IToken<?>)request.getToken()).get() instanceof AbstractBuilding) {
                AbstractBuilding building = (AbstractBuilding)((BuildingBasedRequester)request.getRequester()).getBuilding(manager, (IToken<?>)request.getToken()).get();
                Optional<CitizenData> citizenDataOptional = building.getCitizenForRequest((IToken)request.getToken());
                List<ItemStack> resolvablestacks = request.getDisplayStacks();
                if (!resolvablestacks.isEmpty() && citizenDataOptional.isPresent()) {
                    ItemStack resolveStack = resolvablestacks.get(0);
                    resolveStack.func_190920_e(Math.min(((IDeliverable)request.getRequest()).getCount(), resolveStack.func_77976_d()));
                    ItemStack remainingItemStack = InventoryUtils.addItemStackToItemHandlerWithResult((IItemHandler)new InvWrapper((IInventory)citizenDataOptional.get().getInventory()), resolveStack);
                    if (ItemStackUtils.isEmpty(remainingItemStack).booleanValue()) {
                        manager.updateRequestState((IToken<?>)request.getToken(), RequestState.COMPLETED);
                        return;
                    }
                }
            }
            ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>(((Colony)colony).getMessageEntityPlayers());
            EntityPlayer owner = ServerUtils.getPlayerFromUUID(colony.getWorld(), ((Colony)colony).getPermissions().getOwner());
            TextComponentString colonyDescription = new TextComponentString(colony.getName() + ":");
            if (manager.getColony().getWorld().func_72935_r()) {
                if (owner != null) {
                    players.remove(owner);
                    LanguageHandler.sendPlayerMessage(owner, "com.minecolonies.requestsystem.playerresolver", request.getRequester().getDisplayName(manager, (IToken<?>)request.getToken()).func_150254_d(), this.getRequestMessage(request).func_150254_d(), request.getRequester().getRequesterLocation().toString());
                }
                LanguageHandler.sendPlayersMessage(players, "com.minecolonies.requestsystem.playerresolver", colonyDescription.func_150254_d() + " " + request.getRequester().getDisplayName(manager, (IToken<?>)request.getToken()).func_150254_d(), this.getRequestMessage(request).func_150254_d(), request.getRequester().getRequesterLocation().toString());
            }
        }
        this.assignedRequests.add((IToken<?>)request.getToken());
    }

    private ITextComponent getRequestMessage(@NotNull IRequest request) {
        NonSiblingFormattingTextComponent component = new NonSiblingFormattingTextComponent();
        component.func_150257_a(request.getShortDisplayString());
        component.func_150256_b().func_150238_a(TextFormatting.WHITE);
        return component;
    }

    @Override
    @Nullable
    public IRequest getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest completedRequest) {
        if (this.assignedRequests.contains(completedRequest.getToken())) {
            this.assignedRequests.remove(completedRequest.getToken());
        }
        return null;
    }

    @Override
    @Nullable
    public IRequest<?> onRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IRequestable> request) {
        return this.getFollowupRequestForCompletion(manager, request);
    }

    @Override
    public void onRequestBeingOverruled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IRequestable> request) {
        this.getFollowupRequestForCompletion(manager, request);
    }

    @Override
    public int getPriority() {
        return 0;
    }

    public IToken getRequesterId() {
        return this.token;
    }

    @Override
    @NotNull
    public ILocation getRequesterLocation() {
        return this.location;
    }

    @NotNull
    public void onRequestComplete(@NotNull IRequestManager manager, @NotNull IToken token) {
    }

    @NotNull
    public void onRequestCancelled(@NotNull IRequestManager manager, @NotNull IToken token) {
    }

    @NotNull
    public ITextComponent getDisplayName(@NotNull IRequestManager manager, @NotNull IToken token) {
        return new TextComponentString("Player");
    }

    @Override
    public ImmutableList<IToken<?>> getAllAssignedRequests() {
        return ImmutableList.copyOf(this.assignedRequests);
    }

    @Override
    public void onSystemReset() {
        this.assignedRequests.clear();
    }

    public void setAllAssignedRequests(Set<IToken<?>> assignedRequests) {
        this.assignedRequests.clear();
        this.assignedRequests.addAll(assignedRequests);
    }
}

