/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.management.handlers;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverProvider;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.coremod.colony.requestsystem.management.IStandardRequestManager;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.LogHandler;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.ResolverHandler;
import java.util.ArrayList;
import java.util.Collection;

public final class ProviderHandler {
    public static Collection<IToken<?>> getRegisteredResolvers(IStandardRequestManager manager, IRequestResolverProvider provider) {
        return manager.getProviderResolverAssignmentDataStore().getAssignments().get(provider.getToken());
    }

    public static void registerProvider(IStandardRequestManager manager, IRequestResolverProvider provider) {
        ImmutableList.Builder resolverListBuilder = new ImmutableList.Builder();
        resolverListBuilder.addAll(ResolverHandler.registerResolvers(manager, provider.getResolvers()));
        manager.getProviderResolverAssignmentDataStore().getAssignments().put(provider.getToken(), (Collection<ImmutableList>)resolverListBuilder.build());
        manager.getColony().markDirty();
    }

    public static void removeProvider(IStandardRequestManager manager, IToken<?> token) {
        ProviderHandler.removeProviderInternal(manager, token);
    }

    public static void removeProviderInternal(IStandardRequestManager manager, IToken<?> token) {
        LogHandler.log("Removing provider: " + token);
        Collection<IToken<?>> assignedResolvers = ProviderHandler.getRegisteredResolvers(manager, token);
        if (assignedResolvers == null) {
            return;
        }
        for (IToken<?> resolverToken : assignedResolvers) {
            if (!manager.getRequestResolverRequestAssignmentDataStore().getAssignments().containsKey(resolverToken) || manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolverToken).isEmpty()) {
                LogHandler.log("Removing resolver without assigned requests: " + resolverToken);
                manager.getRequestResolverRequestAssignmentDataStore().getAssignments().remove(resolverToken);
                ResolverHandler.removeResolver(manager, resolverToken);
                continue;
            }
            ArrayList assignedRequests = new ArrayList(manager.getRequestResolverRequestAssignmentDataStore().getAssignments().get(resolverToken));
            LogHandler.log("Starting reassignment of already registered requests registered to resolver with token: " + resolverToken);
            for (IToken requestToken : assignedRequests) {
                manager.reassignRequest(requestToken, assignedResolvers);
            }
            ResolverHandler.removeResolver(manager, resolverToken);
            LogHandler.log("Finished reassignment of already registered requests registered to resolver with token: " + resolverToken);
        }
        manager.getProviderResolverAssignmentDataStore().getAssignments().remove(token);
        manager.getColony().markDirty();
        LogHandler.log("Removed provider: " + token);
    }

    public static Collection<IToken<?>> getRegisteredResolvers(IStandardRequestManager manager, IToken<?> token) {
        return manager.getProviderResolverAssignmentDataStore().getAssignments().get(token);
    }

    public static void removeProvider(IStandardRequestManager manager, IRequestResolverProvider provider) {
        ProviderHandler.removeProviderInternal(manager, provider.getToken());
    }
}

