/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestable;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.ColonyManager;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class SmeltableOre
implements IDeliverable {
    private static final String NBT_COUNT = "Count";
    private static final String NBT_RESULT = "Result";
    private final int count;
    private ItemStack result;

    public SmeltableOre(int count) {
        this.count = count;
    }

    public SmeltableOre(int count, ItemStack result) {
        this.count = count;
        this.result = result;
    }

    public static NBTTagCompound serialize(IFactoryController controller, SmeltableOre food) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a(NBT_COUNT, food.count);
        if (!ItemStackUtils.isEmpty(food.result).booleanValue()) {
            compound.func_74782_a(NBT_RESULT, (NBTBase)food.result.serializeNBT());
        }
        return compound;
    }

    public static SmeltableOre deserialize(IFactoryController controller, NBTTagCompound compound) {
        int count = compound.func_74762_e(NBT_COUNT);
        ItemStack result = compound.func_74764_b(NBT_RESULT) ? ItemStackUtils.deserializeFromNBT(compound.func_74775_l(NBT_RESULT)) : ItemStackUtils.EMPTY;
        return new SmeltableOre(count, result);
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        return ItemStackUtils.IS_SMELTABLE.and(itemStack -> itemStack.func_77973_b() instanceof ItemBlock && ColonyManager.getCompatabilityManager().isOre((ItemStack)itemStack)).test(stack) && stack.func_190916_E() >= this.getCount();
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.result;
    }
}

