/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.minecolonies.coremod.achievements.MineColoniesAchievement;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.TriggerColonyAchievements;
import com.minecolonies.coremod.colony.managers.IStatisticAchievementManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class StatisticAchievementManager
implements IStatisticAchievementManager {
    private int minedOres = 0;
    private int minedDiamonds = 0;
    private int harvestedWheat = 0;
    private int harvestedPotatoes = 0;
    private int harvestedCarrots = 0;
    private int killedMobs = 0;
    private int builtHuts = 0;
    private int caughtFish = 0;
    private int felledTrees = 0;
    private int plantedSaplings = 0;
    private final Colony colony;
    @NotNull
    private final List<Advancement> colonyAchievements = new ArrayList<Advancement>();

    public StatisticAchievementManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        NBTTagCompound statisticsCompound = compound.func_74775_l("statistics");
        NBTTagCompound minerStatisticsCompound = statisticsCompound.func_74775_l("minerStatistics");
        NBTTagCompound farmerStatisticsCompound = statisticsCompound.func_74775_l("farmerStatistics");
        NBTTagCompound guardStatisticsCompound = statisticsCompound.func_74775_l("farmerStatistics");
        NBTTagCompound builderStatisticsCompound = statisticsCompound.func_74775_l("builderStatistics");
        NBTTagCompound fishermanStatisticsCompound = statisticsCompound.func_74775_l("fishermanStatistics");
        NBTTagCompound lumberjackStatisticsCompound = statisticsCompound.func_74775_l("lumberjackStatistics");
        this.minedOres = minerStatisticsCompound.func_74762_e("ores");
        this.minedDiamonds = minerStatisticsCompound.func_74762_e("diamonds");
        this.harvestedCarrots = farmerStatisticsCompound.func_74762_e("carrots");
        this.harvestedPotatoes = farmerStatisticsCompound.func_74762_e("potatoes");
        this.harvestedWheat = farmerStatisticsCompound.func_74762_e("wheat");
        this.killedMobs = guardStatisticsCompound.func_74762_e("mobs");
        this.builtHuts = builderStatisticsCompound.func_74762_e("huts");
        this.caughtFish = fishermanStatisticsCompound.func_74762_e("fish");
        this.felledTrees = lumberjackStatisticsCompound.func_74762_e("trees");
        this.plantedSaplings = lumberjackStatisticsCompound.func_74762_e("saplings");
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        NBTTagCompound statisticsCompound = new NBTTagCompound();
        NBTTagCompound minerStatisticsCompound = new NBTTagCompound();
        NBTTagCompound farmerStatisticsCompound = new NBTTagCompound();
        NBTTagCompound guardStatisticsCompound = new NBTTagCompound();
        NBTTagCompound builderStatisticsCompound = new NBTTagCompound();
        NBTTagCompound fishermanStatisticsCompound = new NBTTagCompound();
        NBTTagCompound lumberjackStatisticsCompound = new NBTTagCompound();
        compound.func_74782_a("statistics", (NBTBase)statisticsCompound);
        statisticsCompound.func_74782_a("minerStatistics", (NBTBase)minerStatisticsCompound);
        minerStatisticsCompound.func_74768_a("ores", this.minedOres);
        minerStatisticsCompound.func_74768_a("diamonds", this.minedDiamonds);
        statisticsCompound.func_74782_a("farmerStatistics", (NBTBase)farmerStatisticsCompound);
        farmerStatisticsCompound.func_74768_a("carrots", this.harvestedCarrots);
        farmerStatisticsCompound.func_74768_a("potatoes", this.harvestedPotatoes);
        farmerStatisticsCompound.func_74768_a("wheat", this.harvestedWheat);
        statisticsCompound.func_74782_a("guardStatistics", (NBTBase)guardStatisticsCompound);
        guardStatisticsCompound.func_74768_a("mobs", this.killedMobs);
        statisticsCompound.func_74782_a("builderStatistics", (NBTBase)builderStatisticsCompound);
        builderStatisticsCompound.func_74768_a("huts", this.builtHuts);
        statisticsCompound.func_74782_a("fishermanStatistics", (NBTBase)fishermanStatisticsCompound);
        fishermanStatisticsCompound.func_74768_a("fish", this.caughtFish);
        statisticsCompound.func_74782_a("lumberjackStatistics", (NBTBase)lumberjackStatisticsCompound);
        lumberjackStatisticsCompound.func_74768_a("trees", this.felledTrees);
        lumberjackStatisticsCompound.func_74768_a("saplings", this.plantedSaplings);
    }

    @Override
    public void incrementStatistic(@NotNull String stat) {
        int statisticAmount = this.getStatisticAmount(stat);
        this.incrementStatisticAmount(stat);
        if (statisticAmount >= 1) {
            TriggerColonyAchievements.triggerFirstAchievement(stat, this.colony);
        }
        if (statisticAmount >= 25) {
            TriggerColonyAchievements.triggerSecondAchievement(stat, this.colony);
        }
        if (statisticAmount >= 100) {
            TriggerColonyAchievements.triggerThirdAchievement(stat, this.colony);
        }
        if (statisticAmount >= 500) {
            TriggerColonyAchievements.triggerFourthAchievement(stat, this.colony);
        }
        if (statisticAmount >= 1000) {
            TriggerColonyAchievements.triggerFifthAchievement(stat, this.colony);
        }
    }

    @Override
    public List<Advancement> getAchievements() {
        return new ArrayList<Advancement>(this.colonyAchievements);
    }

    private int getStatisticAmount(@NotNull String statistic) {
        switch (statistic) {
            case "mobs": {
                return this.killedMobs;
            }
            case "ores": {
                return this.minedOres;
            }
            case "diamonds": {
                return this.minedDiamonds;
            }
            case "huts": {
                return this.builtHuts;
            }
            case "fish": {
                return this.caughtFish;
            }
            case "wheat": {
                return this.harvestedWheat;
            }
            case "potatoes": {
                return this.harvestedPotatoes;
            }
            case "carrots": {
                return this.harvestedCarrots;
            }
            case "saplings": {
                return this.plantedSaplings;
            }
            case "trees": {
                return this.felledTrees;
            }
        }
        return 0;
    }

    private void incrementStatisticAmount(@NotNull String statistic) {
        switch (statistic) {
            case "mobs": {
                ++this.killedMobs;
                break;
            }
            case "ores": {
                ++this.minedOres;
                break;
            }
            case "diamonds": {
                ++this.minedDiamonds;
                break;
            }
            case "huts": {
                ++this.builtHuts;
                break;
            }
            case "fish": {
                ++this.caughtFish;
                break;
            }
            case "wheat": {
                ++this.harvestedWheat;
                break;
            }
            case "potatoes": {
                ++this.harvestedPotatoes;
                break;
            }
            case "carrots": {
                ++this.harvestedCarrots;
                break;
            }
            case "saplings": {
                ++this.plantedSaplings;
                break;
            }
            case "trees": {
                ++this.felledTrees;
                break;
            }
        }
    }

    @Override
    public void checkAchievements() {
    }

    @Override
    public void triggerAchievement(@NotNull MineColoniesAchievement achievement) {
    }
}

