/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.Structures;
import com.minecolonies.coremod.colony.managers.IColonyPackageManager;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.colony.workorders.AbstractWorkOrder;
import com.minecolonies.coremod.colony.workorders.WorkManager;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildMiner;
import com.minecolonies.coremod.network.messages.ColonyStylesMessage;
import com.minecolonies.coremod.network.messages.ColonyViewMessage;
import com.minecolonies.coremod.network.messages.ColonyViewWorkOrderMessage;
import com.minecolonies.coremod.network.messages.PermissionsMessage;
import com.minecolonies.coremod.util.ColonyUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class ColonyPackageManager
implements IColonyPackageManager {
    private static final int CHANCE_TO_UPDATE = 1000;
    @NotNull
    private Set<EntityPlayerMP> oldSubscribers = new HashSet<EntityPlayerMP>();
    @NotNull
    private Set<EntityPlayerMP> subscribers = new HashSet<EntityPlayerMP>();
    private boolean isDirty = false;
    private int ticksPassed = 0;
    private int lastContactInHours = 0;
    private final Colony colony;

    public ColonyPackageManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public int getLastContactInHours() {
        return this.lastContactInHours;
    }

    @Override
    public void setLastContactInHours(int lastContactInHours) {
        this.lastContactInHours = lastContactInHours;
    }

    @Override
    public Set<EntityPlayerMP> getSubscribers() {
        HashSet<EntityPlayerMP> set = new HashSet<EntityPlayerMP>(this.oldSubscribers);
        set.addAll(this.subscribers);
        return set;
    }

    @Override
    public void updateSubscribers() {
        World world = this.colony.getWorld();
        if (world == null || world.func_73046_m() == null) {
            return;
        }
        world.func_73046_m().func_184103_al().func_181057_v().stream().filter(this.colony.getPermissions()::isSubscriber).forEach(this.subscribers::add);
        for (EntityPlayer o : world.field_73010_i) {
            double distance;
            if (!(o instanceof EntityPlayerMP)) continue;
            EntityPlayerMP player = (EntityPlayerMP)o;
            if (player.field_71135_a.field_147368_e < 5 || !((distance = player.func_174818_b(this.colony.getCenter())) < ColonyConstants.MAX_SQ_DIST_SUBSCRIBER_UPDATE) && (!this.oldSubscribers.contains(player) || !(distance < ColonyConstants.MAX_SQ_DIST_OLD_SUBSCRIBER_UPDATE))) continue;
            this.subscribers.add(player);
        }
        if (this.subscribers.isEmpty()) {
            if (this.ticksPassed >= 72000) {
                this.ticksPassed = 0;
                ++this.lastContactInHours;
                this.colony.markDirty();
            }
            ++this.ticksPassed;
        } else if (this.lastContactInHours != 0) {
            this.lastContactInHours = 0;
            this.ticksPassed = 0;
            this.colony.markDirty();
        }
        boolean hasNewSubscribers = ColonyUtils.hasNewSubscribers(this.oldSubscribers, this.subscribers);
        this.updateColonyViews(hasNewSubscribers);
    }

    public void updateColonyViews(boolean hasNewSubscribers) {
        if (!this.subscribers.isEmpty()) {
            this.sendColonyViewPackets(this.oldSubscribers, hasNewSubscribers);
            this.sendPermissionsPackets(this.oldSubscribers, hasNewSubscribers);
            this.sendWorkOrderPackets(this.oldSubscribers, hasNewSubscribers);
            this.colony.getCitizenManager().sendPackets(this.oldSubscribers, hasNewSubscribers, this.subscribers);
            this.colony.getBuildingManager().sendPackets(this.oldSubscribers, hasNewSubscribers, this.subscribers);
            if (Structures.isDirty()) {
                this.sendSchematicsPackets(hasNewSubscribers);
                Structures.clearDirty();
            }
        }
        this.isDirty = false;
        this.colony.getPermissions().clearDirty();
        this.colony.getBuildingManager().clearDirty();
        this.colony.getCitizenManager().clearDirty();
        this.oldSubscribers = new HashSet<EntityPlayerMP>(this.subscribers);
        this.subscribers = new HashSet<EntityPlayerMP>();
    }

    @Override
    public void sendColonyViewPackets(@NotNull Set<EntityPlayerMP> oldSubscribers, boolean hasNewSubscribers) {
        if (this.isDirty || hasNewSubscribers) {
            for (EntityPlayerMP player : this.subscribers) {
                boolean isNewSubscriber;
                boolean bl = isNewSubscriber = !oldSubscribers.contains(player);
                if (!this.isDirty && !isNewSubscriber) continue;
                MineColonies.getNetwork().sendTo((IMessage)new ColonyViewMessage(this.colony, isNewSubscriber), player);
            }
        }
    }

    @Override
    public void sendPermissionsPackets(@NotNull Set<EntityPlayerMP> oldSubscribers, boolean hasNewSubscribers) {
        Permissions permissions = this.colony.getPermissions();
        if (permissions.isDirty() || hasNewSubscribers || this.colony.getWorld().field_73012_v.nextInt(1000) <= 1) {
            this.subscribers.stream().filter(player -> permissions.isDirty() || !oldSubscribers.contains(player)).forEach(player -> {
                Rank rank = permissions.getRank((EntityPlayer)player);
                MineColonies.getNetwork().sendTo((IMessage)new PermissionsMessage.View(this.colony, rank), player);
            });
        }
    }

    @Override
    public void sendWorkOrderPackets(@NotNull Set<EntityPlayerMP> oldSubscribers, boolean hasNewSubscribers) {
        WorkManager workManager = this.colony.getWorkManager();
        if (workManager.isDirty() || hasNewSubscribers) {
            for (AbstractWorkOrder workOrder : workManager.getWorkOrders().values()) {
                if (workOrder instanceof WorkOrderBuildMiner) continue;
                this.subscribers.stream().filter(player -> workManager.isDirty() || !oldSubscribers.contains(player)).forEach(player -> MineColonies.getNetwork().sendTo((IMessage)new ColonyViewWorkOrderMessage(this.colony, workOrder), player));
            }
            workManager.setDirty(false);
        }
    }

    @Override
    public void sendSchematicsPackets(boolean hasNewSubscribers) {
        if (Structures.isDirty() || hasNewSubscribers) {
            this.subscribers.stream().forEach(player -> MineColonies.getNetwork().sendTo((IMessage)new ColonyStylesMessage(), player));
        }
    }

    @Override
    public void setDirty() {
        this.isDirty = true;
    }

    @Override
    public void addSubscribers(@NotNull EntityPlayerMP subscriber) {
        if (!this.subscribers.contains(subscriber)) {
            this.subscribers.add(subscriber);
        }
    }

    @Override
    public void removeSubscriber(@NotNull EntityPlayerMP player) {
        if (!this.colony.getMessageEntityPlayers().contains(player)) {
            this.subscribers.remove(player);
        }
    }
}

