/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.blocks.BlockBarracksTowerSubstitution;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.blocks.huts.BlockHutBarracks;
import com.minecolonies.coremod.blocks.huts.BlockHutBarracksTower;
import com.minecolonies.coremod.client.gui.WindowBarracksBuilding;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.StructureName;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBarracksTower;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import com.minecolonies.coremod.util.StructureWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import org.jetbrains.annotations.NotNull;

public class BuildingBarracks
extends AbstractBuilding {
    private static final String SCHEMATIC_NAME = "Barracks";
    private static final int BARRACKS_HUT_MAX_LEVEL = 5;
    private static final int TOWER_OFFSET = 8;

    public BuildingBarracks(@NotNull Colony colony, BlockPos pos) {
        super(colony, pos);
    }

    @Override
    public String getSchematicName() {
        return SCHEMATIC_NAME;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onDestroyed() {
        World world = this.getColony().getWorld();
        if (world != null) {
            for (int i = 1; i <= this.getBuildingLevel() && i < 5; ++i) {
                Tuple<BlockPos, EnumFacing> tuple = this.getPositionAndFacingForLevel(i);
                if (!(world.func_180495_p((BlockPos)tuple.func_76341_a()).func_177230_c() instanceof BlockHutBarracksTower)) continue;
                world.func_175656_a((BlockPos)tuple.func_76341_a(), Blocks.field_150350_a.func_176223_P());
            }
        }
        super.onDestroyed();
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        World world = this.getColony().getWorld();
        if (world != null) {
            for (int i = 1; i <= newLevel && i < 5; ++i) {
                AbstractBuilding building;
                Tuple<BlockPos, EnumFacing> tuple = this.getPositionAndFacingForLevel(i);
                if (!(world.func_180495_p((BlockPos)tuple.func_76341_a()).func_177230_c() instanceof BlockHutBarracksTower)) {
                    world.func_175656_a((BlockPos)tuple.func_76341_a(), ModBlocks.blockHutBarracksTower.func_176223_P().func_177226_a((IProperty)BlockHutBarracksTower.FACING, (Comparable)tuple.func_76340_b()));
                    this.getColony().getBuildingManager().addNewBuilding((TileEntityColonyBuilding)world.func_175625_s((BlockPos)tuple.func_76341_a()), world);
                }
                if (!((building = this.getColony().getBuildingManager().getBuilding((BlockPos)tuple.func_76341_a())) instanceof BuildingBarracksTower)) continue;
                building.setStyle(this.getStyle());
                ((BuildingBarracksTower)building).addBarracks(this.getLocation());
            }
        }
        super.onUpgradeComplete(newLevel);
    }

    private final Tuple<BlockPos, EnumFacing> getPositionAndFacingForLevel(int level) {
        BlockPos position = this.getLocation();
        int tempLevel = level;
        if (this.isMirrored()) {
            ++tempLevel;
        }
        switch (this.getRotation()) {
            case 1: {
                tempLevel += 3;
                break;
            }
            case 2: {
                ++tempLevel;
                break;
            }
            case 3: {
                tempLevel += 2;
                break;
            }
        }
        if (tempLevel > 4) {
            tempLevel -= 4;
        }
        EnumFacing facing = EnumFacing.NORTH;
        int offset = this.getStyle().toLowerCase(Locale.ENGLISH).contains("birch") ? 9 : 8;
        switch (tempLevel) {
            case 1: {
                position = position.func_177967_a(EnumFacing.SOUTH, offset).func_177967_a(EnumFacing.WEST, offset);
                break;
            }
            case 2: {
                position = position.func_177967_a(EnumFacing.NORTH, offset).func_177967_a(EnumFacing.EAST, offset);
                facing = EnumFacing.SOUTH;
                break;
            }
            case 3: {
                position = position.func_177967_a(EnumFacing.SOUTH, offset).func_177967_a(EnumFacing.EAST, offset);
                facing = EnumFacing.WEST;
                break;
            }
            case 4: {
                position = position.func_177967_a(EnumFacing.NORTH, offset).func_177967_a(EnumFacing.WEST, offset);
                facing = EnumFacing.EAST;
                break;
            }
        }
        return new Tuple((Object)position, (Object)facing);
    }

    private List<Tuple<BlockPos, EnumFacing>> getBarracksTowers() {
        StructureName sn = new StructureName("schematics", this.getStyle(), this.getSchematicName() + this.getBuildingLevel());
        String structureName = sn.toString();
        StructureWrapper wrapper = new StructureWrapper(this.getColony().getWorld(), structureName);
        BlockPos barracksPos = null;
        ArrayList<Template.BlockInfo> barracksTowers = new ArrayList<Template.BlockInfo>();
        for (Template.BlockInfo block : wrapper.getStructure().getStructure().getTemplate().field_186270_a) {
            if (block.field_186243_b.func_177230_c() instanceof BlockHutBarracks) {
                barracksPos = block.field_186242_a;
            }
            if (!(block.field_186243_b.func_177230_c() instanceof BlockBarracksTowerSubstitution)) continue;
            barracksTowers.add(block);
        }
        ArrayList<Tuple<BlockPos, EnumFacing>> towers = new ArrayList<Tuple<BlockPos, EnumFacing>>();
        if (barracksPos != null) {
            for (Template.BlockInfo block : barracksTowers) {
                int xDif = barracksPos.func_177958_n() - block.field_186242_a.func_177958_n();
                int yDif = barracksPos.func_177956_o() - block.field_186242_a.func_177956_o();
                int zDif = barracksPos.func_177952_p() - block.field_186242_a.func_177952_p();
                int towerX = this.getLocation().func_177958_n() + xDif;
                int towerY = this.getLocation().func_177956_o() - yDif;
                int towerZ = this.getLocation().func_177952_p() + zDif;
                BlockPos towerPos = new BlockPos(towerX, towerY, towerZ);
                EnumFacing towerFacing = (EnumFacing)block.field_186243_b.func_177229_b((IProperty)BlockBarracksTowerSubstitution.FACING);
                towers.add((Tuple<BlockPos, EnumFacing>)new Tuple((Object)towerPos, (Object)towerFacing));
            }
        }
        return towers;
    }

    public static class View
    extends AbstractBuildingView {
        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowBarracksBuilding(this);
        }
    }
}

