/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.views;

import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBuildingBuilderView
extends AbstractBuildingWorker.View {
    private final HashMap<String, BuildingBuilderResource> resources = new HashMap();
    private String constructionName;
    private String constructionPos;

    public AbstractBuildingBuilderView(ColonyView c, BlockPos l) {
        super(c, l);
    }

    @Override
    public void deserialize(@NotNull ByteBuf buf) {
        super.deserialize(buf);
        int size = buf.readInt();
        this.resources.clear();
        for (int i = 0; i < size; ++i) {
            ItemStack itemStack = ByteBufUtils.readItemStack((ByteBuf)buf);
            int amountAvailable = buf.readInt();
            int amountNeeded = buf.readInt();
            BuildingBuilderResource resource = new BuildingBuilderResource(itemStack, amountNeeded, amountAvailable);
            this.resources.put(itemStack.func_82833_r() + ":" + itemStack.func_77952_i(), resource);
        }
        this.constructionName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.constructionPos = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public String getConstructionName() {
        return this.constructionName;
    }

    public String getConstructionPos() {
        return this.constructionPos;
    }

    public Map<String, BuildingBuilderResource> getResources() {
        return Collections.unmodifiableMap(this.resources);
    }
}

