/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.StructureName;
import com.minecolonies.coremod.colony.Structures;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.registry.BuildingRegistry;
import com.minecolonies.coremod.util.BuildingUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSchematicProvider {
    private final BlockPos location;
    private int buildingLevel = 0;
    private int rotation = 0;
    private boolean isBuildingMirrored = false;
    private String style = "wooden";
    private int height;
    private int cornerX1;
    private int cornerX2;
    private int cornerZ1;
    private int cornerZ2;
    private boolean dirty = false;

    public AbstractSchematicProvider(BlockPos pos) {
        this.location = pos;
    }

    public int hashCode() {
        return (int)(31L * this.getID().func_177986_g());
    }

    public boolean equals(Object o) {
        return o instanceof AbstractBuilding && ((AbstractBuilding)o).getID().equals((Object)this.getID());
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        StructureName newStructureName;
        this.buildingLevel = compound.func_74762_e("level");
        this.rotation = compound.func_74762_e("rotation");
        this.style = compound.func_74779_i("style");
        String md5 = compound.func_74779_i("schematicMD5");
        int testLevel = this.buildingLevel == 0 ? 1 : this.buildingLevel;
        StructureName sn = new StructureName("schematics", this.style, this.getSchematicName() + testLevel);
        if (!Structures.hasMD5(sn) && (newStructureName = Structures.getStructureNameByMD5(md5)) != null && newStructureName.getPrefix().equals(sn.getPrefix()) && newStructureName.getSchematic().equals(sn.getSchematic())) {
            this.style = newStructureName.getStyle();
            Log.getLogger().warn("AbstractBuilding.readFromNBT: " + sn + " have been moved to " + newStructureName);
        }
        if (this.style.isEmpty()) {
            Log.getLogger().warn("Loaded empty style, setting to wooden");
            this.style = "wooden";
        }
        this.isBuildingMirrored = compound.func_74767_n("mirror");
        if (compound.func_74764_b("corner1")) {
            this.cornerX1 = compound.func_74762_e("corner1");
            this.cornerX2 = compound.func_74762_e("corner2");
            this.cornerZ1 = compound.func_74762_e("corner3");
            this.cornerZ2 = compound.func_74762_e("corner4");
        }
        if (compound.func_74764_b("height")) {
            this.height = compound.func_74762_e("height");
        }
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        String s = (String)BuildingRegistry.getNameToClassMap().inverse().get(this.getClass());
        if (s == null) {
            throw new IllegalStateException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        compound.func_74778_a("type", s);
        BlockPosUtil.writeToNBT(compound, "location", this.location);
        StructureName structureName = new StructureName("schematics", this.style, this.getSchematicName() + this.buildingLevel);
        if (Structures.hasMD5(structureName)) {
            compound.func_74778_a("schematicMD5", Structures.getMD5(structureName.toString()));
        }
        compound.func_74768_a("level", this.buildingLevel);
        compound.func_74768_a("rotation", this.rotation);
        compound.func_74778_a("style", this.style);
        compound.func_74757_a("mirror", this.isBuildingMirrored);
        compound.func_74768_a("corner1", this.cornerX1);
        compound.func_74768_a("corner2", this.cornerX2);
        compound.func_74768_a("corner3", this.cornerZ1);
        compound.func_74768_a("corner4", this.cornerZ2);
        compound.func_74768_a("height", this.height);
    }

    public BlockPos getLocation() {
        return this.location;
    }

    public void setCorners(int x1, int x2, int z1, int z2) {
        this.cornerX1 = x1;
        this.cornerX2 = x2;
        this.cornerZ1 = z1;
        this.cornerZ2 = z2;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> getCorners() {
        return new Tuple((Object)new Tuple((Object)this.cornerX1, (Object)this.cornerX2), (Object)new Tuple((Object)this.cornerZ1, (Object)this.cornerZ2));
    }

    public BlockPos getID() {
        return this.location;
    }

    public AxisAlignedBB getTargetableArea(World world) {
        return BuildingUtils.getTargetAbleArea(world, this);
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
        this.markDirty();
    }

    public int getHeight() {
        return this.height;
    }

    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    public void setBuildingLevel(int level) {
        if (level > this.getMaxBuildingLevel()) {
            return;
        }
        this.buildingLevel = level;
        this.markDirty();
        ColonyManager.markDirty();
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public final void clearDirty() {
        this.dirty = false;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void invertMirror() {
        this.isBuildingMirrored = !this.isBuildingMirrored;
    }

    public boolean isMirrored() {
        return this.isBuildingMirrored;
    }

    public abstract String getSchematicName();

    public abstract int getMaxBuildingLevel();
}

