/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.blockout.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.requestsystem.resolvers.BuildingRequestResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PrivateWorkerCraftingRequestResolver;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingWorker
extends AbstractBuilding {
    public static final int WOOD_HUT_LEVEL = 0;
    private final List<IToken> recipes = new ArrayList<IToken>();

    public AbstractBuildingWorker(@NotNull Colony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ItemFood, this.getBuildingLevel() * 2);
    }

    @NotNull
    public abstract AbstractJob createJob(CitizenData var1);

    public boolean isItemStackInRequest(@Nullable ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        for (CitizenData data : this.getAssignedCitizen()) {
            for (IRequest request : this.getOpenRequests(data)) {
                if (!request.getDelivery().func_185136_b(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canCraft(ItemStack stack) {
        Colony colony = this.getColony();
        if (colony == null) {
            return false;
        }
        return this.getFirstFullFillableRecipe(stack) != null;
    }

    @Nullable
    public IRecipeStorage getFirstRecipe(ItemStack stack) {
        for (IToken token : this.recipes) {
            IRecipeStorage storage = (IRecipeStorage)ColonyManager.getRecipeManager().getRecipes().get((Object)token);
            if (storage == null || !storage.getPrimaryOutput().func_77969_a(stack)) continue;
            return storage;
        }
        return null;
    }

    public IRecipeStorage getFirstFullFillableRecipe(ItemStack tempStack) {
        for (IToken token : this.recipes) {
            List<IItemHandler> handlers;
            IRecipeStorage storage = (IRecipeStorage)ColonyManager.getRecipeManager().getRecipes().get((Object)token);
            if (storage == null || !storage.getPrimaryOutput().func_77969_a(tempStack) || !storage.canFullFillRecipe((handlers = this.getHandlers()).toArray(new IItemHandler[handlers.size()]))) continue;
            return storage;
        }
        return null;
    }

    public boolean fullFillRecipe(IRecipeStorage storage) {
        List<IItemHandler> handlers = this.getHandlers();
        return storage.fullfillRecipe(handlers);
    }

    public void switchIndex(int i, int j) {
        if (i < this.recipes.size() && j < this.recipes.size() && i >= 0 && j >= 0) {
            IToken storage = this.recipes.get(i);
            this.recipes.set(i, this.recipes.get(j));
            this.recipes.set(j, storage);
        }
    }

    public boolean canRecipeBeAdded() {
        return true;
    }

    public List<IItemHandler> getHandlers() {
        Colony colony = this.getColony();
        if (this.getAssignedEntities().isEmpty() || colony == null || colony.getWorld() == null) {
            return Collections.emptyList();
        }
        ArrayList<IItemHandler> handlers = new ArrayList<IItemHandler>();
        for (CitizenData workerEntity : this.getAssignedCitizen()) {
            handlers.add((IItemHandler)new InvWrapper((IInventory)workerEntity.getInventory()));
        }
        handlers.add((IItemHandler)new InvWrapper((IInventory)this.getTileEntity()));
        for (BlockPos pos : this.getAdditionalCountainers()) {
            TileEntity entity = colony.getWorld().func_175625_s(pos);
            if (entity == null) continue;
            handlers.addAll(InventoryUtils.getItemHandlersFromProvider((ICapabilityProvider)entity));
        }
        return handlers;
    }

    @Override
    public boolean assignCitizen(CitizenData citizen) {
        if (!super.assignCitizen(citizen)) {
            Log.getLogger().warn("Ohoohohoohoh, wasn't abel to assign citizen to work building!!!");
            return false;
        }
        if (citizen != null) {
            citizen.getCitizenEntity().ifPresent(tempCitizen -> {
                if (!tempCitizen.getCitizenJobHandler().getLastJob().isEmpty() && !tempCitizen.getCitizenJobHandler().getLastJob().equals(this.getJobName())) {
                    citizen.resetExperienceAndLevel();
                }
                tempCitizen.getCitizenJobHandler().setLastJob(this.getJobName());
            });
            citizen.setWorkBuilding(this);
        }
        return true;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.func_74764_b("worker")) {
            try {
                NBTTagList workersTagList = compound.func_150295_c("worker", 10);
                for (int i = 0; i < workersTagList.func_74745_c(); ++i) {
                    CitizenData data = workersTagList.func_150305_b(i).func_74764_b("id") ? this.getColony().getCitizenManager().getCitizen(workersTagList.func_150305_b(i).func_74762_e("id")) : (workersTagList.func_150305_b(i).func_74764_b("workerId") ? this.getColony().getCitizenManager().getCitizen(workersTagList.func_150305_b(i).func_74762_e("workerId")) : null);
                    if (data == null) continue;
                    this.assignCitizen(data);
                }
            }
            catch (Exception e) {
                MineColonies.getLogger().warn("Warning: Updating data structures:", (Throwable)e);
                CitizenData worker = this.getColony().getCitizenManager().getCitizen(compound.func_74762_e("worker"));
                this.assignCitizen(worker);
            }
        }
        this.recipes.clear();
        NBTTagList recipesTags = compound.func_150295_c("recipes", 10);
        this.recipes.addAll(NBTUtils.streamCompound(recipesTags).map(recipeCompound -> (IToken)StandardFactoryController.getInstance().deserialize((NBTTagCompound)recipeCompound)).collect(Collectors.toList()));
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (this.hasAssignedCitizen()) {
            NBTTagList workersTagList = new NBTTagList();
            for (CitizenData data : this.getAssignedCitizen()) {
                if (data == null) continue;
                NBTTagCompound idCompound = new NBTTagCompound();
                idCompound.func_74768_a("workerId", data.getId());
                workersTagList.func_74742_a((NBTBase)idCompound);
            }
            compound.func_74782_a("worker", (NBTBase)workersTagList);
        }
        NBTTagList recipesTagList = this.recipes.stream().map(iToken -> StandardFactoryController.getInstance().serialize(iToken)).collect(NBTUtils.toNBTTagList());
        compound.func_74782_a("recipes", (NBTBase)recipesTagList);
    }

    @Override
    public void onWakeUp() {
    }

    public void addRecipe(IToken token) {
        if (this.canRecipeBeAdded() && Math.pow(2.0, this.getBuildingLevel()) >= (double)(this.recipes.size() + 1)) {
            this.recipes.add(token);
        }
    }

    public void removeRecipe(IToken token) {
        this.recipes.remove(token);
    }

    @Override
    public void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        CitizenData joblessCitizen;
        super.onWorldTick(event);
        if (!(this.hasAssignedCitizen() || this.getBuildingLevel() <= 0 && !(this instanceof BuildingBuilder) || this.getColony().isManualHiring() || (joblessCitizen = this.getColony().getCitizenManager().getJoblessCitizen()) == null)) {
            this.assignCitizen(joblessCitizen);
        }
    }

    @Override
    public void removeCitizen(CitizenData citizen) {
        if (this.isCitizenAssigned(citizen)) {
            super.removeCitizen(citizen);
            citizen.setWorkBuilding(null);
        }
    }

    @NotNull
    public abstract String getJobName();

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.getAssignedCitizen().size());
        for (CitizenData data : this.getAssignedCitizen()) {
            buf.writeInt(data == null ? 0 : data.getId());
        }
        ArrayList<IRecipeStorage> storages = new ArrayList<IRecipeStorage>();
        for (IToken token : new ArrayList<IToken>(this.recipes)) {
            IRecipeStorage storage = (IRecipeStorage)ColonyManager.getRecipeManager().getRecipes().get((Object)token);
            if (storage == null) {
                this.removeRecipe(token);
                continue;
            }
            storages.add(storage);
        }
        buf.writeInt(storages.size());
        for (IRecipeStorage storage : storages) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)StandardFactoryController.getInstance().serialize(storage));
        }
    }

    public int getMaxToolLevel() {
        if (this.getBuildingLevel() >= this.getMaxBuildingLevel()) {
            return 32;
        }
        if (this.getBuildingLevel() <= 0) {
            return 0;
        }
        return this.getBuildingLevel() - 0;
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> getResolvers() {
        return ImmutableList.of((Object)new BuildingRequestResolver(this.getRequester().getRequesterLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)), (Object)new PrivateWorkerCraftingRequestResolver(this.getRequester().getRequesterLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
    }

    public static class View
    extends AbstractBuildingView {
        private final List<Integer> workerIDs = new ArrayList<Integer>();
        private final List<IRecipeStorage> recipes = new ArrayList<IRecipeStorage>();

        public View(ColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }

        public List<Integer> getWorkerId() {
            return new ArrayList<Integer>(this.workerIDs);
        }

        public void addWorkerId(int workerId) {
            this.workerIDs.add(workerId);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            int size = buf.readInt();
            this.workerIDs.clear();
            for (int i = 0; i < size; ++i) {
                this.workerIDs.add(buf.readInt());
            }
            this.recipes.clear();
            int recipesSize = buf.readInt();
            for (int i = 0; i < recipesSize; ++i) {
                IRecipeStorage storage = (IRecipeStorage)StandardFactoryController.getInstance().deserialize(ByteBufUtils.readTag((ByteBuf)buf));
                if (storage == null) continue;
                this.recipes.add(storage);
            }
        }

        public List<IRecipeStorage> getRecipes() {
            return new ArrayList<IRecipeStorage>(this.recipes);
        }

        public void removeRecipe(int i) {
            if (i < this.recipes.size() && i >= 0) {
                this.recipes.remove(i);
            }
        }

        public void switchIndex(int i, int j) {
            if (i < this.recipes.size() && j < this.recipes.size() && i >= 0 && j >= 0) {
                IRecipeStorage storage = this.recipes.get(i);
                this.recipes.set(i, this.recipes.get(j));
                this.recipes.set(j, storage);
            }
        }

        @NotNull
        public Skill getPrimarySkill() {
            return Skill.PLACEHOLDER;
        }

        @NotNull
        public Skill getSecondarySkill() {
            return Skill.PLACEHOLDER;
        }

        public void removeWorkerId(int id) {
            for (int i = 0; i < this.workerIDs.size(); ++i) {
                int workerId = this.workerIDs.get(i);
                if (workerId != id) continue;
                this.workerIDs.remove(i);
            }
        }

        public boolean hasEnoughWorkers() {
            return !this.workerIDs.isEmpty();
        }
    }

    public static enum Skill {
        STRENGTH,
        ENDURANCE,
        CHARISMA,
        INTELLIGENCE,
        DEXTERITY,
        PLACEHOLDER;

    }
}

