/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.jobs.AbstractJobStructure;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuild;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.inventory.InventoryCitizen;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingStructureBuilder
extends AbstractBuildingWorker {
    public static final int MAX_BUILDING_LEVEL = 5;
    private static final String TAG_RESOURCE_LIST = "resourcesItem";
    private HashMap<String, BuildingBuilderResource> neededResources = new HashMap();

    public AbstractBuildingStructureBuilder(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public Map<Predicate<ItemStack>, Integer> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Integer> toKeep = new HashMap<Predicate<ItemStack>, Integer>(this.keepX);
        toKeep.putAll(this.keepX);
        for (BuildingBuilderResource stack : this.neededResources.values()) {
            toKeep.put(itemstack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack.getItemStack(), itemstack, true, true), stack.getAmount());
        }
        return toKeep;
    }

    @Override
    public ItemStack forceTransferStack(ItemStack stack, World world) {
        ItemStack itemStack = super.forceTransferStack(stack, world);
        if (ItemStackUtils.isEmpty(itemStack).booleanValue()) {
            this.markDirty();
        }
        return itemStack;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagList neededResTagList = compound.func_150295_c(TAG_RESOURCE_LIST, 10);
        for (int i = 0; i < neededResTagList.func_74745_c(); ++i) {
            NBTTagCompound neededRes = neededResTagList.func_150305_b(i);
            ItemStack stack = new ItemStack(neededRes);
            BuildingBuilderResource resource = new BuildingBuilderResource(stack, ItemStackUtils.getSize(stack));
            int hashCode = stack.func_77942_o() ? stack.func_77978_p().hashCode() : 0;
            this.neededResources.put(stack.func_77977_a() + ":" + stack.func_77952_i() + "-" + hashCode, resource);
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList neededResTagList = new NBTTagList();
        for (BuildingBuilderResource resource : this.neededResources.values()) {
            NBTTagCompound neededRes = new NBTTagCompound();
            ItemStack itemStack = new ItemStack(resource.getItem(), resource.getAmount(), resource.getDamageValue());
            itemStack.func_77982_d(resource.getItemStack().func_77978_p());
            itemStack.func_77955_b(neededRes);
            neededResTagList.func_74742_a((NBTBase)neededRes);
        }
        compound.func_74782_a(TAG_RESOURCE_LIST, (NBTBase)neededResTagList);
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        this.updateAvailableResources();
        buf.writeInt(this.neededResources.size());
        for (BuildingBuilderResource resource : this.neededResources.values()) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)resource.getItemStack());
            buf.writeInt(resource.getAvailable());
            buf.writeInt(resource.getAmount());
        }
        CitizenData data = this.getMainCitizen();
        if (data != null && data.getJob() instanceof AbstractJobStructure) {
            AbstractJobStructure structureBuilderJob = (AbstractJobStructure)data.getJob();
            WorkOrderBuildDecoration workOrderBuildDecoration = structureBuilderJob.getWorkOrder();
            if (workOrderBuildDecoration != null) {
                String desc;
                BlockPos pos = workOrderBuildDecoration.getBuildingLocation();
                String name = workOrderBuildDecoration instanceof WorkOrderBuild ? ((WorkOrderBuild)workOrderBuildDecoration).getUpgradeName() : workOrderBuildDecoration.getName();
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)name);
                if (pos.equals((Object)this.getLocation())) {
                    desc = "here";
                } else {
                    BlockPos relativePos = this.getLocation().func_177973_b((Vec3i)pos);
                    EnumFacing facingX = EnumFacing.func_176737_a((float)relativePos.func_177958_n(), (float)0.0f, (float)0.0f);
                    EnumFacing facingZ = EnumFacing.func_176737_a((float)0.0f, (float)0.0f, (float)relativePos.func_177952_p());
                    desc = relativePos.func_177958_n() + " " + facingX + " " + relativePos.func_177952_p() + " " + facingZ;
                }
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)desc);
            } else {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)"-");
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)"");
            }
        } else {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)"-");
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)"");
        }
    }

    private void updateAvailableResources() {
        this.getMainCitizenEntity().ifPresent(structureBuilder -> {
            InventoryCitizen structureBuilderInventory = this.getMainCitizen().getInventory();
            if (structureBuilderInventory == null) {
                return;
            }
            for (Map.Entry<String, BuildingBuilderResource> entry : this.neededResources.entrySet()) {
                TileEntityColonyBuilding chestInventory;
                BuildingBuilderResource resource = entry.getValue();
                resource.setAvailable(0);
                if (structureBuilderInventory != null) {
                    resource.addAvailable(InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)structureBuilderInventory), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, resource.getItemStack(), true, true)));
                }
                if ((chestInventory = this.getTileEntity()) != null) {
                    resource.addAvailable(InventoryUtils.getItemCountInProvider((ICapabilityProvider)chestInventory, stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, resource.getItemStack(), true, true)));
                }
                if (structureBuilder == null) continue;
                for (BlockPos pos : this.getAdditionalCountainers()) {
                    TileEntity entity = CompatibilityUtils.getWorld((Entity)structureBuilder).func_175625_s(pos);
                    if (!(entity instanceof TileEntityChest)) continue;
                    resource.addAvailable(InventoryUtils.getItemCountInProvider((ICapabilityProvider)entity, stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, resource.getItemStack(), true, true)));
                }
            }
        });
    }

    public Map<String, BuildingBuilderResource> getNeededResources() {
        return new HashMap<String, BuildingBuilderResource>(this.neededResources);
    }

    public void addNeededResource(@Nullable ItemStack res, int amount) {
        if (ItemStackUtils.isEmpty(res).booleanValue() || amount == 0) {
            return;
        }
        int hashCode = res.func_77942_o() ? res.func_77978_p().hashCode() : 0;
        BuildingBuilderResource resource = this.neededResources.get(res.func_77977_a() + ":" + res.func_77952_i() + "-" + hashCode);
        if (resource == null) {
            resource = new BuildingBuilderResource(res, amount);
        } else {
            resource.setAmount(resource.getAmount() + amount);
        }
        this.neededResources.put(res.func_77977_a() + ":" + res.func_77952_i() + "-" + hashCode, resource);
        this.markDirty();
    }

    public void reduceNeededResource(ItemStack res, int amount) {
        int hashCode = res.func_77942_o() ? res.func_77978_p().hashCode() : 0;
        int preAmount = 0;
        String name = res.func_77977_a() + ":" + res.func_77952_i() + "-" + hashCode;
        if (this.neededResources.containsKey(name)) {
            preAmount = this.neededResources.get(name).getAmount();
        }
        if (preAmount - amount <= 0) {
            this.neededResources.remove(name);
        } else {
            this.neededResources.get(name).setAmount(preAmount - amount);
        }
        this.markDirty();
    }

    public void resetNeededResources() {
        this.neededResources = new HashMap();
        this.markDirty();
    }

    public boolean requiresResourceForBuilding(ItemStack stack) {
        int hashCode = stack.func_77942_o() ? stack.func_77978_p().hashCode() : 0;
        return this.neededResources.containsKey(stack.func_77977_a() + ":" + stack.func_77952_i() + "-" + hashCode);
    }

    public abstract void searchWorkOrder();
}

