/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.Player;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.HappinessData;
import com.minecolonies.coremod.colony.buildings.registry.BuildingRegistry;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.colony.permissions.PermissionsView;
import com.minecolonies.coremod.colony.requestsystem.management.manager.StandardRequestManager;
import com.minecolonies.coremod.colony.workorders.AbstractWorkOrder;
import com.minecolonies.coremod.colony.workorders.WorkOrderView;
import com.minecolonies.coremod.network.messages.PermissionsMessage;
import com.minecolonies.coremod.network.messages.TownHallRenameMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColonyView
implements IColony {
    private final int id;
    private final Map<Integer, WorkOrderView> workOrders = new HashMap<Integer, WorkOrderView>();
    @NotNull
    private final PermissionsView permissions = new PermissionsView();
    @NotNull
    private final Map<BlockPos, AbstractBuildingView> buildings = new HashMap<BlockPos, AbstractBuildingView>();
    @NotNull
    private final Map<Integer, CitizenDataView> citizens = new HashMap<Integer, CitizenDataView>();
    private String name = "Unknown";
    private int dimensionId;
    private BlockPos center = BlockPos.field_177992_a;
    private final HappinessData happinessData = new HappinessData();
    private boolean manualHiring = false;
    private boolean manualHousing = false;
    @Nullable
    private BuildingTownHall.View townHall;
    private int maxCitizens = 0;
    private boolean hasColonyWarehouse;
    private final List<BlockPos> lastSpawnPoints = new ArrayList<BlockPos>();
    private final Set<BlockPos> freePositions = new HashSet<BlockPos>();
    private final Set<Block> freeBlocks = new HashSet<Block>();
    private final Set<BlockPos> wayPoints = new HashSet<BlockPos>();
    private double overallHappiness = 5.0;
    private int lastContactInHours = 0;
    private IRequestManager requestManager;
    private World world;

    private ColonyView(int id) {
        this.id = id;
    }

    @NotNull
    public static ColonyView createFromNetwork(int id) {
        return new ColonyView(id);
    }

    public static void serializeNetworkData(@NotNull Colony colony, @NotNull ByteBuf buf, boolean isNewSubScription) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)colony.getName());
        buf.writeInt(colony.getDimension());
        BlockPosUtil.writeToByteBuf(buf, colony.getCenter());
        buf.writeBoolean(colony.isManualHiring());
        buf.writeInt(colony.getCitizenManager().getMaxCitizens());
        Set<Block> freeBlocks = colony.getFreeBlocks();
        Set<BlockPos> freePos = colony.getFreePositions();
        Set<BlockPos> waypoints = colony.getWayPoints().keySet();
        buf.writeInt(freeBlocks.size());
        for (Block block : freeBlocks) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)block.getRegistryName().toString());
        }
        buf.writeInt(freePos.size());
        for (BlockPos blockPos : freePos) {
            BlockPosUtil.writeToByteBuf(buf, blockPos);
        }
        buf.writeDouble(colony.getOverallHappiness());
        buf.writeBoolean(colony.hasWarehouse());
        buf.writeInt(waypoints.size());
        for (BlockPos blockPos : waypoints) {
            BlockPosUtil.writeToByteBuf(buf, blockPos);
        }
        buf.writeInt(colony.getLastContactInHours());
        buf.writeBoolean(colony.isManualHousing());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)((NBTTagCompound)colony.getRequestManager().serializeNBT()));
        buf.writeInt(colony.getBarbManager().getLastSpawnPoints().size());
        for (BlockPos blockPos : colony.getBarbManager().getLastSpawnPoints()) {
            BlockPosUtil.writeToByteBuf(buf, blockPos);
        }
    }

    public List<BlockPos> getFreePositions() {
        return new ArrayList<BlockPos>(this.freePositions);
    }

    public List<Block> getFreeBlocks() {
        return new ArrayList<Block>(this.freeBlocks);
    }

    public void addFreePosition(@NotNull BlockPos pos) {
        this.freePositions.add(pos);
    }

    public void addFreeBlock(@NotNull Block block) {
        this.freeBlocks.add(block);
    }

    public void removeFreePosition(@NotNull BlockPos pos) {
        this.freePositions.remove(pos);
    }

    public void removeFreeBlock(@NotNull Block block) {
        this.freeBlocks.remove(block);
    }

    public int getDimension() {
        return this.dimensionId;
    }

    public boolean isManualHiring() {
        return this.manualHiring;
    }

    public void setManualHiring(boolean manualHiring) {
        this.manualHiring = manualHiring;
    }

    public boolean isManualHousing() {
        return this.manualHousing;
    }

    public void setManualHousing(boolean manualHousing) {
        this.manualHousing = manualHousing;
    }

    @Nullable
    public BuildingTownHall.View getTownHall() {
        return this.townHall;
    }

    public AbstractBuildingView getBuilding(int x, int y, int z) {
        return this.getBuilding(new BlockPos(x, y, z));
    }

    public AbstractBuildingView getBuilding(BlockPos buildingId) {
        return this.buildings.get(buildingId);
    }

    @NotNull
    public Map<UUID, Player> getPlayers() {
        return this.permissions.getPlayers();
    }

    public void setPermission(Rank rank, @NotNull Action action) {
        if (this.permissions.setPermission(rank, action)) {
            MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.Permission(this, PermissionsMessage.MessageType.SET_PERMISSION, rank, action));
        }
    }

    public void removePermission(Rank rank, @NotNull Action action) {
        if (this.permissions.removePermission(rank, action)) {
            MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.Permission(this, PermissionsMessage.MessageType.REMOVE_PERMISSION, rank, action));
        }
    }

    public void togglePermission(Rank rank, @NotNull Action action) {
        this.permissions.togglePermission(rank, action);
        MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.Permission(this, PermissionsMessage.MessageType.TOGGLE_PERMISSION, rank, action));
    }

    public int getMaxCitizens() {
        return this.maxCitizens;
    }

    public Map<Integer, CitizenDataView> getCitizens() {
        return Collections.unmodifiableMap(this.citizens);
    }

    public Collection<WorkOrderView> getWorkOrders() {
        return Collections.unmodifiableCollection(this.workOrders.values());
    }

    public CitizenDataView getCitizen(int id) {
        return this.citizens.get(id);
    }

    @Nullable
    public IMessage handleColonyViewMessage(@NotNull ByteBuf buf, @NotNull World world, boolean isNewSubscription) {
        this.world = world;
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.dimensionId = buf.readInt();
        this.center = BlockPosUtil.readFromByteBuf(buf);
        this.manualHiring = buf.readBoolean();
        this.maxCitizens = buf.readInt();
        if (isNewSubscription) {
            this.citizens.clear();
            this.townHall = null;
            this.buildings.clear();
        }
        this.freePositions.clear();
        this.freeBlocks.clear();
        this.wayPoints.clear();
        this.lastSpawnPoints.clear();
        int blockListSize = buf.readInt();
        for (int i = 0; i < blockListSize; ++i) {
            this.freeBlocks.add(Block.func_149684_b((String)ByteBufUtils.readUTF8String((ByteBuf)buf)));
        }
        int posListSize = buf.readInt();
        for (int i = 0; i < posListSize; ++i) {
            this.freePositions.add(BlockPosUtil.readFromByteBuf(buf));
        }
        this.overallHappiness = buf.readDouble();
        this.hasColonyWarehouse = buf.readBoolean();
        int wayPointListSize = buf.readInt();
        for (int i = 0; i < wayPointListSize; ++i) {
            this.wayPoints.add(BlockPosUtil.readFromByteBuf(buf));
        }
        this.lastContactInHours = buf.readInt();
        this.manualHousing = buf.readBoolean();
        this.requestManager = new StandardRequestManager(this);
        this.requestManager.deserializeNBT((NBTBase)ByteBufUtils.readTag((ByteBuf)buf));
        int barbSpawnListSize = buf.readInt();
        for (int i = 0; i < barbSpawnListSize; ++i) {
            this.lastSpawnPoints.add(BlockPosUtil.readFromByteBuf(buf));
        }
        Collections.reverse(this.lastSpawnPoints);
        return null;
    }

    @Nullable
    public IMessage handlePermissionsViewMessage(@NotNull ByteBuf buf) {
        this.permissions.deserialize(buf);
        return null;
    }

    @Nullable
    public IMessage handleColonyViewWorkOrderMessage(ByteBuf buf) {
        WorkOrderView workOrder = AbstractWorkOrder.createWorkOrderView(buf);
        if (workOrder != null) {
            this.workOrders.put(workOrder.getId(), workOrder);
        }
        return null;
    }

    @Nullable
    public IMessage handleColonyViewCitizensMessage(int id, ByteBuf buf) {
        CitizenDataView citizen = CitizenData.createCitizenDataView(id, buf);
        if (citizen != null) {
            this.citizens.put(citizen.getId(), citizen);
        }
        return null;
    }

    @Nullable
    public IMessage handleColonyViewRemoveCitizenMessage(int citizen) {
        this.citizens.remove(citizen);
        return null;
    }

    @Nullable
    public IMessage handleColonyViewRemoveBuildingMessage(BlockPos buildingId) {
        AbstractBuildingView building = this.buildings.remove(buildingId);
        if (this.townHall == building) {
            this.townHall = null;
        }
        return null;
    }

    @Nullable
    public IMessage handleColonyViewRemoveWorkOrderMessage(int workOrderId) {
        this.workOrders.remove(workOrderId);
        return null;
    }

    @Nullable
    public IMessage handleColonyBuildingViewMessage(BlockPos buildingId, @NotNull ByteBuf buf) {
        AbstractBuildingView building = BuildingRegistry.createBuildingView(this, buildingId, buf);
        if (building != null) {
            this.buildings.put(building.getID(), building);
            if (building instanceof BuildingTownHall.View) {
                this.townHall = (BuildingTownHall.View)building;
            }
        }
        return null;
    }

    public IMessage handleHappinessDataMessage(HappinessData happinessData) {
        this.happinessData.setValues(happinessData);
        return null;
    }

    public void addPlayer(String player) {
        MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.AddPlayer(this, player));
    }

    public void removePlayer(UUID player) {
        MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.RemovePlayer(this, player));
    }

    public double getOverallHappiness() {
        return this.overallHappiness;
    }

    @Override
    public BlockPos getCenter() {
        return this.center;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        MineColonies.getNetwork().sendToServer((IMessage)new TownHallRenameMessage(this, name));
    }

    @Override
    @NotNull
    public PermissionsView getPermissions() {
        return this.permissions;
    }

    @Override
    public boolean isCoordInColony(@NotNull World w, @NotNull BlockPos pos) {
        Chunk chunk = w.func_175726_f(pos);
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
        return cap.getOwningColony() == this.getID();
    }

    @Override
    public long getDistanceSquared(@NotNull BlockPos pos) {
        return BlockPosUtil.getDistanceSquared2D(this.center, pos);
    }

    @Override
    public boolean hasTownHall() {
        return this.townHall != null;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public boolean hasWarehouse() {
        return this.hasColonyWarehouse;
    }

    @Override
    public int getLastContactInHours() {
        return this.lastContactInHours;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    @Nullable
    public IRequestManager getRequestManager() {
        return this.requestManager;
    }

    @Override
    public boolean hasWillRaidTonight() {
        return false;
    }

    @Override
    public void markDirty() {
    }

    @Override
    public boolean canBeAutoDeleted() {
        return false;
    }

    @Override
    public boolean isCanHaveBarbEvents() {
        return false;
    }

    @Override
    public boolean isHasRaidBeenCalculated() {
        return false;
    }

    @Override
    @Nullable
    public IRequester getRequesterBuildingForPosition(@NotNull BlockPos pos) {
        return this.getBuilding(pos);
    }

    @Override
    public void removeVisitingPlayer(EntityPlayer player) {
    }

    @Override
    public void addVisitingPlayer(EntityPlayer player) {
    }

    public HappinessData getHappinessData() {
        return this.happinessData;
    }

    public Set<BlockPos> getWayPoints() {
        return new HashSet<BlockPos>(this.wayPoints);
    }

    public List<BlockPos> getLastSpawnPoints() {
        return new ArrayList<BlockPos>(this.lastSpawnPoints);
    }
}

