/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.google.common.io.Files;
import com.minecolonies.api.colony.IChunkmanagerCapability;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.permissions.Player;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.compatibility.CompatabilityManager;
import com.minecolonies.api.compatibility.ICompatabilityManager;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.crafting.IRecipeManager;
import com.minecolonies.api.util.ChunkLoadStorage;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyList;
import com.minecolonies.coremod.colony.ColonyManagerWorldAccess;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.HappinessData;
import com.minecolonies.coremod.colony.Structures;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.requestsystem.management.manager.StandardRecipeManager;
import com.minecolonies.coremod.network.messages.UpdateChunkCapabilityMessage;
import com.minecolonies.coremod.util.AchievementUtils;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServerMulti;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColonyManager {
    private static final String TAG_DISTANCE = "dist";
    private static final String TAG_NEW_COLONIES = "amountOfColonies";
    public static final String FILENAME_MINECOLONIES_PATH = "minecolonies";
    public static final String CHUNK_INFO_PATH = "minecolonies/chunkInfo";
    private static final String FILENAME_MINECOLONIES = "colonies.dat";
    private static final String FILENAME_MINECOLONIES_BACKUP = "colonies-%s.zip";
    private static final String UNABLE_TO_FIND_WORLD_CAP_TEXT = "Unable to find Chunk manager in world capability, please report this to the mod author!";
    private static final String TAG_COLONIES = "colonies";
    private static final String RECIPE_MANAGER_TAG = "recipeManager";
    private static final String TAG_UUID = "uuid";
    public static final String FILENAME_COLONY = "colony%d.dat";
    private static final int DISTANCE_TO_LOAD_IMMEDIATELY = 5;
    private static final DamageSource CONSOLE_DAMAGE_SOURCE = new DamageSource("Console");
    @NotNull
    private static final ColonyList<Colony> colonies = new ColonyList();
    @NotNull
    private static final Map<Integer, List<Colony>> coloniesByWorld = new HashMap<Integer, List<Colony>>();
    @NotNull
    private static final ColonyList<ColonyView> colonyViews = new ColonyList();
    private static int numWorldsLoaded;
    private static boolean saveNeeded;
    private static boolean schematicDownloaded;
    private static final IRecipeManager recipeManager;
    private static volatile UUID serverUUID;
    private static int missingChunksToLoad;
    private static final ICompatabilityManager compatabilityManager;

    private ColonyManager() {
    }

    public static void createColony(@NotNull World w, BlockPos pos, @NotNull EntityPlayer player, @NotNull String style) {
        Colony colony = colonies.create(w, pos);
        colony.setStyle(style);
        ColonyManager.addColonyByWorld(colony);
        String colonyName = LanguageHandler.format("com.minecolonies.coremod.gui.townHall.defaultName", player.getDisplayNameString());
        colony.setName(colonyName);
        colony.getPermissions().setPlayerRank(player.func_146103_bH().getId(), Rank.OWNER, w);
        colony.getStatsManager().triggerAchievement(ModAchievements.achievementGetSupply);
        colony.getStatsManager().triggerAchievement(ModAchievements.achievementTownhall);
        Log.getLogger().info(String.format("New Colony Id: %d by %s", colony.getID(), player.func_70005_c_()));
        if (colony.getWorld() == null) {
            Log.getLogger().error("Unable to claim chunks because of the missing world in the colony, please report this to the mod authors!");
            return;
        }
        ColonyManager.claimColonyChunks(colony.getWorld(), true, colony.getID(), colony.getCenter(), colony.getDimension());
        ColonyManager.markDirty();
    }

    private static void claimColonyChunks(World world, boolean add, int id, BlockPos center, int dimension) {
        Chunk centralChunk = world.func_175726_f(center);
        ColonyManager.loadChunkAndAddData(world, center, add, id);
        int chunkX = centralChunk.field_76635_g;
        int chunkZ = centralChunk.field_76647_h;
        int range = Configurations.gameplay.workingRangeTownHallChunks;
        int buffer = Configurations.gameplay.townHallPaddingChunk;
        ColonyManager.claimChunksInRange(id, dimension, add, chunkX, chunkZ, range, buffer, world);
    }

    public static void claimChunksInRange(int colonyId, int dimension, boolean add, int chunkX, int chunkZ, int range, int buffer, World world) {
        int maxRange = range * 2 + buffer;
        IChunkmanagerCapability chunkManager = (IChunkmanagerCapability)world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null);
        if (chunkManager == null) {
            Log.getLogger().error(UNABLE_TO_FIND_WORLD_CAP_TEXT);
            return;
        }
        for (int i = chunkX - maxRange; i <= chunkX + maxRange; ++i) {
            for (int j = chunkZ - maxRange; j <= chunkZ + maxRange; ++j) {
                if (i >= chunkX - 5 && j >= chunkZ - 5 && i <= chunkX + 5 && j <= chunkZ + 5 && ColonyManager.loadChunkAndAddData(world, new BlockPos(i * 16, 0, j * 16), add, colonyId)) continue;
                boolean owning = i >= chunkX - range && j >= chunkZ - range && i <= chunkX + range && j <= chunkZ + range;
                ChunkLoadStorage newStorage = new ChunkLoadStorage(colonyId, ChunkPos.func_77272_a((int)i, (int)j), add, dimension, owning);
                if (chunkManager.addChunkStorage(i, j, newStorage)) continue;
                ++missingChunksToLoad;
            }
        }
    }

    private static boolean loadChunkAndAddData(World world, BlockPos pos, boolean add, int id) {
        if (!world.func_175667_e(pos)) {
            return false;
        }
        Chunk chunk = world.func_175726_f(pos);
        if (((IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null)).getOwningColony() == id && add) {
            return false;
        }
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
        if (cap == null) {
            return false;
        }
        if (add) {
            cap.setOwningColony(id);
            cap.addColony(id);
        } else {
            cap.removeColony(id);
        }
        chunk.func_76630_e();
        MineColonies.getNetwork().sendToAll((IMessage)new UpdateChunkCapabilityMessage(cap, chunk.field_76635_g, chunk.field_76647_h));
        return true;
    }

    private static void addStorageToChunk(Chunk chunk, ChunkLoadStorage storage) {
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
        storage.applyToCap(cap);
        chunk.func_76630_e();
        if (cap != null) {
            MineColonies.getNetwork().sendToAll((IMessage)new UpdateChunkCapabilityMessage(cap, chunk.field_76635_g, chunk.field_76647_h));
        }
    }

    public static void loadChunk(Chunk chunk, World world) {
        if (missingChunksToLoad > 0) {
            IChunkmanagerCapability chunkManager = (IChunkmanagerCapability)world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null);
            if (chunkManager == null) {
                Log.getLogger().error(UNABLE_TO_FIND_WORLD_CAP_TEXT);
                return;
            }
            ChunkLoadStorage existingStorage = chunkManager.getChunkStorage(chunk.field_76635_g, chunk.field_76647_h);
            if (existingStorage != null) {
                ColonyManager.addStorageToChunk(chunk, existingStorage);
                --missingChunksToLoad;
            }
        }
    }

    private static void addColonyByWorld(Colony colony) {
        if (colony.getDimension() >= 0) {
            coloniesByWorld.computeIfAbsent(colony.getDimension(), ArrayList::new).add(colony);
        }
    }

    public static void markDirty() {
        saveNeeded = true;
    }

    public static void deleteColony(int id, boolean canDestroy) {
        try {
            Colony colony = ColonyManager.getColony(id);
            ColonyManager.claimColonyChunks(colony.getWorld(), false, id, colony.getCenter(), colony.getDimension());
            HashSet colonyWorlds = new HashSet();
            Log.getLogger().info("Removing citizens for " + id);
            for (CitizenData citizenData : new ArrayList<CitizenData>(colony.getCitizenManager().getCitizens())) {
                Log.getLogger().info("Kill Citizen " + citizenData.getName());
                citizenData.getCitizenEntity().ifPresent(entityCitizen -> {
                    World world = entityCitizen.func_130014_f_();
                    entityCitizen.func_70645_a(CONSOLE_DAMAGE_SOURCE);
                    colonyWorlds.add(world);
                });
            }
            if (canDestroy) {
                Log.getLogger().info("Removing buildings for " + id);
                for (AbstractBuilding building : new ArrayList<AbstractBuilding>(colony.getBuildingManager().getBuildings().values())) {
                    BlockPos location = building.getLocation();
                    Log.getLogger().info("Delete Building at " + location);
                    building.deconstruct();
                    building.destroy();
                    for (World world : colonyWorlds) {
                        if (!(world.func_180495_p(location).func_177230_c() instanceof AbstractBlockHut)) continue;
                        Log.getLogger().info("Found Block, deleting " + world.func_180495_p(location).func_177230_c());
                        world.func_175698_g(location);
                    }
                }
            }
            MinecraftForge.EVENT_BUS.unregister((Object)colony.getEventHandler());
            Log.getLogger().info("Deleting colony: " + colony.getID());
            colonies.remove(id);
            coloniesByWorld.get(colony.getDimension()).remove(colony);
            Log.getLogger().info("Done with " + id);
        }
        catch (RuntimeException e) {
            Log.getLogger().warn("Deleting Colony " + id + " errored:", (Throwable)e);
        }
        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), FILENAME_MINECOLONIES_PATH);
        File file = new File(saveDir, String.format(FILENAME_COLONY, id));
        file.delete();
        ColonyManager.markDirty();
    }

    public static Colony getColony(int id) {
        return colonies.get(id);
    }

    public static void syncAllColoniesAchievements() {
        colonies.forEach(AchievementUtils::syncAchievements);
    }

    public static AbstractBuilding getBuilding(@NotNull World w, @NotNull BlockPos pos) {
        AbstractBuilding building;
        Colony colony = ColonyManager.getColony(w, pos);
        if (colony != null && (building = colony.getBuildingManager().getBuilding(pos)) != null) {
            return building;
        }
        for (Colony otherColony : ColonyManager.getColonies(w)) {
            AbstractBuilding building2 = otherColony.getBuildingManager().getBuilding(pos);
            if (building2 == null) continue;
            return building2;
        }
        return null;
    }

    public static Colony getColony(@NotNull World w, @NotNull BlockPos pos) {
        Chunk centralChunk = w.func_175726_f(pos);
        int id = ((IColonyTagCapability)centralChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null)).getOwningColony();
        if (id == 0) {
            return null;
        }
        return ColonyManager.getColony(id);
    }

    public static boolean isTooCloseToColony(@NotNull World w, @NotNull BlockPos pos) {
        IChunkmanagerCapability worldCapability = (IChunkmanagerCapability)w.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null);
        if (worldCapability == null) {
            return true;
        }
        Chunk centralChunk = w.func_175726_f(pos);
        IColonyTagCapability colonyCap = (IColonyTagCapability)centralChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
        if (colonyCap == null) {
            return true;
        }
        ChunkLoadStorage storage = worldCapability.getChunkStorage(centralChunk.field_76635_g, centralChunk.field_76647_h);
        if (storage != null) {
            storage.applyToCap(colonyCap);
        }
        return !colonyCap.getAllCloseColonies().isEmpty();
    }

    @NotNull
    public static List<Colony> getColonies(@NotNull World w) {
        List<Colony> coloniesInWorld = coloniesByWorld.get(w.field_73011_w.getDimension());
        if (coloniesInWorld == null) {
            return Collections.emptyList();
        }
        return coloniesInWorld;
    }

    @NotNull
    public static List<Colony> getColonies() {
        return colonies.getCopyAsList();
    }

    @NotNull
    public static List<Colony> getColoniesAbandonedSince(int abandonedSince) {
        ArrayList<Colony> sortedList = new ArrayList<Colony>();
        for (Colony colony : colonies.getCopyAsList()) {
            if (colony.getLastContactInHours() < abandonedSince) continue;
            sortedList.add(colony);
        }
        return sortedList;
    }

    public static AbstractBuildingView getBuildingView(BlockPos pos) {
        for (ColonyView colony : colonyViews) {
            AbstractBuildingView building = colony.getBuilding(pos);
            if (building == null) continue;
            return building;
        }
        return null;
    }

    @Nullable
    public static IColony getIColony(@NotNull World w, @NotNull BlockPos pos) {
        return w.field_72995_K ? ColonyManager.getColonyView(w, pos) : ColonyManager.getColony(w, pos);
    }

    private static ColonyView getColonyView(@NotNull World w, @NotNull BlockPos pos) {
        Chunk centralChunk = w.func_175726_f(pos);
        int id = ((IColonyTagCapability)centralChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null)).getOwningColony();
        if (id == 0) {
            return null;
        }
        return ColonyManager.getColonyView(id);
    }

    @Nullable
    public static IColony getClosestIColony(@NotNull World w, @NotNull BlockPos pos) {
        return w.field_72995_K ? ColonyManager.getClosestColonyView(w, pos) : ColonyManager.getClosestColony(w, pos);
    }

    @Nullable
    public static ColonyView getClosestColonyView(@Nullable World w, @Nullable BlockPos pos) {
        if (w == null || pos == null) {
            return null;
        }
        Chunk chunk = w.func_175726_f(pos);
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
        if (cap.getOwningColony() != 0) {
            return ColonyManager.getColonyView(cap.getOwningColony());
        }
        if (!cap.getAllCloseColonies().isEmpty()) {
            ColonyView closestColony = null;
            long closestDist = Long.MAX_VALUE;
            for (int cId : cap.getAllCloseColonies()) {
                long dist;
                ColonyView c = ColonyManager.getColonyView(cId);
                if (c == null || c.getDimension() != w.field_73011_w.getDimension() || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
                closestColony = c;
                closestDist = dist;
            }
            return closestColony;
        }
        ColonyView closestColony = null;
        long closestDist = Long.MAX_VALUE;
        for (ColonyView c : colonyViews) {
            long dist;
            if (c.getDimension() != w.field_73011_w.getDimension() || c.getCenter() == null || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
            closestColony = c;
            closestDist = dist;
        }
        return closestColony;
    }

    public static Colony getClosestColony(@NotNull World w, @NotNull BlockPos pos) {
        Chunk chunk = w.func_175726_f(pos);
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
        if (cap.getOwningColony() != 0) {
            return ColonyManager.getColony(cap.getOwningColony());
        }
        if (!cap.getAllCloseColonies().isEmpty()) {
            Colony closestColony = null;
            long closestDist = Long.MAX_VALUE;
            for (int cId : cap.getAllCloseColonies()) {
                long dist;
                Colony c = ColonyManager.getColony(cId);
                if (c == null || c.getDimension() != w.field_73011_w.getDimension() || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
                closestColony = c;
                closestDist = dist;
            }
            return closestColony;
        }
        Colony closestColony = null;
        long closestDist = Long.MAX_VALUE;
        for (Colony c : ColonyManager.getColonies(w)) {
            long dist;
            if (c.getDimension() != w.field_73011_w.getDimension() || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
            closestColony = c;
            closestDist = dist;
        }
        return closestColony;
    }

    @Nullable
    public static IColony getIColonyByOwner(@NotNull World w, @NotNull EntityPlayer owner) {
        return ColonyManager.getIColonyByOwner(w, w.field_72995_K ? owner.func_110124_au() : owner.func_146103_bH().getId());
    }

    @Nullable
    public static IColony getIColonyByOwner(@NotNull World w, UUID owner) {
        return w.field_72995_K ? ColonyManager.getColonyViewByOwner(owner) : ColonyManager.getColonyByOwner(owner);
    }

    private static IColony getColonyViewByOwner(UUID owner) {
        for (ColonyView c : colonyViews) {
            Player p = c.getPlayers().get(owner);
            if (p == null || !p.getRank().equals((Object)Rank.OWNER)) continue;
            return c;
        }
        return null;
    }

    @Nullable
    private static IColony getColonyByOwner(@Nullable UUID owner) {
        if (owner == null) {
            return null;
        }
        return colonies.stream().filter(c -> owner.equals(c.getPermissions().getOwner())).findFirst().orElse(null);
    }

    public static int getMinimumDistanceBetweenTownHalls() {
        return 2 * Configurations.gameplay.workingRangeTownHallChunks * 16 + Configurations.gameplay.townHallPaddingChunk * 16;
    }

    public static void onServerTick(@NotNull TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (Colony c : colonies) {
                c.onServerTick(event);
            }
            if (saveNeeded) {
                ColonyManager.saveColonies(false);
            }
        }
    }

    private static void saveColonies(boolean isWorldUnload) {
        NBTTagCompound compound = new NBTTagCompound();
        ColonyManager.writeToNBT(compound);
        File file = ColonyManager.getSaveLocation();
        ColonyManager.saveNBTToPath(file, compound);
        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), FILENAME_MINECOLONIES_PATH);
        for (Colony colony : colonies) {
            if (isWorldUnload) {
                NBTTagCompound colonyCompound = new NBTTagCompound();
                colony.writeToNBT(colonyCompound);
                ColonyManager.saveNBTToPath(new File(saveDir, String.format(FILENAME_COLONY, colony.getID())), colonyCompound);
                continue;
            }
            ColonyManager.saveNBTToPath(new File(saveDir, String.format(FILENAME_COLONY, colony.getID())), colony.getColonyTag());
        }
        saveNeeded = false;
    }

    public static void writeToNBT(@NotNull NBTTagCompound compound) {
        if (serverUUID != null) {
            compound.func_186854_a(TAG_UUID, serverUUID);
        }
        NBTTagCompound compCompound = new NBTTagCompound();
        compatabilityManager.writeToNBT(compCompound);
        compound.func_74782_a("compatabilityManager", (NBTBase)compCompound);
        compound.func_74757_a(TAG_DISTANCE, true);
        NBTTagCompound recipeCompound = new NBTTagCompound();
        recipeManager.writeToNBT(recipeCompound);
        compound.func_74782_a(RECIPE_MANAGER_TAG, (NBTBase)recipeCompound);
        compound.func_74768_a(TAG_NEW_COLONIES, colonies.getTopID());
        compound.func_74768_a("missingChunks", missingChunksToLoad);
        compound.func_74757_a("allchunk", true);
    }

    @NotNull
    private static File getSaveLocation() {
        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), FILENAME_MINECOLONIES_PATH);
        return new File(saveDir, FILENAME_MINECOLONIES);
    }

    public static void saveNBTToPath(@Nullable File file, @NotNull NBTTagCompound compound) {
        try {
            if (file != null) {
                file.getParentFile().mkdir();
                CompressedStreamTools.func_74793_a((NBTTagCompound)compound, (File)file);
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when saving ColonyManager", (Throwable)exception);
        }
    }

    public static void onClientTick(@NotNull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71441_e == null && !colonyViews.isEmpty()) {
            colonyViews.clear();
        }
    }

    public static void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ColonyManager.getColonies(event.world).forEach(c -> c.onWorldTick(event));
        }
    }

    public static void onWorldLoad(@NotNull World world) {
        if (!world.field_72995_K && !(world instanceof WorldServerMulti)) {
            if (numWorldsLoaded == 0) {
                Structures.init();
                File file = ColonyManager.getSaveLocation();
                NBTTagCompound data = ColonyManager.loadNBTFromPath(file);
                if (data != null) {
                    ColonyManager.readFromNBT(data, world);
                    if (data.func_74764_b(TAG_NEW_COLONIES)) {
                        int size = data.func_74762_e(TAG_NEW_COLONIES);
                        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), FILENAME_MINECOLONIES_PATH);
                        for (int colonyId = 0; colonyId <= size; ++colonyId) {
                            NBTTagCompound colonyData = ColonyManager.loadNBTFromPath(new File(saveDir, String.format(FILENAME_COLONY, colonyId)));
                            if (colonyData == null) continue;
                            Colony colony = Colony.loadColony(colonyData, world);
                            colony.getCitizenManager().checkCitizensForHappiness();
                            colonies.add(colony);
                            ColonyManager.claimColonyChunks(colony.getWorld(), true, colony.getID(), colony.getCenter(), colony.getDimension());
                            ColonyManager.addColonyByWorld(colony);
                        }
                    }
                    Log.getLogger().info(String.format("Loaded %d colonies", colonies.getSize()));
                }
                if (serverUUID == null) {
                    serverUUID = UUID.randomUUID();
                    Log.getLogger().info(String.format("New Server UUID %s", serverUUID));
                    ColonyManager.markDirty();
                } else {
                    Log.getLogger().info(String.format("Server UUID %s", serverUUID));
                }
                if (!ColonyManager.backupColonyData()) {
                    MineColonies.getLogger().error("Failed to save colonies.dat backup!");
                }
            }
            ++numWorldsLoaded;
            for (Colony c : ColonyManager.getColonies(world)) {
                c.onWorldLoad(world);
            }
            world.func_72954_a((IWorldEventListener)new ColonyManagerWorldAccess());
        }
    }

    public static boolean backupColonyData() {
        if (numWorldsLoaded > 0 && saveNeeded) {
            ColonyManager.saveColonies(false);
        }
        try (FileOutputStream fos = new FileOutputStream(ColonyManager.getBackupSaveLocation(new Date()));){
            File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), FILENAME_MINECOLONIES_PATH);
            ZipOutputStream zos = new ZipOutputStream(fos);
            for (int i = 1; i < colonies.getTopID() + 1; ++i) {
                File file = new File(saveDir, String.format(FILENAME_COLONY, i));
                if (!file.exists()) continue;
                ColonyManager.addToZipFile(String.format(FILENAME_COLONY, i), zos, saveDir);
            }
            ColonyManager.addToZipFile(ColonyManager.getSaveLocation().getName(), zos, saveDir);
            zos.close();
            fos.close();
        }
        catch (Exception e) {
            Log.getLogger().warn("Unable to backup colony data, please contact an administrator");
            return false;
        }
        return true;
    }

    private static void addToZipFile(String fileName, ZipOutputStream zos, File folder) {
        File file = new File(folder, fileName);
        try (FileInputStream fis = new FileInputStream(file);){
            zos.putNextEntry(new ZipEntry(fileName));
            Files.copy((File)file, (OutputStream)zos);
        }
        catch (Exception e) {
            Log.getLogger().warn("Error packing " + fileName + " into the zip.");
        }
    }

    private static NBTTagCompound loadNBTFromPath(@Nullable File file) {
        try {
            if (file != null && file.exists()) {
                return CompressedStreamTools.func_74797_a((File)file);
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when loading file from path in ColonyManager!", (Throwable)exception);
        }
        return null;
    }

    public static void readFromNBT(@NotNull NBTTagCompound compound, @NotNull World world) {
        if (!compound.func_74764_b(TAG_DISTANCE)) {
            Configurations.gameplay.workingRangeTownHallChunks = (int)(Math.cos(0.7853981633974483) * (double)Configurations.gameplay.workingRangeTownHall / 16.0);
        }
        if (!compound.func_74764_b(TAG_NEW_COLONIES)) {
            NBTTagList colonyTags = compound.func_150295_c(TAG_COLONIES, 10);
            for (int i = 0; i < colonyTags.func_74745_c(); ++i) {
                Colony colony = Colony.loadColony(colonyTags.func_150305_b(i), world);
                colonies.add(colony);
                ColonyManager.addColonyByWorld(colony);
            }
        }
        if (compound.func_186855_b(TAG_UUID)) {
            serverUUID = compound.func_186857_a(TAG_UUID);
        }
        if (compound.func_74764_b("compatabilityManager")) {
            compatabilityManager.readFromNBT(compound.func_74775_l("compatabilityManager"));
        }
        compatabilityManager.discover(world);
        NBTTagCompound recipeCompound = compound.func_74775_l(RECIPE_MANAGER_TAG);
        recipeManager.readFromNBT(recipeCompound);
        missingChunksToLoad = compound.func_74762_e("missingChunks");
        if (!compound.func_74764_b("allchunk")) {
            ColonyManager.loadChunkStorageToWorldCapability(world);
        }
        Log.getLogger().info(String.format("Loaded %d colonies", colonies.getSize()));
    }

    private static void loadChunkStorageToWorldCapability(World world) {
        File chunkDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), CHUNK_INFO_PATH);
        if (!chunkDir.exists()) {
            return;
        }
        IChunkmanagerCapability chunkManager = (IChunkmanagerCapability)world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null);
        if (chunkManager == null) {
            Log.getLogger().error(UNABLE_TO_FIND_WORLD_CAP_TEXT);
            return;
        }
        File[] files = chunkDir.listFiles();
        if (files != null) {
            for (File file : files) {
                NBTTagCompound chunkData = ColonyManager.loadNBTFromPath(file);
                if (chunkData == null) continue;
                ChunkLoadStorage storage = new ChunkLoadStorage(chunkData);
                int z = (int)(storage.getXz() >> 32);
                int x = (int)storage.getXz();
                chunkManager.addChunkStorage(x, z, storage);
                file.delete();
            }
        }
    }

    @NotNull
    private static File getBackupSaveLocation(Date date) {
        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), FILENAME_MINECOLONIES_PATH);
        return new File(saveDir, String.format(FILENAME_MINECOLONIES_BACKUP, new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(date)));
    }

    public static UUID getServerUUID() {
        return serverUUID;
    }

    public static void setServerUUID(UUID uuid) {
        serverUUID = uuid;
    }

    public static void onWorldUnload(@NotNull World world) {
        if (!world.field_72995_K && !(world instanceof WorldServerMulti)) {
            if (world.field_73011_w.getDimension() == 0) {
                ColonyManager.saveColonies(true);
            }
            for (Colony c : ColonyManager.getColonies(world)) {
                c.onWorldUnload(world);
            }
            if (--numWorldsLoaded == 0) {
                colonies.clear();
                coloniesByWorld.clear();
            }
        }
    }

    public static void handleColonyViewMessage(int colonyId, @NotNull ByteBuf colonyData, @NotNull World world, boolean isNewSubscription) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view == null) {
            view = ColonyView.createFromNetwork(colonyId);
            colonyViews.add(view);
        }
        view.handleColonyViewMessage(colonyData, world, isNewSubscription);
    }

    public static ColonyView getColonyView(int id) {
        return colonyViews.get(id);
    }

    public static void handlePermissionsViewMessage(int colonyID, @NotNull ByteBuf data) {
        ColonyView view = ColonyManager.getColonyView(colonyID);
        if (view == null) {
            Log.getLogger().error(String.format("Colony view does not exist for ID #%d", colonyID));
        } else {
            view.handlePermissionsViewMessage(data);
        }
    }

    public static void handleColonyViewCitizensMessage(int colonyId, int citizenId, ByteBuf buf) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view == null) {
            return;
        }
        view.handleColonyViewCitizensMessage(citizenId, buf);
    }

    public static void handleColonyViewWorkOrderMessage(int colonyId, ByteBuf buf) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view == null) {
            return;
        }
        view.handleColonyViewWorkOrderMessage(buf);
    }

    public static void handleColonyViewRemoveCitizenMessage(int colonyId, int citizenId) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            view.handleColonyViewRemoveCitizenMessage(citizenId);
        }
    }

    public static void handleColonyBuildingViewMessage(int colonyId, BlockPos buildingId, @NotNull ByteBuf buf) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            view.handleColonyBuildingViewMessage(buildingId, buf);
        } else {
            Log.getLogger().error(String.format("Colony view does not exist for ID #%d", colonyId));
        }
    }

    public static void handleColonyViewRemoveBuildingMessage(int colonyId, BlockPos buildingId) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            view.handleColonyViewRemoveBuildingMessage(buildingId);
        }
    }

    public static void handleColonyViewRemoveWorkOrderMessage(int colonyId, int workOrderId) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            view.handleColonyViewRemoveWorkOrderMessage(workOrderId);
        }
    }

    public static void handleHappinessDataMessage(int colonyId, HappinessData data) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            view.handleHappinessDataMessage(data);
        }
    }

    public static boolean isSchematicDownloaded() {
        return schematicDownloaded;
    }

    public static void setSchematicDownloaded(boolean downloaded) {
        schematicDownloaded = downloaded;
    }

    public static boolean isCoordinateInAnyColony(@NotNull World world, BlockPos pos) {
        Chunk centralChunk = world.func_175726_f(pos);
        return ((IColonyTagCapability)centralChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null)).getOwningColony() != 0;
    }

    public static ICompatabilityManager getCompatabilityManager() {
        return compatabilityManager;
    }

    public static IRecipeManager getRecipeManager() {
        return recipeManager;
    }

    static {
        schematicDownloaded = false;
        recipeManager = new StandardRecipeManager();
        serverUUID = null;
        missingChunksToLoad = 0;
        compatabilityManager = new CompatabilityManager();
    }
}

