/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.inventory.InventoryCitizen;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenDataView {
    private static final String TAG_HELD_ITEM_SLOT = "HeldItemSlot";
    public static final String TAG_OFFHAND_HELD_ITEM_SLOT = "OffhandHeldItemSlot";
    private static final int MAX_LINES_OF_LATEST_LOG = 4;
    private final int id;
    private int entityId;
    private String name;
    private boolean female;
    private int colonyId;
    private int level;
    private double experience;
    private double health;
    private double maxHealth;
    private int strength;
    private int endurance;
    private int charisma;
    private int intelligence;
    private int dexterity;
    private double saturation;
    private String job;
    @Nullable
    private BlockPos homeBuilding;
    @Nullable
    private BlockPos workBuilding;
    private final ITextComponent[] latestStatus = new ITextComponent[4];
    private InventoryCitizen inventory;

    protected CitizenDataView(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFemale() {
        return this.female;
    }

    public int getLevel() {
        return this.level;
    }

    public double getExperience() {
        return this.experience;
    }

    public String getJob() {
        return this.job;
    }

    @Nullable
    public BlockPos getHomeBuilding() {
        return this.homeBuilding;
    }

    @Nullable
    public BlockPos getWorkBuilding() {
        return this.workBuilding;
    }

    public int getColonyId() {
        return this.colonyId;
    }

    public int getStrength() {
        return this.strength;
    }

    public int getEndurance() {
        return this.endurance;
    }

    public int getCharisma() {
        return this.charisma;
    }

    public double getSaturation() {
        return this.saturation;
    }

    public int getIntelligence() {
        return this.intelligence;
    }

    public int getDexterity() {
        return this.dexterity;
    }

    public double getHealth() {
        return this.health;
    }

    public double getMaxHealth() {
        return this.maxHealth;
    }

    public void deserialize(@NotNull ByteBuf buf) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.female = buf.readBoolean();
        this.entityId = buf.readInt();
        this.homeBuilding = buf.readBoolean() ? BlockPosUtil.readFromByteBuf(buf) : null;
        this.workBuilding = buf.readBoolean() ? BlockPosUtil.readFromByteBuf(buf) : null;
        this.level = buf.readInt();
        this.experience = buf.readDouble();
        this.health = buf.readFloat();
        this.maxHealth = buf.readFloat();
        this.strength = buf.readInt();
        this.endurance = buf.readInt();
        this.charisma = buf.readInt();
        this.intelligence = buf.readInt();
        this.dexterity = buf.readInt();
        this.saturation = buf.readDouble();
        this.job = ByteBufUtils.readUTF8String((ByteBuf)buf);
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            String textComp = ByteBufUtils.readUTF8String((ByteBuf)buf);
            TextComponentTranslation textComponent = new TextComponentTranslation(textComp, new Object[0]);
            this.latestStatus[i] = textComponent;
        }
        this.colonyId = buf.readInt();
        NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)buf);
        this.inventory = new InventoryCitizen(this.name, true);
        NBTTagList nbttaglist = compound.func_150295_c("inventory", 10);
        this.inventory.readFromNBT(nbttaglist);
        this.inventory.setHeldItem(EnumHand.MAIN_HAND, compound.func_74762_e(TAG_HELD_ITEM_SLOT));
        this.inventory.setHeldItem(EnumHand.OFF_HAND, compound.func_74762_e(TAG_OFFHAND_HELD_ITEM_SLOT));
    }

    public ITextComponent[] getLatestStatus() {
        return (ITextComponent[])this.latestStatus.clone();
    }

    public InventoryCitizen getInventory() {
        return this.inventory;
    }
}

