/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.render;

import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.tileentities.TileEntityInfoPoster;
import java.util.List;
import net.minecraft.block.BlockWallSign;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityInfoPosterRenderer
extends TileEntitySpecialRenderer<TileEntityInfoPoster> {
    private static final double BLOCK_MIDDLE = 0.5;
    private static final double SLIGHTLY_IN_FRONT = 0.01;
    private static final double SCALING_FACTOR = 0.010416666977107525;
    private static final double YOFFSET = 0.2;
    private static final int NINETY_DEGREE = 90;
    private static final int HALF_ROTATION = 180;
    private static final int THREE_QUARTERS = 270;
    private static final int MAX_TEXT_LENGTH = 90;
    private static final int TEXT_OFFSET_X = 10;
    private static final int TEXT_OFFSET_Y = 5;
    private IBakedModel model = null;

    public void render(TileEntityInfoPoster te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (this.model == null) {
            this.model = TileEntityInfoPosterRenderer.loadModel();
        }
        if (this.model == null) {
            return;
        }
        World world = te.func_145831_w();
        IBlockState state = world.func_180495_p(te.func_174877_v());
        BlockPos pos = te.func_174877_v();
        IBlockState actualState = state.func_177230_c().func_176221_a(state, (IBlockAccess)world, pos);
        int facing = (int)((EnumFacing)actualState.func_177229_b((IProperty)BlockWallSign.field_176412_a)).func_185119_l();
        double plusX = 0.0;
        double plusZ = 0.0;
        switch (facing) {
            case 90: {
                plusX += 1.0;
                plusZ += 1.0;
                break;
            }
            case 180: {
                plusZ += 1.0;
                facing = 0;
                break;
            }
            case 0: {
                facing = 180;
                plusX += 1.0;
                break;
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + plusX), (double)(y + 0.2), (double)(z + plusZ));
        GlStateManager.func_179114_b((float)facing, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179129_p();
        RenderHelper.func_74518_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int alpha2 = -16777216;
        GlStateManager.func_179147_l();
        GlStateManager.func_179098_w();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179143_c((int)515);
        TileEntityInfoPosterRenderer.renderModel(world, this.model, pos, -16777216);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        GlStateManager.func_179091_B();
        this.renderText(actualState, plusZ, plusX, te, x, y, z);
    }

    private static IBakedModel loadModel() {
        try {
            IModel mod = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("minecolonies", "block/blockInfoPoster"));
            IModelState state = mod.getDefaultState();
            return mod.bake(state, DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter());
        }
        catch (Exception e) {
            Log.getLogger().error("Error loading infoPoster texture", (Throwable)e);
            return null;
        }
    }

    private static void renderModel(World world, IBakedModel model, BlockPos pos, int alpha) {
        IBlockState state = world.func_180495_p(pos);
        IBlockState actualState = state.func_177230_c().func_176221_a(state, (IBlockAccess)world, pos);
        IBlockState iBlockExtendedState = state.func_177230_c().getExtendedState(state, (IBlockAccess)world, pos);
        for (EnumFacing facing : EnumFacing.values()) {
            TileEntityInfoPosterRenderer.renderQuads(world, actualState, pos, model.func_188616_a(actualState, facing, 0L), alpha);
        }
        TileEntityInfoPosterRenderer.renderQuads(world, actualState, pos, model.func_188616_a(iBlockExtendedState, null, 0L), alpha);
    }

    private void renderText(IBlockState actualState, double addZ, double addX, TileEntityInfoPoster te, double x, double y, double z) {
        GlStateManager.func_179094_E();
        FontRenderer fontrenderer = this.func_147498_b();
        double plusX = addX;
        double plusZ = addZ;
        int facing = (int)((EnumFacing)actualState.func_177229_b((IProperty)BlockWallSign.field_176412_a)).func_185119_l();
        switch (facing) {
            case 90: {
                facing = 270;
                plusZ -= 0.5;
                plusX -= 0.01;
                break;
            }
            case 180: {
                plusX += 0.5;
                plusZ -= 0.01;
                break;
            }
            case 270: {
                facing = 90;
                plusZ += 0.5;
                plusX += 0.01;
                break;
            }
            default: {
                plusX -= 0.5;
                plusZ += 0.01;
            }
        }
        GlStateManager.func_179137_b((double)(x + plusX), (double)(y + 0.4), (double)(z + plusZ));
        GlStateManager.func_179114_b((float)facing, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.010416666977107525, (double)-0.010416666977107525, (double)0.010416666977107525);
        GlStateManager.func_179132_a((boolean)false);
        for (int j = 0; j < te.signText.length; ++j) {
            if (te.signText[j] == null) continue;
            List list = GuiUtilRenderComponents.func_178908_a((ITextComponent)te.signText[j], (int)90, (FontRenderer)fontrenderer, (boolean)false, (boolean)true);
            String text = list != null && !list.isEmpty() ? ((ITextComponent)list.get(0)).func_150254_d() : "";
            fontrenderer.func_78276_b(text, -fontrenderer.func_78256_a(text) / 2, j * 10 - te.signText.length * 5, 0);
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private static void renderQuads(World world, IBlockState actualState, BlockPos pos, List<BakedQuad> quads, int alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        for (BakedQuad quad : quads) {
            buffer.func_181668_a(7, quad.getFormat());
            int color = quad.func_178212_b() ? TileEntityInfoPosterRenderer.getTint(world, actualState, pos, alpha, quad.func_178211_c()) : alpha | 0xFFFFFF;
            LightUtil.renderQuadColor((BufferBuilder)buffer, (BakedQuad)quad, (int)color);
            tessellator.func_78381_a();
        }
    }

    private static int getTint(World world, IBlockState actualState, BlockPos pos, int alpha, int tintIndex) {
        return alpha | Minecraft.func_71410_x().func_184125_al().func_186724_a(actualState, (IBlockAccess)world, pos, tintIndex);
    }
}

