/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.blockout.Color;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.controls.TextField;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowReplaceBlock;
import com.minecolonies.coremod.network.messages.RemoveBlockMessage;
import com.minecolonies.coremod.network.messages.RemoveEntityMessage;
import com.minecolonies.coremod.network.messages.ScanOnServerMessage;
import com.minecolonies.structures.helpers.Settings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowScan
extends AbstractWindowSkeleton {
    private static final String BUILDING_NAME_RESOURCE_SUFFIX = ":gui/windowscantool.xml";
    private static final int ENTER_KEY = 28;
    private final Map<String, ItemStorage> resources = new HashMap<String, ItemStorage>();
    private final Map<String, Entity> entities = new HashMap<String, Entity>();
    private static final int WHITE = Color.getByName("white", 0);
    private BlockPos pos1;
    private BlockPos pos2;
    private String filter = "";
    private final TextField pos1x;
    private final TextField pos1y;
    private final TextField pos1z;
    private final TextField pos2x;
    private final TextField pos2y;
    private final TextField pos2z;
    private final ScrollingList resourceList;
    private final ScrollingList entityList;

    public WindowScan(BlockPos pos1, BlockPos pos2) {
        super("minecolonies:gui/windowscantool.xml");
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.registerButton("confirm", this::confirmClicked);
        this.registerButton("cancel", this::discardClicked);
        this.registerButton("showRes", this::showResClicked);
        this.registerButton("removeEntity", this::removeEntity);
        this.registerButton("removeBlock", this::removeBlock);
        this.registerButton("replaceBlock", this::replaceBlock);
        this.pos1x = this.findPaneOfTypeByID("pos1x", TextField.class);
        this.pos1y = this.findPaneOfTypeByID("pos1y", TextField.class);
        this.pos1z = this.findPaneOfTypeByID("pos1z", TextField.class);
        this.pos2x = this.findPaneOfTypeByID("pos2x", TextField.class);
        this.pos2y = this.findPaneOfTypeByID("pos2y", TextField.class);
        this.pos2z = this.findPaneOfTypeByID("pos2z", TextField.class);
        this.resourceList = this.findPaneOfTypeByID("resources", ScrollingList.class);
        this.entityList = this.findPaneOfTypeByID("entities", ScrollingList.class);
    }

    private void showResClicked() {
        this.findPaneOfTypeByID("filter", TextField.class).show();
        this.findPaneOfTypeByID("showRes", Button.class).hide();
        this.updateResources();
    }

    private void removeEntity(Button button) {
        int x1 = Integer.parseInt(this.pos1x.getText());
        int y1 = Integer.parseInt(this.pos1y.getText());
        int z1 = Integer.parseInt(this.pos1z.getText());
        int x2 = Integer.parseInt(this.pos2x.getText());
        int y2 = Integer.parseInt(this.pos2y.getText());
        int z2 = Integer.parseInt(this.pos2z.getText());
        int row = this.entityList.getListElementIndexByPane(button);
        Entity entity = new ArrayList<Entity>(this.entities.values()).get(row);
        MineColonies.getNetwork().sendToServer((IMessage)new RemoveEntityMessage(new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2), entity.func_70005_c_()));
        this.entities.remove(entity.func_70005_c_());
        this.updateEntitylist();
    }

    private void removeBlock(Button button) {
        int x1 = Integer.parseInt(this.pos1x.getText());
        int y1 = Integer.parseInt(this.pos1y.getText());
        int z1 = Integer.parseInt(this.pos1z.getText());
        int x2 = Integer.parseInt(this.pos2x.getText());
        int y2 = Integer.parseInt(this.pos2y.getText());
        int z2 = Integer.parseInt(this.pos2z.getText());
        int row = this.resourceList.getListElementIndexByPane(button);
        ArrayList<ItemStorage> tempRes = new ArrayList<ItemStorage>(this.resources.values());
        ItemStack stack = ((ItemStorage)tempRes.get(row)).getItemStack();
        MineColonies.getNetwork().sendToServer((IMessage)new RemoveBlockMessage(new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2), stack));
        int hashCode = stack.func_77942_o() ? stack.func_77978_p().hashCode() : 0;
        this.resources.remove(stack.func_77977_a() + ":" + stack.func_77952_i() + "-" + hashCode);
        this.updateResourceList();
    }

    private void replaceBlock(Button button) {
        int x1 = Integer.parseInt(this.pos1x.getText());
        int y1 = Integer.parseInt(this.pos1y.getText());
        int z1 = Integer.parseInt(this.pos1z.getText());
        int x2 = Integer.parseInt(this.pos2x.getText());
        int y2 = Integer.parseInt(this.pos2y.getText());
        int z2 = Integer.parseInt(this.pos2z.getText());
        int row = this.resourceList.getListElementIndexByPane(button);
        ArrayList<ItemStorage> tempRes = new ArrayList<ItemStorage>(this.resources.values());
        new WindowReplaceBlock(((ItemStorage)tempRes.get(row)).getItemStack(), new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2)).open();
    }

    @Override
    public void onOpened() {
        super.onOpened();
        if (!Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
            this.pos1x.disable();
            this.pos1y.disable();
            this.pos1z.disable();
            this.pos2x.disable();
            this.pos2y.disable();
            this.pos2z.disable();
        }
        this.pos1x.setText(String.valueOf(this.pos1.func_177958_n()));
        this.pos1y.setText(String.valueOf(this.pos1.func_177956_o()));
        this.pos1z.setText(String.valueOf(this.pos1.func_177952_p()));
        this.pos2x.setText(String.valueOf(this.pos2.func_177958_n()));
        this.pos2y.setText(String.valueOf(this.pos2.func_177956_o()));
        this.pos2z.setText(String.valueOf(this.pos2.func_177952_p()));
        Settings.instance.setBox((Tuple<BlockPos, BlockPos>)new Tuple((Object)this.pos1, (Object)this.pos2));
    }

    private void discardClicked() {
        Settings.instance.setBox(null);
        this.close();
    }

    private void confirmClicked() {
        String name = this.findPaneOfTypeByID("name", TextField.class).getText();
        int x1 = Integer.parseInt(this.pos1x.getText());
        int y1 = Integer.parseInt(this.pos1y.getText());
        int z1 = Integer.parseInt(this.pos1z.getText());
        int x2 = Integer.parseInt(this.pos2x.getText());
        int y2 = Integer.parseInt(this.pos2y.getText());
        int z2 = Integer.parseInt(this.pos2z.getText());
        MineColonies.getNetwork().sendToServer((IMessage)new ScanOnServerMessage(new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2), name));
        Settings.instance.setBox(null);
        this.close();
    }

    @Override
    public boolean onKeyTyped(char ch, int key) {
        boolean result = super.onKeyTyped(ch, key);
        String name = this.findPaneOfTypeByID("filter", TextField.class).getText();
        if (!name.isEmpty()) {
            this.filter = name;
        }
        this.updateResources();
        return result;
    }

    private void updateResources() {
        try {
            int x1 = Integer.parseInt(this.pos1x.getText());
            int y1 = Integer.parseInt(this.pos1y.getText());
            int z1 = Integer.parseInt(this.pos1z.getText());
            this.pos1 = new BlockPos(x1, y1, z1);
            int x2 = Integer.parseInt(this.pos2x.getText());
            int y2 = Integer.parseInt(this.pos2y.getText());
            int z2 = Integer.parseInt(this.pos2z.getText());
            this.pos2 = new BlockPos(x2, y2, z2);
        }
        catch (NumberFormatException e) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Invalid Number - Closing!"));
            this.close();
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        this.resources.clear();
        this.entities.clear();
        for (int x = Math.min(this.pos1.func_177958_n(), this.pos2.func_177958_n()); x <= Math.max(this.pos1.func_177958_n(), this.pos2.func_177958_n()); ++x) {
            for (int y = Math.min(this.pos1.func_177956_o(), this.pos2.func_177956_o()); y <= Math.max(this.pos1.func_177956_o(), this.pos2.func_177956_o()); ++y) {
                for (int z = Math.min(this.pos1.func_177952_p(), this.pos2.func_177952_p()); z <= Math.max(this.pos1.func_177952_p(), this.pos2.func_177952_p()); ++z) {
                    Block block;
                    BlockPos here = new BlockPos(x, y, z);
                    IBlockState blockState = world.func_180495_p(here);
                    TileEntity tileEntity = world.func_175625_s(here);
                    List list = world.func_72872_a(Entity.class, new AxisAlignedBB(here));
                    for (Entity entity : list) {
                        if (this.entities.containsKey(entity.func_70005_c_()) || !this.filter.isEmpty() && !entity.func_70005_c_().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) && !entity.toString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US))) continue;
                        this.entities.put(entity.func_70005_c_(), entity);
                    }
                    if (here == null || (block = blockState.func_177230_c()) == null) continue;
                    if (tileEntity != null) {
                        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(ItemStackUtils.getItemStacksOfTileEntity(tileEntity.func_189515_b(new NBTTagCompound()), (World)world));
                        for (ItemStack stack : itemList) {
                            this.addNeededResource(stack, 1);
                        }
                    }
                    if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                        this.addNeededResource(new ItemStack(Items.field_151131_as, 1), 1);
                    } else if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
                        this.addNeededResource(new ItemStack(Items.field_151129_at, 1), 1);
                    } else if (block == Blocks.field_150350_a) {
                        this.addNeededResource(new ItemStack(Blocks.field_150350_a, 1), 1);
                    }
                    this.addNeededResource(BlockUtils.getItemStackFromBlockState(blockState), 1);
                }
            }
        }
        this.window.findPaneOfTypeByID("resources", ScrollingList.class).refreshElementPanes();
        this.updateResourceList();
        this.updateEntitylist();
    }

    public void addNeededResource(@Nullable ItemStack res, int amount) {
        if (res == null || amount == 0) {
            return;
        }
        int hashCode = res.func_77942_o() ? res.func_77978_p().hashCode() : 0;
        ItemStorage resource = this.resources.get(res.func_77977_a() + ":" + res.func_77952_i() + "-" + hashCode);
        if (resource == null) {
            resource = new ItemStorage(res);
            resource.setAmount(amount);
        } else {
            resource.setAmount(resource.getAmount() + amount);
        }
        if (this.filter.isEmpty() || res.func_77977_a().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || res.func_82833_r().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US))) {
            this.resources.put(res.func_77977_a() + ":" + res.func_77952_i() + "-" + hashCode, resource);
        }
    }

    public void updateEntitylist() {
        this.entityList.enable();
        this.entityList.show();
        final ArrayList<Entity> tempEntities = new ArrayList<Entity>(this.entities.values());
        this.entityList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return tempEntities.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                rowPane.findPaneOfTypeByID("resourceName", Label.class).setLabelText(((Entity)tempEntities.get(index)).func_70005_c_());
                if (!Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
                    rowPane.findPaneOfTypeByID("removeEntity", Button.class).hide();
                }
            }
        });
    }

    public void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        final ArrayList<ItemStorage> tempRes = new ArrayList<ItemStorage>(this.resources.values());
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return tempRes.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStorage resource = (ItemStorage)tempRes.get(index);
                Label resourceLabel = rowPane.findPaneOfTypeByID("resourceName", Label.class);
                Label quantityLabel = rowPane.findPaneOfTypeByID("resourceQuantity", Label.class);
                resourceLabel.setLabelText(resource.getItemStack().func_82833_r());
                quantityLabel.setLabelText(Integer.toString(resource.getAmount()));
                resourceLabel.setColor(WHITE, WHITE);
                quantityLabel.setColor(WHITE, WHITE);
                rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class).setItem(new ItemStack(resource.getItem(), 1, resource.getDamageValue()));
                if (!Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
                    rowPane.findPaneOfTypeByID("removeBlock", Button.class).hide();
                    rowPane.findPaneOfTypeByID("replaceBlock", Button.class).hide();
                }
            }
        });
    }
}

