/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.blockout.Color;
import com.minecolonies.blockout.Log;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonHandler;
import com.minecolonies.blockout.controls.Image;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.Box;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowRequestDetail
extends Window
implements ButtonHandler {
    private static final int BLACK = Color.getByName("black", 0);
    private static final String BUILDING_NAME_RESOURCE_SUFFIX = ":gui/windowrequestdetail.xml";
    private static final String BOX_ID_REQUEST = "requestDetail";
    private static final String REQUESTER = "requester";
    private static final String LIST_ELEMENT_ID_REQUEST_STACK = "requestStack";
    private static final int LIFE_COUNT_DIVIDER = 30;
    private static final String LIST_ELEMENT_ID_REQUEST_LOCATION = "targetLocation";
    private static final int Y_OFFSET_EACH_TEXTFIELD = 10;
    private static final int WRAP_AFTER_X = 30;
    private static final String RESOLVER = "resolver";
    private static final String DELIVERY_IMAGE = "deliveryImage";
    private final CitizenDataView citizen;
    private final IRequest request;
    private final int colonyId;
    private int lifeCount = 0;

    public WindowRequestDetail(@Nullable CitizenDataView c, IRequest request, int colonyId) {
        super("minecolonies:gui/windowrequestdetail.xml");
        this.citizen = c;
        this.request = request;
        this.colonyId = colonyId;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!GuiScreen.func_146272_n()) {
            ++this.lifeCount;
        }
        ItemIcon exampleStackDisplay = this.findPaneOfTypeByID(LIST_ELEMENT_ID_REQUEST_STACK, ItemIcon.class);
        List<ItemStack> displayStacks = this.request.getDisplayStacks();
        if (!displayStacks.isEmpty()) {
            exampleStackDisplay.setItem(displayStacks.get(this.lifeCount / 30 % displayStacks.size()));
        } else {
            exampleStackDisplay.setItem(ItemStackUtils.EMPTY);
        }
    }

    @Override
    public void onOpened() {
        String[] labels = new String[]{this.request.getLongDisplayString().func_150254_d()};
        Box box = this.findPaneOfTypeByID(BOX_ID_REQUEST, Box.class);
        int y = 10;
        int availableLabelWidth = box.getInteriorWidth() - 1 - box.getX();
        for (String s : labels) {
            String labelText = "\u00a7r\u00a70" + s;
            List multilineLabelStrings = this.mc.field_71466_p.func_78271_c(labelText, availableLabelWidth);
            for (String splitLabelText : multilineLabelStrings) {
                Label descriptionLabel = new Label();
                descriptionLabel.setColor(BLACK, BLACK);
                descriptionLabel.setLabelText(splitLabelText);
                box.addChild(descriptionLabel);
                descriptionLabel.setPosition(1, y);
                y += 10;
            }
        }
        ItemIcon exampleStackDisplay = this.findPaneOfTypeByID(LIST_ELEMENT_ID_REQUEST_STACK, ItemIcon.class);
        List<ItemStack> displayStacks = this.request.getDisplayStacks();
        if (!displayStacks.isEmpty()) {
            exampleStackDisplay.setItem(displayStacks.get(this.lifeCount / 30 % displayStacks.size()));
        } else {
            Image logo = this.findPaneOfTypeByID(DELIVERY_IMAGE, Image.class);
            logo.setVisible(true);
            logo.setImage(this.request.getDisplayIcon());
        }
        ColonyView view = ColonyManager.getColonyView(this.colonyId);
        this.findPaneOfTypeByID(REQUESTER, Label.class).setLabelText(this.request.getRequester().getDisplayName(view.getRequestManager(), (IToken<?>)this.request.getToken()).func_150254_d());
        Label targetLabel = this.findPaneOfTypeByID(LIST_ELEMENT_ID_REQUEST_LOCATION, Label.class);
        targetLabel.setLabelText(this.request.getRequester().getDeliveryLocation().toString());
        ColonyView colony = ColonyManager.getColonyView(this.colonyId);
        if (colony == null) {
            Log.getLogger().warn("---Colony Null in WindowRequestDetail---");
            return;
        }
        try {
            IRequestResolver<?> resolver = colony.getRequestManager().getResolverForRequest((IToken<?>)this.request.getToken());
            if (resolver == null) {
                Log.getLogger().warn("---IRequestResolver Null in WindowRequestDetail---");
                return;
            }
            this.findPaneOfTypeByID(RESOLVER, Label.class).setLabelText("Resolver: " + resolver.getDisplayName(view.getRequestManager(), (IToken<?>)this.request.getToken()).func_150254_d());
        }
        catch (IllegalArgumentException e) {
            Log.getLogger().warn("---IRequestResolver Null in WindowRequestDetail---", (Throwable)e);
        }
        box.setSize(box.getWidth(), y);
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        if (this.citizen != null) {
            MineColonies.proxy.showCitizenWindow(this.citizen);
        } else {
            MineColonies.proxy.openClipBoardWindow(this.colonyId);
        }
    }
}

