/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.blockout.Color;
import com.minecolonies.blockout.Log;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonHandler;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.controls.TextField;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.WindowScan;
import com.minecolonies.coremod.network.messages.ReplaceBlockMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowReplaceBlock
extends Window
implements ButtonHandler {
    private static final String BUTTON_DONE = "done";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String INPUT_NAME = "name";
    private static final String WINDOW_REPLACE_BLOCK = ":gui/windowreplaceblock.xml";
    private final ItemStack from;
    private final BlockPos pos1;
    private static final int WHITE = Color.getByName("white", 0);
    private final BlockPos pos2;
    private final List<ItemStack> allItems = new ArrayList<ItemStack>();
    private final ScrollingList resourceList;
    private String filter = "";

    public WindowReplaceBlock(@NotNull ItemStack initialStack, BlockPos pos1, BlockPos pos2) {
        super("minecolonies:gui/windowreplaceblock.xml");
        this.from = initialStack;
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.resourceList = this.findPaneOfTypeByID("resources", ScrollingList.class);
    }

    @Override
    public void onOpened() {
        this.findPaneOfTypeByID("resourceIconFrom", ItemIcon.class).setItem(this.from);
        this.findPaneOfTypeByID("resourceNameFrom", Label.class).setLabelText(this.from.func_77977_a());
        this.updateResources();
    }

    private void updateResources() {
        this.allItems.clear();
        this.allItems.addAll((Collection<ItemStack>)ImmutableList.copyOf((Collection)StreamSupport.stream(Spliterators.spliteratorUnknownSize(Item.field_150901_e.iterator(), 16), false).flatMap(item -> {
            NonNullList stacks = NonNullList.func_191196_a();
            try {
                item.func_150895_a(CreativeTabs.field_78027_g, stacks);
            }
            catch (Exception ex) {
                Log.getLogger().warn("Failed to get sub items from: " + item.getRegistryName(), (Throwable)ex);
            }
            return stacks.stream().filter(stack -> !(!(stack.func_77973_b() instanceof ItemBlock) && !(stack.func_77973_b() instanceof ItemDoor) || !this.filter.isEmpty() && !stack.func_77977_a().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US))));
        }).collect(Collectors.toList())));
        ArrayList<ItemStack> specialBlockList = new ArrayList<ItemStack>();
        specialBlockList.add(new ItemStack(Items.field_151131_as));
        specialBlockList.add(new ItemStack(Items.field_151129_at));
        specialBlockList.add(new ItemStack(Items.field_151117_aB));
        this.allItems.addAll(specialBlockList.stream().filter(stack -> this.filter.isEmpty() || stack.func_77977_a().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || stack.func_82833_r().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US))).collect(Collectors.toList()));
        this.updateResourceList();
    }

    @Override
    public boolean onKeyTyped(char ch, int key) {
        boolean result = super.onKeyTyped(ch, key);
        String name = this.findPaneOfTypeByID(INPUT_NAME, TextField.class).getText();
        if (!name.isEmpty()) {
            this.filter = name;
        }
        this.updateResources();
        return result;
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        if (button.getID().equals(BUTTON_DONE)) {
            ItemStack to = this.findPaneOfTypeByID("resourceIconTo", ItemIcon.class).getItem();
            if (!ItemStackUtils.isEmpty(to).booleanValue()) {
                MineColonies.getNetwork().sendToServer((IMessage)new ReplaceBlockMessage(this.pos1, this.pos2, this.from, to));
                new WindowScan(this.pos1, this.pos2).open();
            }
        } else if (button.getID().equals(BUTTON_CANCEL)) {
            new WindowScan(this.pos1, this.pos2).open();
        } else if (button.getID().equals("select")) {
            int row = this.resourceList.getListElementIndexByPane(button);
            ItemStack to = this.allItems.get(row);
            this.findPaneOfTypeByID("resourceIconTo", ItemIcon.class).setItem(to);
            this.findPaneOfTypeByID("resourceNameTo", Label.class).setLabelText(to.func_77977_a());
        }
    }

    public void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        final ArrayList<ItemStack> tempRes = new ArrayList<ItemStack>(this.allItems);
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return tempRes.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = (ItemStack)tempRes.get(index);
                Label resourceLabel = rowPane.findPaneOfTypeByID("resourceName", Label.class);
                resourceLabel.setLabelText(resource.func_82833_r());
                resourceLabel.setColor(WHITE, WHITE);
                rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class).setItem(resource);
            }
        });
    }
}

