/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.Color;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.SwitchView;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.network.messages.MinerSetLevelMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowHutMiner
extends AbstractWindowWorkerBuilding<BuildingMiner.View> {
    private static final String LIST_LEVELS = "levels";
    private static final String PAGE_LEVELS = "levelActions";
    private static final String BUTTON_CURRENTLEVEL = "changeToLevel";
    private static final String VIEW_PAGES = "pages";
    private static final String HUT_MINER_RESOURCE_SUFFIX = ":gui/windowhutminer.xml";
    private final BuildingMiner.View miner;
    private int[] levels;
    private ScrollingList levelList;

    public WindowHutMiner(BuildingMiner.View building) {
        super(building, "minecolonies:gui/windowhutminer.xml");
        this.miner = building;
        this.pullLevelsFromHut();
    }

    private void pullLevelsFromHut() {
        if (this.miner.getColony().getBuilding(this.miner.getID()) != null) {
            this.levels = this.miner.levels;
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.levelList = this.findPaneOfTypeByID(LIST_LEVELS, ScrollingList.class);
        this.levelList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowHutMiner.this.levels.length;
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                if (index == ((WindowHutMiner)WindowHutMiner.this).miner.current) {
                    rowPane.findPaneOfTypeByID("lvl", Label.class).setColor(Color.getByName("red", 0));
                } else {
                    rowPane.findPaneOfTypeByID("lvl", Label.class).setColor(Color.getByName("black", 0));
                }
                rowPane.findPaneOfTypeByID("lvl", Label.class).setLabelText(Integer.toString(index));
                rowPane.findPaneOfTypeByID("nONodes", Label.class).setLabelText(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.minerNode", new Object[0]) + ": " + WindowHutMiner.this.levels[index]);
            }
        });
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerHuts.minerHut";
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        String currentPage = this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).getCurrentView().getID();
        if (currentPage.equals(PAGE_LEVELS)) {
            this.pullLevelsFromHut();
            this.window.findPaneOfTypeByID(LIST_LEVELS, ScrollingList.class).refreshElementPanes();
        }
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        if (button.getID().equals(BUTTON_CURRENTLEVEL)) {
            int row = this.levelList.getListElementIndexByPane(button);
            if (row != this.miner.current && row >= 0 && row < this.levels.length) {
                this.miner.current = row;
                MineColonies.getNetwork().sendToServer((IMessage)new MinerSetLevelMessage(this.miner, row));
            }
        } else {
            super.onButtonClicked(button);
        }
    }
}

