/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.SwitchView;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLumberjack;
import com.minecolonies.coremod.network.messages.LumberjackReplantSaplingToggleMessage;
import com.minecolonies.coremod.network.messages.LumberjackSaplingSelectorMessage;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowHutLumberjack
extends AbstractWindowWorkerBuilding<BuildingLumberjack.View> {
    private static final String LIST_SAPLINGS = "trees";
    private static final String PAGE_SAPLINGS = "saplingActions";
    private static final String BUTTON_CURRENT_SAPLING = "switch";
    private static final String BUTTON_TOGGLE_ALL = "toggleAll";
    private static final String BUTTON_TOGGLE_REPLANT = "saplingReplant";
    private static final String ON = LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.retrieveOn", new Object[0]);
    private static final String OFF = LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.retrieveOff", new Object[0]);
    private static final String VIEW_PAGES = "pages";
    private final Map<ItemStorage, Boolean> treesToFell = new LinkedHashMap<ItemStorage, Boolean>();
    private final BuildingLumberjack.View ownBuilding;
    private ScrollingList saplingsList;

    public WindowHutLumberjack(BuildingLumberjack.View building) {
        super(building, "minecolonies:gui/windowHutLumberjack.xml");
        this.ownBuilding = building;
        this.pullLevelsFromHut();
    }

    private void switchReplant() {
        this.ownBuilding.shouldReplant = !this.ownBuilding.shouldReplant;
        MineColonies.getNetwork().sendToServer((IMessage)new LumberjackReplantSaplingToggleMessage((BuildingLumberjack.View)this.building, this.ownBuilding.shouldReplant));
        this.updateReplantButton();
    }

    private void updateReplantButton() {
        Button buttonReplant = this.findPaneOfTypeByID(BUTTON_TOGGLE_REPLANT, Button.class);
        if (this.ownBuilding.shouldReplant) {
            buttonReplant.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.toggleReplantSaplingsOn", new Object[0]));
        } else {
            buttonReplant.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.toggleReplantSaplingsOff", new Object[0]));
        }
    }

    private void pullLevelsFromHut() {
        if (((BuildingLumberjack.View)this.building).getColony().getBuilding(((BuildingLumberjack.View)this.building).getID()) != null) {
            this.treesToFell.clear();
            this.treesToFell.putAll(((BuildingLumberjack.View)this.building).treesToFell);
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.updateReplantButton();
        this.saplingsList = this.findPaneOfTypeByID(LIST_SAPLINGS, ScrollingList.class);
        this.saplingsList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowHutLumberjack.this.treesToFell.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack sapling = WindowHutLumberjack.this.treesToFell.keySet().toArray(new ItemStorage[WindowHutLumberjack.this.treesToFell.size()])[index].getItemStack();
                rowPane.findPaneOfTypeByID("symbol", ItemIcon.class).setItem(sapling);
                rowPane.findPaneOfTypeByID("name", Label.class).setLabelText(sapling.func_82833_r());
                Button switchButton = rowPane.findPaneOfTypeByID(WindowHutLumberjack.BUTTON_CURRENT_SAPLING, Button.class);
                if (WindowHutLumberjack.this.treesToFell.containsKey(new ItemStorage(sapling)) && ((Boolean)WindowHutLumberjack.this.treesToFell.get(new ItemStorage(sapling))).booleanValue()) {
                    switchButton.setLabel(ON);
                } else {
                    switchButton.setLabel(OFF);
                }
            }
        });
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.job.Lumberjack";
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        String currentPage = this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).getCurrentView().getID();
        if (currentPage.equals(PAGE_SAPLINGS)) {
            this.pullLevelsFromHut();
            this.window.findPaneOfTypeByID(LIST_SAPLINGS, ScrollingList.class).refreshElementPanes();
        }
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        if (button.getID().equals(BUTTON_CURRENT_SAPLING)) {
            int row = this.saplingsList.getListElementIndexByPane(button);
            ItemStorage saplingStack = this.treesToFell.keySet().toArray(new ItemStorage[this.treesToFell.size()])[row];
            boolean shouldCut = this.treesToFell.get(saplingStack) == false;
            this.treesToFell.put(saplingStack, shouldCut);
            MineColonies.getNetwork().sendToServer((IMessage)new LumberjackSaplingSelectorMessage((BuildingLumberjack.View)this.building, saplingStack.getItemStack(), shouldCut));
            this.ownBuilding.treesToFell.clear();
            this.ownBuilding.treesToFell.putAll(this.treesToFell);
        } else if (button.getID().equals(BUTTON_TOGGLE_ALL)) {
            boolean on = button.getLabel().equals(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.toggleAllOn", new Object[0]));
            if (on) {
                button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.toggleAllOff", new Object[0]));
            } else {
                button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.toggleAllOn", new Object[0]));
            }
            for (Map.Entry<ItemStorage, Boolean> entry : new HashSet<Map.Entry<ItemStorage, Boolean>>(this.treesToFell.entrySet())) {
                this.treesToFell.put(entry.getKey(), on);
            }
            this.ownBuilding.treesToFell.clear();
            this.ownBuilding.treesToFell.putAll(this.treesToFell);
        } else if (button.getID().equals(BUTTON_TOGGLE_REPLANT)) {
            this.switchReplant();
        } else {
            super.onButtonClicked(button);
        }
    }
}

