/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonHandler;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.network.messages.HireFireMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowHireWorker
extends Window
implements ButtonHandler {
    private static final String BUTTON_DONE = "done";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String CITIZEN_LABEL = "citizen";
    private static final String ID_LABEL = "id";
    private static final String CITIZEN_LIST = "unemployed";
    private static final String ATTRIBUTES_LABEL = "attributes";
    private static final String BUILDING_NAME_RESOURCE_SUFFIX = ":gui/windowhireworker.xml";
    private static final int CITIZEN_ID_LABEL_POSITION = 4;
    private static final String BUTTON_FIRE = "fire";
    private final AbstractBuildingWorker.View building;
    private final ColonyView colony;
    private List<CitizenDataView> citizens = new ArrayList<CitizenDataView>();

    public WindowHireWorker(ColonyView c, BlockPos buildingId) {
        super("minecolonies:gui/windowhireworker.xml");
        this.colony = c;
        this.building = (AbstractBuildingWorker.View)this.colony.getBuilding(buildingId);
        this.updateCitizens();
    }

    private void updateCitizens() {
        this.citizens.clear();
        this.citizens.addAll(this.colony.getCitizens().values());
        this.citizens = this.colony.getCitizens().values().stream().filter(citizen -> citizen.getWorkBuilding() == null && !this.building.hasEnoughWorkers() || this.building.getLocation().equals((Object)citizen.getWorkBuilding())).sorted(Comparator.comparing(CitizenDataView::getName)).collect(Collectors.toList());
    }

    @Override
    public void onOpened() {
        this.updateCitizens();
        ScrollingList citizenList = this.findPaneOfTypeByID(CITIZEN_LIST, ScrollingList.class);
        citizenList.enable();
        citizenList.show();
        citizenList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowHireWorker.this.citizens.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                CitizenDataView citizen = (CitizenDataView)WindowHireWorker.this.citizens.get(index);
                AbstractBuildingWorker.Skill primary = WindowHireWorker.this.building.getPrimarySkill();
                AbstractBuildingWorker.Skill secondary = WindowHireWorker.this.building.getSecondarySkill();
                if (citizen.getWorkBuilding() == null) {
                    rowPane.findPaneOfTypeByID(WindowHireWorker.BUTTON_DONE, Button.class).show();
                    rowPane.findPaneOfTypeByID(WindowHireWorker.BUTTON_FIRE, Button.class).hide();
                } else {
                    rowPane.findPaneOfTypeByID(WindowHireWorker.BUTTON_DONE, Button.class).hide();
                    rowPane.findPaneOfTypeByID(WindowHireWorker.BUTTON_FIRE, Button.class).show();
                }
                String strength = WindowHireWorker.createAttributeText(WindowHireWorker.createColor(primary, secondary, AbstractBuildingWorker.Skill.STRENGTH), LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.strength", citizen.getStrength()));
                String charisma = WindowHireWorker.createAttributeText(WindowHireWorker.createColor(primary, secondary, AbstractBuildingWorker.Skill.CHARISMA), LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.charisma", citizen.getCharisma()));
                String dexterity = WindowHireWorker.createAttributeText(WindowHireWorker.createColor(primary, secondary, AbstractBuildingWorker.Skill.DEXTERITY), LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.dexterity", citizen.getDexterity()));
                String endurance = WindowHireWorker.createAttributeText(WindowHireWorker.createColor(primary, secondary, AbstractBuildingWorker.Skill.ENDURANCE), LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.endurance", citizen.getEndurance()));
                String intelligence = WindowHireWorker.createAttributeText(WindowHireWorker.createColor(primary, secondary, AbstractBuildingWorker.Skill.INTELLIGENCE), LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.intelligence", citizen.getIntelligence()));
                String attributes = strength + charisma + dexterity + endurance + intelligence;
                rowPane.findPaneOfTypeByID(WindowHireWorker.CITIZEN_LABEL, Label.class).setLabelText(citizen.getName());
                rowPane.findPaneOfTypeByID(WindowHireWorker.ATTRIBUTES_LABEL, Label.class).setLabelText(attributes);
                rowPane.findPaneOfTypeByID(WindowHireWorker.ID_LABEL, Label.class).setLabelText(Integer.toString(citizen.getId()));
            }
        });
    }

    private static String createAttributeText(String color, String text) {
        return color + text + "\u00a7f";
    }

    private static String createColor(AbstractBuildingWorker.Skill primary, AbstractBuildingWorker.Skill secondary, AbstractBuildingWorker.Skill current) {
        if (primary == current) {
            return "\u00a72";
        }
        if (secondary == current) {
            return "\u00a7e";
        }
        return "";
    }

    @Override
    public void onUpdate() {
        this.updateCitizens();
        this.window.findPaneOfTypeByID(CITIZEN_LIST, ScrollingList.class).refreshElementPanes();
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        if (button.getID().equals(BUTTON_DONE)) {
            Label idLabel = (Label)button.getParent().getChildren().get(4);
            int id = Integer.parseInt(idLabel.getLabelText());
            this.building.addWorkerId(id);
            MineColonies.getNetwork().sendToServer((IMessage)new HireFireMessage(this.building, true, id));
        } else if (button.getID().equals(BUTTON_FIRE)) {
            Label idLabel = (Label)button.getParent().getChildren().get(4);
            int id = Integer.parseInt(idLabel.getLabelText());
            MineColonies.getNetwork().sendToServer((IMessage)new HireFireMessage(this.building, false, id));
            this.building.removeWorkerId(id);
        } else if (!button.getID().equals(BUTTON_CANCEL)) {
            return;
        }
        if (this.colony.getTownHall() != null) {
            this.building.openGui(false);
        }
    }
}

