/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.blockout.Color;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.DropDownList;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowMoveBuilding;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.StructureName;
import com.minecolonies.coremod.colony.Structures;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructure;
import com.minecolonies.coremod.network.messages.BuildRequestMessage;
import com.minecolonies.coremod.network.messages.BuildingSetStyleMessage;
import com.minecolonies.coremod.network.messages.SchematicRequestMessage;
import com.minecolonies.coremod.util.StructureWrapper;
import com.minecolonies.structures.helpers.Settings;
import com.minecolonies.structures.helpers.Structure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowBuildBuilding
extends AbstractWindowSkeleton {
    private static final String BUILDING_NAME_RESOURCE_SUFFIX = ":gui/windowbuildbuilding.xml";
    private final AbstractBuildingView building;
    private final Map<String, ItemStorage> resources = new HashMap<String, ItemStorage>();
    private DropDownList stylesDropDownList;
    private static final int WHITE = Color.getByName("white", 0);
    @NotNull
    private List<String> styles = new ArrayList<String>();

    public WindowBuildBuilding(ColonyView c, BlockPos buildingId) {
        super("minecolonies:gui/windowbuildbuilding.xml");
        this.building = c.getBuilding(buildingId);
        this.initStyleNavigation();
        this.registerButton("build", this::confirmClicked);
        this.registerButton("cancel", this::cancelClicked);
        this.registerButton("reposition", this::moveBuildingClicked);
        Button buttonBuild = this.findPaneOfTypeByID("build", Button.class);
        if (this.building.getBuildingLevel() == 0) {
            buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.build", new Object[0]));
            this.findPaneOfTypeByID("reposition", Button.class).disable();
        } else if (this.building.getBuildingLevel() == this.building.getBuildingMaxLevel()) {
            buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.switchStyle", new Object[0]));
        } else {
            buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.upgrade", new Object[0]));
        }
    }

    private void moveBuildingClicked() {
        WindowMoveBuilding window = new WindowMoveBuilding(this.building.getLocation(), this.building, this.styles.get(this.stylesDropDownList.getSelectedIndex()));
        window.open();
    }

    private void cancelClicked() {
        this.building.openGui(false);
    }

    private void confirmClicked() {
        MineColonies.getNetwork().sendToServer((IMessage)new BuildingSetStyleMessage(this.building, this.styles.get(this.stylesDropDownList.getSelectedIndex())));
        if (this.building.getBuildingLevel() == this.building.getBuildingMaxLevel()) {
            MineColonies.getNetwork().sendToServer((IMessage)new BuildRequestMessage(this.building, 1));
        } else {
            MineColonies.getNetwork().sendToServer((IMessage)new BuildRequestMessage(this.building, 0));
        }
        this.cancelClicked();
    }

    private void updateStyles() {
        this.styles = Structures.getStylesFor(this.building.getSchematicName());
        int newIndex = this.styles.indexOf(this.building.getStyle());
        if (newIndex == -1) {
            newIndex = 0;
        }
        boolean enabled = Settings.instance.isStaticSchematicMode() ? false : this.styles.size() > 1;
        this.findPaneOfTypeByID("previousStyle", Button.class).setEnabled(enabled);
        this.findPaneOfTypeByID("style", DropDownList.class).setEnabled(enabled);
        this.findPaneOfTypeByID("nextStyle", Button.class).setEnabled(enabled);
        this.stylesDropDownList.setSelectedIndex(newIndex);
    }

    private void updateResources() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        this.resources.clear();
        int nextLevel = this.building.getBuildingLevel() == this.building.getBuildingMaxLevel() ? this.building.getBuildingMaxLevel() : this.building.getBuildingLevel() + 1;
        StructureName sn = new StructureName("schematics", this.styles.get(this.stylesDropDownList.getSelectedIndex()), this.building.getSchematicName() + nextLevel);
        StructureWrapper wrapper = new StructureWrapper((World)world, sn.toString());
        Structure structure = wrapper.getStructure().getStructure();
        String md5 = Structures.getMD5(sn.toString());
        if (structure.isTemplateMissing() || !structure.isCorrectMD5(md5)) {
            if (structure.isTemplateMissing()) {
                Log.getLogger().info("Template structure " + sn + " missing");
            } else {
                Log.getLogger().info("structure " + sn + " md5 error");
            }
            Log.getLogger().info("Request To Server for structure " + sn);
            if (FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
                MineColonies.getNetwork().sendToServer((IMessage)new SchematicRequestMessage(sn.toString()));
                return;
            }
            Log.getLogger().error("WindowBuildTool: Need to download schematic on a standalone client/server. This should never happen");
        }
        wrapper.setPosition(this.building.getLocation());
        wrapper.rotate(this.building.getRotation(), (World)world, this.building.getLocation(), this.building.isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE);
        while (wrapper.findNextBlock()) {
            Template.BlockInfo blockInfo = wrapper.getBlockInfo();
            Template.EntityInfo entityInfo = wrapper.getEntityinfo();
            if (entityInfo != null) {
                for (ItemStack stack : ItemStackUtils.getListOfStackForEntityInfo(entityInfo, (World)world, (Entity)Minecraft.func_71410_x().field_71439_g)) {
                    if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
                    this.addNeededResource(stack, 1);
                }
            }
            if (blockInfo == null) continue;
            IBlockState blockState = blockInfo.field_186243_b;
            Block block = blockState.func_177230_c();
            if (wrapper.isStructureBlockEqualWorldBlock() || blockState.func_177230_c() instanceof BlockBed && ((BlockBed.EnumPartType)blockState.func_177229_b((IProperty)BlockBed.field_176472_a)).equals((Object)BlockBed.EnumPartType.FOOT) || blockState.func_177230_c() instanceof BlockDoor && ((BlockDoor.EnumDoorHalf)blockState.func_177229_b((IProperty)BlockDoor.field_176523_O)).equals((Object)BlockDoor.EnumDoorHalf.UPPER) || block == null || block == Blocks.field_150350_a || AbstractEntityAIStructure.isBlockFree(block, 0) || block == ModBlocks.blockSolidSubstitution || block == ModBlocks.blockSubstitution) continue;
            if (wrapper.getBlockInfo().field_186244_c != null) {
                ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
                if (wrapper.getBlockInfo() != null && wrapper.getBlockInfo().field_186244_c != null) {
                    itemList.addAll(ItemStackUtils.getItemStacksOfTileEntity(wrapper.getBlockInfo().field_186244_c, (World)world));
                }
                for (ItemStack stack : itemList) {
                    this.addNeededResource(stack, 1);
                }
            }
            this.addNeededResource(BlockUtils.getItemStackFromBlockState(blockState), 1);
        }
        this.window.findPaneOfTypeByID("resources", ScrollingList.class).refreshElementPanes();
        this.updateResourceList();
    }

    public void addNeededResource(@Nullable ItemStack res, int amount) {
        if (ItemStackUtils.isEmpty(res).booleanValue() || amount == 0) {
            return;
        }
        ItemStorage resource = this.resources.get(res.func_77977_a());
        if (resource == null) {
            resource = new ItemStorage(res);
            resource.setAmount(amount);
        } else {
            resource.setAmount(resource.getAmount() + amount);
        }
        this.resources.put(res.func_77977_a(), resource);
    }

    private void initStyleNavigation() {
        this.registerButton("previousStyle", this::previousStyle);
        this.registerButton("nextStyle", this::nextStyle);
        this.stylesDropDownList = this.findPaneOfTypeByID("style", DropDownList.class);
        this.stylesDropDownList.setHandler(this::onDropDownListChanged);
        this.stylesDropDownList.setDataProvider(new DropDownList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowBuildBuilding.this.styles.size();
            }

            @Override
            public String getLabel(int index) {
                if (index >= 0 && index < WindowBuildBuilding.this.styles.size()) {
                    return (String)WindowBuildBuilding.this.styles.get(index);
                }
                return "";
            }
        });
    }

    private void onDropDownListChanged(DropDownList list) {
        this.updateResources();
    }

    private void nextStyle() {
        this.stylesDropDownList.selectNext();
    }

    private void previousStyle() {
        this.stylesDropDownList.selectPrevious();
    }

    @Override
    public void onOpened() {
        this.updateStyles();
        this.updateResources();
    }

    public void updateResourceList() {
        ScrollingList recourseList = this.findPaneOfTypeByID("resources", ScrollingList.class);
        recourseList.enable();
        recourseList.show();
        final ArrayList<ItemStorage> tempRes = new ArrayList<ItemStorage>(this.resources.values());
        recourseList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return tempRes.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStorage resource = (ItemStorage)tempRes.get(index);
                Label resourceLabel = rowPane.findPaneOfTypeByID("resourceName", Label.class);
                Label quantityLabel = rowPane.findPaneOfTypeByID("resourceQuantity", Label.class);
                resourceLabel.setLabelText(resource.getItemStack().func_82833_r());
                quantityLabel.setLabelText(Integer.toString(resource.getAmount()));
                resourceLabel.setColor(WHITE, WHITE);
                quantityLabel.setColor(WHITE, WHITE);
                rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class).setItem(new ItemStack(resource.getItem(), 1, resource.getDamageValue()));
            }
        });
    }
}

