/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonHandler;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHome;
import com.minecolonies.coremod.network.messages.AssignUnassignMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowAssignCitizen
extends Window
implements ButtonHandler {
    private static final String BUTTON_DONE = "done";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String CITIZEN_LABEL = "citizen";
    private static final String CITIZEN_LIST = "unassigned";
    private static final String CITIZEN_DONE = "done";
    private static final String BUILDING_NAME_RESOURCE_SUFFIX = ":gui/windowAssignCitizen.xml";
    private static final String CITIZEN_JOB = "job";
    private final AbstractBuildingView building;
    private final ScrollingList citizenList;
    private final ColonyView colony;
    private List<CitizenDataView> citizens = new ArrayList<CitizenDataView>();

    public WindowAssignCitizen(ColonyView c, BlockPos buildingId) {
        super("minecolonies:gui/windowAssignCitizen.xml");
        this.colony = c;
        this.building = this.colony.getBuilding(buildingId);
        this.citizenList = this.findPaneOfTypeByID(CITIZEN_LIST, ScrollingList.class);
        this.updateCitizens();
    }

    private void updateCitizens() {
        this.citizens.clear();
        this.citizens.addAll(this.colony.getCitizens().values());
        this.citizens = this.colony.getCitizens().values().stream().filter(citizen -> citizen.getHomeBuilding() == null).sorted(Comparator.comparing(CitizenDataView::getName)).collect(Collectors.toList());
    }

    @Override
    public void onOpened() {
        this.updateCitizens();
        this.citizenList.enable();
        this.citizenList.show();
        this.citizenList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowAssignCitizen.this.citizens.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                CitizenDataView citizen = (CitizenDataView)WindowAssignCitizen.this.citizens.get(index);
                if (WindowAssignCitizen.this.building instanceof BuildingHome.View) {
                    rowPane.findPaneOfTypeByID(WindowAssignCitizen.CITIZEN_LABEL, Label.class).setLabelText(citizen.getName());
                    rowPane.findPaneOfTypeByID(WindowAssignCitizen.CITIZEN_JOB, Label.class).setLabelText(LanguageHandler.format(citizen.getJob(), new Object[0]));
                    Button done = rowPane.findPaneOfTypeByID("done", Button.class);
                    if (WindowAssignCitizen.this.colony.isManualHousing()) {
                        done.enable();
                    } else {
                        done.disable();
                    }
                }
            }
        });
    }

    @Override
    public void onUpdate() {
        this.updateCitizens();
        this.window.findPaneOfTypeByID(CITIZEN_LIST, ScrollingList.class).refreshElementPanes();
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        if (button.getID().equals("done")) {
            int row = this.citizenList.getListElementIndexByPane(button);
            CitizenDataView data = this.citizens.get(row);
            if (this.building instanceof BuildingHome.View) {
                ((BuildingHome.View)this.building).addResident(data.getId());
            }
            MineColonies.getNetwork().sendToServer((IMessage)new AssignUnassignMessage(this.building, true, data.getId()));
        } else if (!button.getID().equals(BUTTON_CANCEL)) {
            return;
        }
        if (this.colony.getTownHall() != null) {
            this.building.openGui(false);
        }
    }
}

