/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowBuilding;
import com.minecolonies.coremod.client.gui.WindowHireWorker;
import com.minecolonies.coremod.client.gui.WindowListRecipes;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.network.messages.OpenCraftingGUIMessage;
import com.minecolonies.coremod.network.messages.RecallCitizenMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWindowWorkerBuilding<B extends AbstractBuildingWorker.View>
extends AbstractWindowBuilding<B> {
    private static final String BUTTON_HIRE = "hire";
    private static final String BUTTON_RECALL = "recall";
    private static final String LABEL_BUILDINGTYPE = "type";
    private static final String LABEL_WORKERNAME = "workerName";
    private static final String LABEL_WORKERLEVEL = "workerLevel";
    private static final String BUILDER_HUT_NAME = "com.minecolonies.coremod.gui.workerHuts.buildersHut";
    private static final String BUTTON_CRAFTING = "crafting";
    private static final String BUTTON_RECIPES_LIST = "recipelist";

    AbstractWindowWorkerBuilding(B building, String resource) {
        super(building, resource);
        super.registerButton(BUTTON_HIRE, this::hireClicked);
        super.registerButton(BUTTON_RECALL, this::recallClicked);
        super.registerButton(BUTTON_CRAFTING, this::craftingClicked);
        super.registerButton(BUTTON_RECIPES_LIST, this::recipeListClicked);
    }

    private void recipeListClicked() {
        WindowListRecipes window = new WindowListRecipes(((AbstractBuildingWorker.View)this.building).getColony(), ((AbstractBuildingWorker.View)this.building).getLocation());
        window.open();
    }

    private void craftingClicked() {
        BlockPos pos = ((AbstractBuildingWorker.View)this.building).getLocation();
        Minecraft.func_71410_x().field_71439_g.openGui((Object)MineColonies.instance, 0, (World)Minecraft.func_71410_x().field_71441_e, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        MineColonies.getNetwork().sendToServer((IMessage)new OpenCraftingGUIMessage(this.building, 2));
    }

    private void hireClicked(@NotNull Button button) {
        if (((AbstractBuildingWorker.View)this.building).getColony().isManualHiring()) {
            if (((AbstractBuildingWorker.View)this.building).getBuildingLevel() == 0 && !BUILDER_HUT_NAME.equals(this.getBuildingName())) {
                LanguageHandler.sendPlayerMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, "com.minecolonies.coremod.gui.workerHuts.level0", new Object[0]);
                return;
            }
            WindowHireWorker window = new WindowHireWorker(((AbstractBuildingWorker.View)this.building).getColony(), ((AbstractBuildingWorker.View)this.building).getLocation());
            window.open();
        }
    }

    private void recallClicked() {
        MineColonies.getNetwork().sendToServer((IMessage)new RecallCitizenMessage((AbstractBuildingWorker.View)this.building));
    }

    @Override
    public void onOpened() {
        CitizenDataView worker;
        super.onOpened();
        String workerName = "";
        String workerLevel = "";
        if (!((AbstractBuildingWorker.View)this.building).getWorkerId().isEmpty() && (worker = ((AbstractBuildingWorker.View)this.building).getColony().getCitizen(((AbstractBuildingWorker.View)this.building).getWorkerId().get(0))) != null) {
            workerName = worker.getName();
            workerLevel = String.format("%d", worker.getLevel());
        }
        this.findPaneOfTypeByID(BUTTON_HIRE, Button.class).setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.hire", new Object[0]));
        this.findPaneOfTypeByID(LABEL_WORKERNAME, Label.class).setLabelText(workerName);
        this.findPaneOfTypeByID(LABEL_WORKERLEVEL, Label.class).setLabelText(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.workerLevel", workerLevel));
        this.findPaneOfTypeByID(LABEL_BUILDINGTYPE, Label.class).setLabelText(((AbstractBuildingWorker.View)this.building).getBuildingDmPrio() + "/10");
    }
}

