/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.SwitchView;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowBuildBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.BuildRequestMessage;
import com.minecolonies.coremod.network.messages.OpenInventoryMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWindowBuilding<B extends AbstractBuildingView>
extends AbstractWindowSkeleton {
    protected final B building;
    private final SwitchView switchView;
    private final Label title;
    private final Button buttonPrevPage;
    private final Button buttonNextPage;
    private final Button buttonBuild;
    private final Button buttonRepair;

    public AbstractWindowBuilding(B building, String resource) {
        super(resource);
        this.building = building;
        this.registerButton("build", this::buildClicked);
        this.registerButton("repair", this::repairClicked);
        this.registerButton("inventory", this::inventoryClicked);
        this.switchView = this.findPaneOfTypeByID("pages", SwitchView.class);
        this.title = this.findPaneOfTypeByID("name", Label.class);
        this.buttonNextPage = this.findPaneOfTypeByID("nextPage", Button.class);
        this.buttonPrevPage = this.findPaneOfTypeByID("prevPage", Button.class);
        this.buttonBuild = this.findPaneOfTypeByID("build", Button.class);
        this.buttonRepair = this.findPaneOfTypeByID("repair", Button.class);
    }

    private void buildClicked() {
        if (this.buttonBuild.getLabel().equalsIgnoreCase(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelBuild", new Object[0])) || this.buttonBuild.getLabel().equalsIgnoreCase(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelUpgrade", new Object[0]))) {
            MineColonies.getNetwork().sendToServer((IMessage)new BuildRequestMessage((AbstractBuildingView)this.building, 0));
        } else {
            WindowBuildBuilding window = new WindowBuildBuilding(((AbstractBuildingView)this.building).getColony(), ((AbstractBuildingView)this.building).getLocation());
            window.open();
        }
    }

    private void repairClicked() {
        MineColonies.getNetwork().sendToServer((IMessage)new BuildRequestMessage((AbstractBuildingView)this.building, 1));
    }

    private void inventoryClicked() {
        MineColonies.getNetwork().sendToServer((IMessage)new OpenInventoryMessage(((AbstractBuildingView)this.building).getID()));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.switchView == null || this.switchView.getCurrentView().getID().equals("pageActions")) {
            AbstractBuildingView buildingView = ((AbstractBuildingView)this.building).getColony().getBuilding(((AbstractBuildingView)this.building).getID());
            if (this.buttonPrevPage != null) {
                this.buttonPrevPage.disable();
                this.buttonPrevPage.hide();
            }
            if (this.title != null) {
                this.title.setLabelText(LanguageHandler.format(this.getBuildingName(), new Object[0]) + " " + buildingView.getBuildingLevel());
            }
            this.updateButtonBuild(buildingView);
            this.updateButtonRepair(buildingView);
        }
    }

    public abstract String getBuildingName();

    private void updateButtonBuild(AbstractBuildingView buildingView) {
        if (this.buttonBuild == null) {
            return;
        }
        if (buildingView.isBuildingMaxLevel()) {
            this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.switchStyle", new Object[0]));
        } else if (buildingView.isBuilding()) {
            if (buildingView.getBuildingLevel() == 0) {
                this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelBuild", new Object[0]));
            } else {
                this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelUpgrade", new Object[0]));
            }
        } else if (buildingView.getBuildingLevel() == 0) {
            this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.build", new Object[0]));
        } else {
            this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.upgrade", new Object[0]));
        }
    }

    private void updateButtonRepair(AbstractBuildingView buildingView) {
        if (this.buttonRepair == null) {
            return;
        }
        this.buttonRepair.setEnabled(buildingView.getBuildingLevel() != 0 && !buildingView.isBuilding());
        if (buildingView.isRepairing()) {
            this.buttonRepair.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelRepair", new Object[0]));
        } else {
            this.buttonRepair.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.repair", new Object[0]));
        }
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        switch (button.getID()) {
            case "prevPage": {
                this.findPaneOfTypeByID("pages", SwitchView.class).previousView();
                this.buttonPrevPage.setEnabled(false);
                this.buttonNextPage.setEnabled(true);
                this.buttonPrevPage.hide();
                this.buttonNextPage.show();
                break;
            }
            case "nextPage": {
                this.findPaneOfTypeByID("pages", SwitchView.class).nextView();
                this.buttonPrevPage.setEnabled(true);
                this.buttonNextPage.setEnabled(false);
                this.buttonPrevPage.show();
                this.buttonNextPage.hide();
                break;
            }
            default: {
                super.onButtonClicked(button);
            }
        }
    }
}

