/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.blocks.types;

import net.minecraft.block.material.MapColor;
import net.minecraft.util.IStringSerializable;
import org.jetbrains.annotations.NotNull;

public enum TimberFrameType implements IStringSerializable
{
    PLAIN(0, "plain", MapColor.field_151663_o),
    DOUBLECROSSED(1, "doublecrossed", MapColor.field_151676_q),
    FRAMED(2, "framed", MapColor.field_151660_b),
    SIDEFRAMED(3, "sideframed", MapColor.field_151646_E),
    GATEFRAMED(4, "gateframed", MapColor.field_151649_A),
    ONECROSSEDLR(5, "onecrossedlr", MapColor.field_151666_j),
    ONECROSSEDRL(6, "onecrossedrl", MapColor.field_151650_B),
    DOWNGATED(7, "downgated", MapColor.field_151667_k),
    HORIZONTALPLAIN(8, "horizontalplain", MapColor.field_151659_e),
    HORIZONTALNOCAP(9, "horizontalnocap", MapColor.field_151679_y);

    private static final TimberFrameType[] META_LOOKUP;
    private final int meta;
    private final String name;
    private final String unlocalizedName;
    private final MapColor mapColor;

    private TimberFrameType(int metaIn, String nameIn, MapColor mapColorIn) {
        this(metaIn, nameIn, nameIn, mapColorIn);
    }

    private TimberFrameType(int metaIn, String nameIn, String unlocalizedNameIn, MapColor mapColorIn) {
        this.meta = metaIn;
        this.name = nameIn;
        this.unlocalizedName = unlocalizedNameIn;
        this.mapColor = mapColorIn;
    }

    public static TimberFrameType byMetadata(int meta) {
        int tempMeta = meta;
        if (tempMeta < 0 || tempMeta >= META_LOOKUP.length) {
            tempMeta = 0;
        }
        return META_LOOKUP[tempMeta];
    }

    public int getMetadata() {
        return this.meta;
    }

    public MapColor getMapColor() {
        return this.mapColor;
    }

    public String toString() {
        return this.name;
    }

    @NotNull
    public String func_176610_l() {
        return this.name;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    static {
        META_LOOKUP = new TimberFrameType[TimberFrameType.values().length];
        TimberFrameType[] timberFrameTypeArray = TimberFrameType.values();
        int n = timberFrameTypeArray.length;
        for (int i = 0; i < n; ++i) {
            TimberFrameType enumtype;
            TimberFrameType.META_LOOKUP[enumtype.getMetadata()] = enumtype = timberFrameTypeArray[i];
        }
    }
}

