/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.blockout.views;

import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.PaneParams;
import com.minecolonies.blockout.controls.Scrollbar;
import com.minecolonies.blockout.views.ScrollingContainer;
import com.minecolonies.blockout.views.View;
import org.jetbrains.annotations.NotNull;

public class ScrollingView
extends View {
    private static final int DEFAULT_SCROLLBAR_WIDTH = 8;
    protected ScrollingContainer container;
    protected Scrollbar scrollbar;
    private final int scrollbarWidth = 8;

    public ScrollingView() {
        this.setup(null);
    }

    public ScrollingView(PaneParams params) {
        super(params);
        this.setup(params);
    }

    private void setup(PaneParams params) {
        this.container = this.createScrollingContainer();
        this.container.setPosition(0, 0);
        this.container.setSize(this.getInteriorWidth() - 8, this.getInteriorHeight());
        this.container.putInside(this);
        this.scrollbar = params != null ? new Scrollbar(this.container, params) : new Scrollbar(this.container);
        this.scrollbar.setPosition(this.getInteriorWidth() - 8, 0);
        this.scrollbar.setSize(8, this.getInteriorHeight());
        this.scrollbar.putInside(this);
    }

    @NotNull
    protected ScrollingContainer createScrollingContainer() {
        return new ScrollingContainer(this);
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.container.setSize(this.getInteriorWidth() - 8, this.getInteriorHeight());
        this.scrollbar.setPosition(this.getInteriorWidth() - 8, 0);
        this.scrollbar.setSize(8, this.getInteriorHeight());
    }

    @Override
    public void scrollInput(int wheel) {
        this.setScrollY(this.getScrollY() + -wheel);
    }

    public ScrollingContainer getContainer() {
        return this.container;
    }

    @Override
    public void parseChildren(PaneParams params) {
        this.container.parseChildren(params);
    }

    @Override
    protected boolean childIsVisible(Pane child) {
        return true;
    }

    public int getScrollY() {
        return this.container.getScrollY();
    }

    public void setScrollY(int offset) {
        this.container.setScrollY(offset);
    }

    public int getContentHeight() {
        return this.container.getContentHeight();
    }
}

