/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.blockout.controls;

import com.minecolonies.blockout.PaneParams;
import com.minecolonies.blockout.controls.TextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ChatAllowedCharacters;

public class TextFieldVanilla
extends TextField {
    private static final int BACKGROUND_WIDTH_OFFSET = 8;
    private static final float BACKGROUND_X_TRANSLATE = 4.0f;
    private static final int BACKGROUND_Y_TRANSLATE_OFFSET = 8;
    private static final int BACKGROUND_MOUSE_OFFSET_X = 4;
    private boolean backgroundEnabled = true;
    private int backgroundOuterColor = -6250336;
    private int backgroundInnerColor = -16777216;

    public TextFieldVanilla() {
        this.filter = new FilterVanilla();
    }

    public TextFieldVanilla(PaneParams params) {
        super(params);
        this.backgroundEnabled = params.getBooleanAttribute("background", this.backgroundEnabled);
        this.backgroundOuterColor = params.getColorAttribute("backgroundOuter", this.backgroundOuterColor);
        this.backgroundInnerColor = params.getColorAttribute("backgroundInner", this.backgroundInnerColor);
        this.filter = new FilterVanilla();
    }

    public boolean isBackgroundEnabled() {
        return this.backgroundEnabled;
    }

    public void setBackgroundEnabled(boolean e) {
        this.backgroundEnabled = e;
    }

    public int getBackgroundOuterColor() {
        return this.backgroundOuterColor;
    }

    public void setBackgroundOuterColor(int c) {
        this.backgroundOuterColor = c;
    }

    public int getBackgroundInnerColor() {
        return this.backgroundInnerColor;
    }

    public void setBackgroundInnerColor(int c) {
        this.backgroundInnerColor = c;
    }

    @Override
    public int getInternalWidth() {
        return this.backgroundEnabled ? this.getWidth() - 8 : this.getWidth();
    }

    @Override
    public void drawSelf(int mx, int my) {
        if (this.backgroundEnabled) {
            TextFieldVanilla.func_73734_a((int)(this.x - 1), (int)(this.y - 1), (int)(this.x + this.width + 1), (int)(this.y + this.height + 1), (int)this.backgroundOuterColor);
            TextFieldVanilla.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)this.backgroundInnerColor);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)4.0f, (float)((float)((double)(this.height - 8) / 2.0)), (float)0.0f);
        }
        super.drawSelf(mx, my);
        if (this.backgroundEnabled) {
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void handleClick(int mx, int my) {
        int mouseX = mx;
        if (this.backgroundEnabled) {
            mouseX -= 4;
        }
        super.handleClick(mouseX, my);
    }

    private static class FilterVanilla
    implements TextField.Filter {
        private FilterVanilla() {
        }

        @Override
        public String filter(String s) {
            return ChatAllowedCharacters.func_71565_a((String)s);
        }

        @Override
        public boolean isAllowedCharacter(char c) {
            return ChatAllowedCharacters.func_71566_a((char)c);
        }
    }

    private static class FilterNumeric
    implements TextField.Filter {
        private FilterNumeric() {
        }

        @Override
        public String filter(String s) {
            StringBuilder sb = new StringBuilder();
            for (char c : s.toCharArray()) {
                if (!this.isAllowedCharacter(c)) continue;
                sb.append(c);
            }
            return sb.toString();
        }

        @Override
        public boolean isAllowedCharacter(char c) {
            return Character.isDigit(c);
        }
    }
}

