/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.blockout.controls;

import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.PaneParams;
import com.minecolonies.blockout.views.ScrollingContainer;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public class Scrollbar
extends Pane {
    private static final int MAXIMUM_HEIGHT = 20;
    protected int scrollbarBackground = -16777216;
    protected int scrollbarColor = -4144960;
    protected int scrollbarColorHighlight = -8355712;
    protected ScrollingContainer container;
    protected int barClickY = 0;
    protected boolean barClicked = false;
    protected int offsetX = 0;
    protected int offsetY = 0;

    public Scrollbar(ScrollingContainer container, PaneParams params) {
        this(container);
        PaneParams.SizePair size = params.getSizePairAttribute("scrollbarOffset", null, null);
        if (size != null) {
            this.offsetX = size.getX();
            this.offsetY = size.getY();
        }
    }

    public Scrollbar(ScrollingContainer container) {
        this.container = container;
    }

    public void dragScroll(int my) {
        if (this.container.getContentHeight() == 0) {
            return;
        }
        int barClickYNow = this.getScrollBarYPos() + this.barClickY;
        int deltaFromClickPos = my - barClickYNow;
        if (deltaFromClickPos == 0) {
            return;
        }
        int scaledY = deltaFromClickPos * this.container.getMaxScrollY() / this.getHeight();
        this.container.scrollBy(scaledY);
        if (this.container.getScrollY() == 0 || this.container.getScrollY() == this.container.getMaxScrollY()) {
            this.barClickY = MathHelper.func_76125_a((int)(my - this.getScrollBarYPos()), (int)0, (int)(this.getBarHeight() - 1));
        }
    }

    @Override
    public void drawSelf(int mx, int my) {
        boolean bl = this.barClicked = this.barClicked && Mouse.isButtonDown((int)0);
        if (this.barClicked) {
            this.dragScroll(my - this.y);
        }
        if (this.getContentHeightDiff() <= 0) {
            return;
        }
        int scrollBarBackX1 = this.x + this.offsetX;
        int scrollBarBackX2 = scrollBarBackX1 + (this.getWidth() - 2);
        this.func_73733_a(scrollBarBackX2, this.y + this.getHeight() + this.offsetY, scrollBarBackX1, this.y + this.offsetY, this.scrollbarBackground, this.scrollbarBackground);
        int scrollBarStartY = this.y + this.getScrollBarYPos();
        int scrollBarEndY = scrollBarStartY + this.getBarHeight();
        this.func_73733_a(scrollBarBackX2, scrollBarEndY, scrollBarBackX1, scrollBarStartY, this.scrollbarColorHighlight, this.scrollbarColorHighlight);
        this.func_73733_a(scrollBarBackX2 - 1, scrollBarEndY - 1, scrollBarBackX1, scrollBarStartY, this.scrollbarColor, this.scrollbarColor);
    }

    @Override
    public void handleClick(int mx, int my) {
        if (this.getContentHeightDiff() <= 0) {
            return;
        }
        int barHeight = this.getBarHeight();
        int scrollBarStartY = this.getScrollBarYPos();
        int scrollBarEndY = scrollBarStartY + barHeight;
        if (my < scrollBarStartY) {
            this.container.scrollBy(-this.container.getScrollPageSize());
        } else if (my > scrollBarEndY) {
            this.container.scrollBy(this.container.getScrollPageSize());
        } else {
            this.barClickY = my - scrollBarStartY;
            this.barClicked = true;
        }
    }

    private int getContentHeightDiff() {
        return this.container.getContentHeight() - this.getHeight();
    }

    private int getBarHeight() {
        return Math.max(Math.min(20, this.getHeight() / 2), this.getHeight() * this.getHeight() / this.container.getContentHeight());
    }

    private int getScrollBarYPos() {
        return this.container.getScrollY() * (this.getHeight() - this.getBarHeight()) / this.getContentHeightDiff();
    }
}

