/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntityUtils {
    private static final int AIR_SPACE_ABOVE_TO_CHECK = 2;
    private static final int DEFAULT_MOVE_RANGE = 3;
    private static final int TELEPORT_RANGE = 512;
    private static final double MIDDLE_BLOCK_OFFSET = 0.5;
    private static final int SCAN_RADIUS = 5;

    private EntityUtils() {
    }

    @NotNull
    public static EntityPlayer getPlayerOfFakePlayer(@NotNull EntityPlayer player, @NotNull World world) {
        EntityPlayer tempPlayer;
        if (player instanceof FakePlayer && (tempPlayer = world.func_152378_a(player.func_110124_au())) != null) {
            return tempPlayer;
        }
        return player;
    }

    public static Entity getEntityFromUUID(@NotNull World world, @NotNull UUID id) {
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            if (!id.equals(((Entity)world.field_72996_f.get(i)).func_110124_au())) continue;
            return (Entity)world.field_72996_f.get(i);
        }
        return null;
    }

    @NotNull
    public static List<Entity> getEntitiesFromUUID(@NotNull World world, @NotNull Collection<UUID> ids) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Object o : world.field_72996_f) {
            Entity entity;
            if (!(o instanceof Entity) || !ids.contains((entity = (Entity)o).func_110124_au())) continue;
            entities.add(entity);
            if (entities.size() != ids.size()) continue;
            return entities;
        }
        return entities;
    }

    public static List<Entity> getEntitiesFromID(@NotNull World world, @NotNull List<Integer> ids) {
        return ids.stream().map(arg_0 -> ((World)world).func_73045_a(arg_0)).collect(Collectors.toList());
    }

    public static double updateRotation(double currentRotation, double intendedRotation, double maxIncrement) {
        double wrappedAngle = MathHelper.func_76138_g((double)(intendedRotation - currentRotation));
        if (wrappedAngle > maxIncrement) {
            wrappedAngle = maxIncrement;
        }
        if (wrappedAngle < -maxIncrement) {
            wrappedAngle = -maxIncrement;
        }
        return currentRotation + wrappedAngle;
    }

    public static boolean checkForFreeSpace(@NotNull World world, @NotNull BlockPos groundPosition) {
        for (int i = 1; i < 2; ++i) {
            if (!EntityUtils.solidOrLiquid(world, groundPosition.func_177981_b(i)) && !(world.func_180495_p(groundPosition.func_177981_b(i)).func_177230_c() instanceof BlockLeaves)) continue;
            return false;
        }
        return world.func_180495_p(groundPosition).func_185904_a().func_76220_a();
    }

    public static boolean solidOrLiquid(@NotNull World world, @NotNull BlockPos blockPos) {
        Material material = world.func_180495_p(blockPos).func_185904_a();
        return material.func_76220_a() || material.func_76224_d();
    }

    @Nullable
    public static BlockPos getSpawnPoint(World world, BlockPos nearPoint) {
        return Utils.scanForBlockNearPoint(world, nearPoint.func_177977_b(), 1, 1, 1, 2, new Block[]{Blocks.field_150350_a, Blocks.field_150431_aC, Blocks.field_150329_H, Blocks.field_150328_O, Blocks.field_150327_N, Blocks.field_150404_cg});
    }

    public static boolean tryMoveLivingToXYZ(@NotNull EntityLiving living, int x, int y, int z) {
        return EntityUtils.tryMoveLivingToXYZ(living, x, y, z, 1.0);
    }

    public static boolean tryMoveLivingToXYZ(@NotNull EntityLiving living, int x, int y, int z, double speed) {
        return living.func_70661_as().func_75492_a((double)x, (double)y, (double)z, speed);
    }

    public static boolean isLivingAtSiteWithMove(@NotNull EntityLiving entity, int x, int y, int z) {
        return EntityUtils.isLivingAtSiteWithMove(entity, x, y, z, 3);
    }

    public static boolean isLivingAtSiteWithMove(@NotNull EntityLiving entity, int x, int y, int z, int range) {
        if (!EntityUtils.isLivingAtSite(entity, x, y, z, 512)) {
            BlockPos spawnPoint = Utils.scanForBlockNearPoint(entity.func_130014_f_(), new BlockPos(x, y, z), 5, 5, 5, 2, new Block[]{Blocks.field_150350_a, Blocks.field_150431_aC, Blocks.field_150329_H, Blocks.field_150328_O, Blocks.field_150327_N, Blocks.field_150404_cg});
            entity.func_70012_b((double)spawnPoint.func_177958_n() + 0.5, (double)spawnPoint.func_177956_o(), (double)spawnPoint.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
            return true;
        }
        return EntityUtils.isLivingAtSite(entity, x, y, z, range);
    }

    public static boolean isLivingAtSite(@NotNull EntityLiving entityLiving, int x, int y, int z, int range) {
        return entityLiving.func_180425_c().func_177951_i(new Vec3i(x, y, z)) < MathUtils.square(range);
    }
}

