/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.configuration;

import net.minecraftforge.common.config.Config;

@Config(modid="minecolonies")
public class Configurations {
    @Config.Comment(value={"All configuration related to gameplay"})
    public static Gameplay gameplay = new Gameplay();
    @Config.Comment(value={"All configurations related to pathfinding"})
    public static Pathfinding pathfinding = new Pathfinding();
    @Config.Comment(value={"All configurations related to citizen names"})
    public static Names names = new Names();
    @Config.Comment(value={"All configurations related to the request system"})
    public static RequestSystem requestSystem = new RequestSystem();

    public static class RequestSystem {
        @Config.Comment(value={"Should the request system print out debug information? Useful in case of malfunctioning of set system."})
        public boolean enableDebugLogging = false;
        @Config.Comment(value={"The maximal amount of tries that the request system will perform for retryable requests. Higher increases server load."})
        public int maximalRetries = 3;
        @Config.Comment(value={"The amount of ticks between retries of the request system for retryable requests. Lower increases server load."})
        public int delayBetweenRetries = 1200;
        @Config.Comment(value={"The maximal amount of buildings the Delivery Man should try to gather before attempting a drop off at the warehouse."})
        public int maximalBuildingsToGather = 6;
        @Config.Comment(value={"The minimal amount of buildings the Delivery Man should try to gather before attempting a drop off at the warehouse."})
        public int minimalBuildingsToGather = 3;
        @Config.Comment(value={"Should the request system creatively resolve (if possible) when the player is required to resolve a request."})
        public boolean creativeResolve = false;
        @Config.Comment(value={"Should the player be allowed to use the '/mc colony rs reset' command?"})
        public boolean canPlayerUseResetCommand = false;
    }

    public static class Names {
        @Config.Comment(value={"Generate a middle initial when creating new colonist names"})
        public boolean useMiddleInitial = true;
        @Config.Comment(value={"Male first names to be used for colonists"})
        public String[] maleFirstNames = new String[]{"Aaron", "Adam", "Adrian", "Aidan", "Aiden", "Alain", "Alex", "Alexander", "Andrew", "Anthony", "Asher", "Austin", "Benjamin", "Brayden", "Bryson", "Caden", "Caleb", "Callum", "Camden", "Cameron", "Carson", "Carter", "Charles", "Charlie", "Chase", "Christian", "Christopher", "Cole", "Colton", "Connor", "Cooper", "Curtis", "Cyrille", "Damian", "Daniel", "David", "Declan", "Diego", "Diogo", "Dominic", "Duarte", "Dylan", "Easton", "Eli", "Elias", "Elijah", "Elliot", "Ethan", "Evan", "Ezra", "F\u00e9lix", "Gabriel", "Gavin", "George", "Grayson", "Guewen", "Harrison", "Henrik", "Henry", "Houston", "Hudson", "Hugo", "Hunter", "Ian", "Isaac", "Isaiah", "Jack", "Jackson", "Jacob", "James", "Jason", "Jayce", "Jayden", "Jeremiah", "Jim", "Joel", "John", "Jonathan", "Jordan", "Joseph", "Joshua", "Josiah", "Julian", "Kai", "Karsen", "Kevin", "Kian", "Landon", "Leo", "Levi", "Liam", "Lincoln", "Logan", "Lu\u00eds", "Lucas", "Luke", "Mark", "Mason", "Mateo", "Matthew", "Max", "Michael", "Miles", "Muhammad", "Nathan", "Nathanael", "Nicholas", "Noah", "Nolan", "Oliver", "Oscar", "Owen", "Parker", "Paul", "Peter", "Philibert", "R\u00e9nald", "Ray", "Richard", "Robert", "Rory", "Roxan", "Ryan", "Samuel", "Sebastian", "Steven", "Thaddee", "Thomas", "Tiago", "Tristan", "Tyler", "William", "Wyatt", "Xavier", "Zachary", "Zane", "Abraham", "Allen", "Ambrose", "Arthur", "Avery", "Barnaby", "Bartholomew", "Benedict", "Bernard", "Cuthbert", "Edmund", "Edward", "Francis", "Fulke", "Geoffrey", "Gerard", "Gilbert", "Giles", "Gregory", "Hugh", "Humphrey", "Jerome", "Lancelot", "Lawrence", "Leonard", "Martin", "Mathias", "Nathaniel", "Oswyn", "Philip", "Piers", "Ralph", "Reynold", "Roger", "Rowland", "Simon", "Solomon", "Stephen", "Tobias", "Walter", "William"};
        @Config.Comment(value={"Female first names to be used for colonists"})
        public String[] femaleFirstNames = new String[]{"Aaliyah", "Abigail", "Adalyn", "Addison", "Adeline", "Alaina", "Alexandra", "Alice", "Allison", "Alyssa", "Amelia", "Anastasia", "Anna", "Annabelle", "Aria", "Arianna", "Aubrey", "Audrey", "Aurora", "Ava", "Bailey", "Barbara", "Bella", "Betty", "Brooklyn", "Callie", "Camilla", "Caroline", "Charlotte", "Chloe", "Claire", "Cora", "Daniela", "Diana", "Dorothy", "Eleanor", "Elena", "Eliana", "Elizabeth", "Ella", "Ellie", "Emilia", "Emilienne", "Emily", "Emma", "Eva", "Evelyn", "Everly", "Filipa", "Fr\u00e9d\u00e9rique", "Gabriella", "Gianna", "Grace", "Hailey", "Hannah", "Harper", "Haylie", "Hazel", "Helen", "Isabella", "Isabelle", "Jade", "Jasmine", "Jennifer", "Jocelyn", "Jordyn", "Julia", "Juliana", "Julienne", "Karen", "Katia", "Kaylee", "Keira", "Kennedy", "Kinsley", "Kylie", "Layla", "Leah", "Lena", "Lila", "Liliana", "Lillian", "Lily", "Linda", "Lisa", "London", "Lorena", "Luana", "Lucy", "Luna", "M\u00e9lanie", "Mackenzie", "Madelyn", "Madison", "Maisy", "Makayla", "Margaret", "Maria", "Marine", "Mary", "Maya", "Melanie", "Mia", "Mila", "Nancy", "Natalie", "Natasha", "Niamh", "Nora", "Odile", "Olivia", "Paisley", "Paloma", "Paola", "Patricia", "Penelope", "Peyton", "Prudence", "Reagan", "Riley", "Sadie", "Samantha", "Sarah", "Savannah", "Scarlett", "Skyler", "Sophia", "Sophie", "Stella", "Susan", "V\u00e9rane", "Vera", "Victoria", "Violet", "Vivian", "Zoe", "Agnes", "Amy", "Anne", "Avis", "Beatrice", "Blanche", "Bridget", "Catherine", "Cecily", "Charity", "Christina", "Clemence", "Constance", "Denise", "Edith", "Elinor", "Ellen", "Florence", "Fortune", "Frances", "Frideswide", "Gillian", "Isabel", "Jane", "Janet", "Joan", "Josian", "Joyce", "Judith", "Katherine", "Lettice", "Mabel", "Margery", "Marion", "Martha", "Maud", "Mildred", "Millicent", "Parnell", "Philippa", "Rachel", "Rebecca", "Rose", "Ruth", "Susanna", "Sybil", "Thomasin", "Ursula", "Wilmot", "Winifred"};
        @Config.Comment(value={"Last names to be used for colonists"})
        public String[] lastNames = new String[]{"Brown", "Clark", "Fletcher", "Harris", "Johnson", "Jones", "Mardle", "Miller", "Robinson", "Smith", "Taylor", "Wallgreen", "White", "Williams", "Wilson", "Abell", "Ackworth", "Adams", "Addicock", "Alban", "Aldebourne", "Alfray", "Alicock", "Allard", "Allington", "Amberden", "Amcotts", "Amondsham", "Andrews", "Annesley", "Ansty", "Archer", "Ardall", "Ardern", "Argentein", "Arnold", "Asger", "Ashby", "Ashcombe", "Ashenhurst", "Ashton", "Askew", "Asplin", "Astley", "Atherton", "Atkinson", "Atlee", "Attilburgh", "Audeley", "Audlington", "Ayde", "Ayleward", "Aylmer", "Aynesworth", "Babham", "Babington", "Badby", "Baker", "Balam", "Baldwin", "Ballard", "Ballett", "Bammard", "Barber", "Bardolf", "Barefoot", "Barker", "Barnes", "Barre", "Barrentine", "Barrett", "Barstaple", "Bartelot", "Barton", "Basset", "Bathurst", "Battersby", "Battle", "Baynton", "Beauchamp", "Cheddar", "Chelsey", "Chernock", "Chester", "Chetwood", "Cheverell", "Cheyne", "Chichester", "Child", "Chilton", "Chowne", "Chudderley", "Church", "Churmond", "Clavell", "Claybrook", "Clement", "Clerk", "Clifford", "Clifton", "Clitherow", "Clopton", "Cobb", "Cobham", "Cobley", "Cockayne", "Cod", "Coddington", "Coffin", "Coggshall", "Colby", "Colkins", "Collard", "Colmer", "Colt", "Colthurst", "Complin", "Compton", "Conquest", "Cooke", "Coorthopp", "Coppinger", "Corbett", "Corby", "Cossington", "Cosworth", "Cotton", "Courtenay", "Covert", "Cowill", "Cox", "Crane", "Cranford", "Crawley", "Cressy", "Crickett", "Cripps", "Crisp", "Cristemas", "Crocker", "Crugg", "Cuddon", "Culpepper", "Cunningham", "Curzon", "Dagworth", "Gardiner", "Gare", "Garnis", "Garrard", "Garret", "Gascoigne", "Gasper", "Gavell", "Gedding", "Gerville", "Geste", "Gibbs", "Gifford", "Gill", "Ginter", "Gisborne", "Gittens", "Glennon", "Glover", "Gobberd", "Goddam", "Godfrey", "Gold", "Golding", "Goldwell", "Gomershall", "Gomfrey", "Gonson", "Good", "Goodenouth", "Gooder", "Goodluck", "Goodnestone", "Goodrick", "Goodrington", "Goodwin", "Goring", "Gorney", "Gorst", "Gosebourne", "Grafton", "Gray", "Greene", "Greenway", "Grenefeld", "Greville", "Grey", "Grimbald", "Grobbam", "Grofhurst", "Groston", "Grove", "Guildford", "Hackman", "Haddock", "Haddon", "Hadresham", "Hakebourne", "Hale", "Hall", "Halley", "Hambard", "Hammer", "Hammond", "Hampden"};
    }

    public static class Pathfinding {
        @Config.Comment(value={"Draw pathfinding paths (might be laggy)"})
        public boolean pathfindingDebugDraw = false;
        @Config.Comment(value={"Verbosity of pathfinding"})
        public int pathfindingDebugVerbosity = 0;
        @Config.Comment(value={"Amount of additional threads to be used for pathfinding"})
        public int pathfindingMaxThreadCount = 2;
    }

    public static class Gameplay {
        @Config.Comment(value={"Should builder place construction tape?"})
        public boolean builderPlaceConstructionTape = true;
        @Config.Comment(value={"Colony size (radius) - deprecated, don't use"})
        public int workingRangeTownHall = 200;
        @Config.Comment(value={"Colony size (radius in chunks around central colony chunk)"})
        public int workingRangeTownHallChunks = 8;
        @Config.Comment(value={"Padding between colonies  - deprecated, don't use"})
        public int townHallPadding = 20;
        @Config.Comment(value={"Padding between colonies in chunks"})
        public int townHallPaddingChunk = 1;
        @Config.Comment(value={"Should player get one guidebook on first join to a new world?"})
        public boolean playerGetsGuidebookOnFirstJoin = true;
        @Config.Comment(value={"Should supply chests be craftable on this server?"})
        public boolean supplyChests = true;
        @Config.Comment(value={"Should players be able to place an infinite amount of supplychests?"})
        public boolean allowInfiniteSupplyChests = false;
        @Config.RangeInt(min=10, max=600)
        @Config.Comment(value={"Average citizen respawn interval (in seconds)"})
        public int citizenRespawnInterval = 60;
        @Config.Comment(value={"Max citizens in one colony"})
        public int maxCitizenPerColony = 50;
        @Config.Comment(value={"Should builder and miner build without resources? (this also turns off what they produce)"})
        public boolean builderInfiniteResources = false;
        @Config.Comment(value={"Should there be at max 1 warehouse per colony?"})
        public boolean limitToOneWareHousePerColony = true;
        @Config.Comment(value={"Delay after each block placement (Increasing it, increases the delay)"})
        public int builderBuildBlockDelay = 15;
        @Config.Comment(value={"Delay modifier to mine a block (Decreasing it, decreases the delay)"})
        public int blockMiningDelayModifier = 500;
        @Config.Comment(value={"Should workers work during the rain?"})
        public boolean workersAlwaysWorkInRain = false;
        @Config.Comment(value={"Should the colony protection be enabled?"})
        public boolean enableColonyProtection = true;
        @Config.Comment(value={"Independend from the colony protection, should explosions be turned off?"})
        public boolean turnOffExplosionsInColonies = true;
        @Config.Comment(value={"Whether or not to spawn barbarians"})
        public boolean doBarbariansSpawn = true;
        @Config.RangeInt(min=0, max=10)
        @Config.Comment(value={"The difficulty setting for barbarians"})
        public int barbarianHordeDifficulty = 5;
        @Config.RangeInt(min=5, max=60)
        @Config.Comment(value={"The max size of a barbarian horde"})
        public int maxBarbarianHordeSize = 40;
        @Config.Comment(value={"The average amount of nights between raids"})
        public int averageNumberOfNightsBetweenRaids = 3;
        @Config.Comment(value={"The minimum number of nights between raids"})
        public int minimumNumberOfNightsBetweenRaids = 1;
        @Config.Comment(value={"Should players be allowed to build their colonies over existing villages?"})
        public boolean protectVillages = false;
        @Config.Comment(value={"Should the default schematics be ignored (from the jar)?"})
        public boolean ignoreSchematicsFromJar = false;
        @Config.Comment(value={"Should player made schematics be allowed"})
        public boolean allowPlayerSchematics = false;
        @Config.Comment(value={"Max amount of schematics to be cached on the server"})
        public int maxCachedSchematics = 100;
        @Config.Comment(value={"Should players be allowed to change names? -1 for false, 0 for specific groups, 1 for true"})
        public int allowGlobalNameChanges = 1;
        @Config.Comment(value={"Players who have special permission (Patreons for example)"})
        public String[] specialPermGroup = new String[]{"_Raycoms_"};
        @Config.Comment(value={"Time until a next teleport can be executed (in seconds)"})
        public int teleportBuffer = 120;
        @Config.Comment(value={"Which level counts as op level on the server"})
        public int opLevelForServer = 3;
        @Config.Comment(value={"Sets the amount of hours until a colony will be deleted after not seeing it's mayor, set to zero to disable"})
        public int autoDeleteColoniesInHours = 0;
        @Config.Comment(value={"Sets weither or not Colony structures are destroyed automatically."})
        public boolean autoDestroyColonyBlocks = true;
        @Config.Comment(value={"Should the player be allowed to use the '/mc rtp' command?"})
        public boolean canPlayerUseRTPCommand = true;
        @Config.Comment(value={"Should the player be allowed to use the '/mc colony teleport' command?"})
        public boolean canPlayerUseColonyTPCommand = false;
        @Config.Comment(value={"Should the player be allowed to use the '/mc home' command?"})
        public boolean canPlayerUseHomeTPCommand = true;
        @Config.Comment(value={"Should the player be allowed to use the '/mc citizens info' command?"})
        public boolean canPlayerUseCitizenInfoCommand = true;
        @Config.Comment(value={"Should the player be allowed to use the '/mc citizens list' command?"})
        public boolean canPlayerUseListCitizensCommand = true;
        @Config.Comment(value={"Should the player be allowed to use the '/mc citizens respawn' command?"})
        public boolean canPlayerRespawnCitizensCommand = true;
        @Config.Comment(value={"Should the player be allowed to use the '/mc colony info' command?"})
        public boolean canPlayerUseShowColonyInfoCommand = true;
        @Config.Comment(value={"Should the player be allowed to use the '/mc citizens kill' command?"})
        public boolean canPlayerUseKillCitizensCommand = true;
        @Config.Comment(value={"Should the player be allowed to use the '/mc colony addOfficer' command?"})
        public boolean canPlayerUseAddOfficerCommand = true;
        @Config.Comment(value={"Should the player be allowed to use the '/mc colony delete' command?"})
        public boolean canPlayerUseDeleteColonyCommand = true;
        @Config.Comment(value={"Should the player be allowed to use the '/mc colony refresh' command?"})
        public boolean canPlayerUseRefreshColonyCommand = false;
        @Config.Comment(value={"Should the player be allowed to use the '/mc backup' command?"})
        public boolean canPlayerUseBackupCommand = false;
        @Config.Comment(value={"Amount of attemps to find a save rtp"})
        public int numberOfAttemptsForSafeTP = 4;
        @Config.Comment(value={"Should the min/max distance from spawn also affect colony placement?"})
        public boolean restrictColonyPlacement = false;
        @Config.Comment(value={"Max distance from world spawn"})
        public int maxDistanceFromWorldSpawn = 8000;
        @Config.Comment(value={"Min distance from world spawn"})
        public int minDistanceFromWorldSpawn = 512;
        @Config.Comment(value={"Should the dman create resources out of hot air (Not implemented)"})
        public boolean deliverymanInfiniteResources = false;
        @Config.Comment(value={"Amount of initial citizens"})
        public int maxCitizens = 4;
        @Config.Comment(value={"Should citizen name tags be rendered?"})
        public boolean alwaysRenderNameTag = true;
        @Config.Comment(value={"Amount of blocks the builder checks (to decrease lag by builder)"})
        public int maxBlocksCheckedByBuilder = 1000;
        @Config.Comment(value={"Chat frequency of worker requests"})
        public int chatFrequency = 30;
        @Config.Comment(value={"Should in development features be enabled (might be buggy)"})
        public boolean enableInDevelopmentFeatures = false;
        @Config.Comment(value={"Blocks players should be able to interact with in any colony (Ex vending machines)"})
        public String[] freeToInteractBlocks = new String[]{"block:dirt", "0 0 0"};
        @Config.Comment(value={"Should colonies in other dimensions be allowed (Default = false)?"})
        public boolean allowOtherDimColonies = false;
        @Config.Comment(value={"ResourceLocations for extra entities for the GuardHut's list. \nonce done you'll need to recalculate the list.EntityMob's already calculated in list."})
        public String[] guardResourceLocations = new String[]{"minecraft:slime", "tconstruct:blueslime"};
    }
}

