/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility.candb;

import com.minecolonies.api.compatibility.candb.AbstractChiselAndBitsProxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IBitVisitor;
import mod.chiselsandbits.api.IChiseledBlockTileEntity;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.Optional;
import org.jetbrains.annotations.NotNull;

public final class ChiselAndBitsCheck
extends AbstractChiselAndBitsProxy {
    private static final String CANDB = "chiselsandbits";

    public static boolean isChiselAndBitsTileEntity(@NotNull TileEntity tileEntity) {
        return new ChiselAndBitsCheck().checkForChiselAndBitsTileEntity(tileEntity);
    }

    public static boolean isChiselAndBitsBlock(@NotNull IBlockState blockState) {
        return new ChiselAndBitsCheck().checkForChiselAndBitsBlock(blockState);
    }

    public static List<ItemStack> getBitStacks(TileEntity tileEntity) {
        return new ChiselAndBitsCheck().getChiseledStacks(tileEntity);
    }

    @Override
    @Optional.Method(modid="chiselsandbits")
    public boolean checkForChiselAndBitsBlock(@NotNull IBlockState blockState) {
        return blockState.func_177230_c() instanceof BlockChiseled;
    }

    @Override
    @Optional.Method(modid="chiselsandbits")
    public boolean checkForChiselAndBitsTileEntity(@NotNull TileEntity tileEntity) {
        return tileEntity instanceof IChiseledBlockTileEntity;
    }

    @Override
    @Optional.Method(modid="chiselsandbits")
    public List<ItemStack> getChiseledStacks(@NotNull TileEntity tileEntity) {
        if (tileEntity instanceof IChiseledBlockTileEntity) {
            IBitAccess access = ((IChiseledBlockTileEntity)tileEntity).getBitAccess();
            final ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            access.visitBits(new IBitVisitor(){

                public IBitBrush visitBit(int x, int y, int z, IBitBrush iBitBrush) {
                    if (iBitBrush.getStateID() != 0) {
                        stacks.add(iBitBrush.getItemStack(x));
                    }
                    return iBitBrush;
                }
            });
            return stacks;
        }
        return Collections.emptyList();
    }
}

