/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility;

import com.minecolonies.api.compatibility.tinkers.SlimeTreeCheck;
import com.minecolonies.api.compatibility.tinkers.TinkersWeaponHelper;
import com.minecolonies.api.compatibility.tinkers.ToolBrokenCheck;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Compatibility {
    private Compatibility() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean getMiningLevelCompatibility(@Nullable ItemStack stack, @Nullable String tool) {
        return !ToolBrokenCheck.checkTinkersBroken(stack);
    }

    public static boolean isSlimeBlock(@NotNull Block block) {
        return SlimeTreeCheck.isSlimeBlock(block);
    }

    public static boolean isSlimeLeaf(@NotNull Block block) {
        return SlimeTreeCheck.isSlimeLeaf(block);
    }

    public static boolean isSlimeSapling(@NotNull Block block) {
        return SlimeTreeCheck.isSlimeSapling(block);
    }

    public static boolean isSlimeDirtOrGrass(@NotNull Block block) {
        return SlimeTreeCheck.isSlimeDirtOrGrass(block);
    }

    public static int getLeafVariant(@NotNull IBlockState leaf) {
        return SlimeTreeCheck.getLeafVariant(leaf);
    }

    public static boolean isTinkersWeapon(@NotNull ItemStack stack) {
        return TinkersWeaponHelper.isTinkersSword(stack);
    }

    public static double getAttackDamage(@NotNull ItemStack stack) {
        return TinkersWeaponHelper.getDamage(stack);
    }

    public static int getToolLevel(@NotNull ItemStack stack) {
        return TinkersWeaponHelper.getToolLvl(stack);
    }

    public static boolean isPamsInstalled() {
        return Loader.isModLoaded((String)"harvestcraft");
    }
}

