/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.minecolonies.api.compatibility.ICompatabilityManager;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;

public class CompatabilityManager
implements ICompatabilityManager {
    private final BiMap<IBlockState, ItemStorage> leavesToSaplingMap = HashBiMap.create();
    private final List<ItemStorage> saplings = new ArrayList<ItemStorage>();
    private final List<Block> ores = new ArrayList<Block>();
    public static final String ORE_STRING = "ore";

    @Override
    public void discover(World world) {
        this.discoverSaplings();
        for (String string : OreDictionary.getOreNames()) {
            if (!string.contains(ORE_STRING)) continue;
            this.discoverOres(string);
        }
    }

    @Override
    public IBlockState getLeaveForSapling(ItemStack stack) {
        if (this.leavesToSaplingMap.inverse().containsKey((Object)new ItemStorage(stack, false, true))) {
            return (IBlockState)this.leavesToSaplingMap.inverse().get((Object)new ItemStorage(stack, false, true));
        }
        return null;
    }

    @Override
    public ItemStack getSaplingForLeave(IBlockState block) {
        ItemStack stack = new ItemStack(block.func_177230_c(), 1, block.func_177230_c().func_176201_c(block));
        IBlockState tempLeave = BlockLeaves.func_149634_a((Item)stack.func_77973_b()).func_176203_a(stack.func_77960_j());
        if (this.leavesToSaplingMap.containsKey((Object)tempLeave)) {
            return ((ItemStorage)this.leavesToSaplingMap.get((Object)tempLeave)).getItemStack();
        }
        return null;
    }

    @Override
    public List<ItemStorage> getCopyOfSaplings() {
        return new ArrayList<ItemStorage>(this.saplings);
    }

    @Override
    public boolean isOre(IBlockState block) {
        if (block.func_177230_c() instanceof BlockOre || block.func_177230_c() instanceof BlockRedstoneOre) {
            return true;
        }
        return this.ores.contains(block.func_177230_c());
    }

    @Override
    public boolean isOre(@NotNull ItemStack stack) {
        int[] ids;
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return false;
        }
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)id).contains(ORE_STRING)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        NBTTagList saplingsLeavesTagList = this.leavesToSaplingMap.entrySet().stream().map(entry -> CompatabilityManager.writeLeaveSaplingEntryToNBT((IBlockState)entry.getKey(), (ItemStorage)entry.getValue())).collect(NBTUtils.toNBTTagList());
        compound.func_74782_a("tagSapLeaves", (NBTBase)saplingsLeavesTagList);
        NBTTagList saplingTagList = this.saplings.stream().map(sap -> sap.getItemStack().func_77955_b(new NBTTagCompound())).collect(NBTUtils.toNBTTagList());
        compound.func_74782_a("tagSaplings", (NBTBase)saplingTagList);
        try {
            NBTTagList oresTagList = this.ores.stream().map(ore -> NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)ore.func_176223_P())).collect(NBTUtils.toNBTTagList());
            compound.func_74782_a("tagOres", (NBTBase)oresTagList);
        }
        catch (Exception e) {
            Log.getLogger().error("Error caught during ore serialization!", (Throwable)e);
        }
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        NBTUtils.streamCompound(compound.func_150295_c("tagSapLeaves", 10)).map(CompatabilityManager::readLeaveSaplingEntryFromNBT).filter(key -> !this.leavesToSaplingMap.containsKey(key.func_76341_a()) && !this.leavesToSaplingMap.containsValue(key.func_76340_b())).forEach(key -> {
            ItemStorage cfr_ignored_0 = (ItemStorage)this.leavesToSaplingMap.put(key.func_76341_a(), key.func_76340_b());
        });
        List storages = NBTUtils.streamCompound(compound.func_150295_c("tagSaplings", 10)).map(tempCompound -> new ItemStorage(new ItemStack(tempCompound), false, true)).collect(Collectors.toList());
        for (ItemStorage storage : storages) {
            if (this.saplings.contains(storage)) continue;
            this.saplings.add(storage);
        }
        List states = NBTUtils.streamCompound(compound.func_150295_c("tagOres", 10)).map(NBTUtil::func_190008_d).collect(Collectors.toList());
        for (IBlockState state : states) {
            if (this.ores.contains(state.func_177230_c())) continue;
            this.ores.add(state.func_177230_c());
        }
    }

    @Override
    public void connectLeaveToSapling(IBlockState leave, ItemStack stack) {
        ItemStack tempStack = new ItemStack(leave.func_177230_c(), 1, leave.func_177230_c().func_176201_c(leave));
        IBlockState tempLeave = BlockLeaves.func_149634_a((Item)tempStack.func_77973_b()).func_176203_a(tempStack.func_77960_j());
        if (!this.leavesToSaplingMap.containsKey((Object)tempLeave) && !this.leavesToSaplingMap.containsValue((Object)new ItemStorage(stack, false, true))) {
            this.leavesToSaplingMap.put((Object)tempLeave, (Object)new ItemStorage(stack, false, true));
        }
    }

    private void discoverOres(String string) {
        for (ItemStack ore : OreDictionary.getOres((String)string)) {
            for (CreativeTabs tabs : CreativeTabs.field_78032_a) {
                NonNullList list = NonNullList.func_191196_a();
                ore.func_77973_b().func_150895_a(tabs, list);
                for (ItemStack stack : list) {
                    Block block;
                    if (ItemStackUtils.isEmpty(stack).booleanValue() || !(stack.func_77973_b() instanceof ItemBlock) || this.ores.contains(block = ((ItemBlock)stack.func_77973_b()).func_179223_d())) continue;
                    this.ores.add(block);
                }
            }
        }
        Log.getLogger().info("Finished discovering ores");
    }

    private void discoverSaplings() {
        for (ItemStack saps : OreDictionary.getOres((String)"treeSapling")) {
            if (!saps.func_77981_g()) continue;
            for (CreativeTabs tabs : CreativeTabs.field_78032_a) {
                NonNullList list = NonNullList.func_191196_a();
                saps.func_77973_b().func_150895_a(tabs, list);
                for (ItemStack stack : list) {
                    if (ItemStackUtils.isEmpty(stack).booleanValue() || this.leavesToSaplingMap.containsValue((Object)new ItemStorage(stack, false, true)) || this.saplings.contains(new ItemStorage(stack, false, true))) continue;
                    this.saplings.add(new ItemStorage(stack, false, true));
                }
            }
        }
        Log.getLogger().info("Finished discovering saplings");
    }

    private static NBTTagCompound writeLeaveSaplingEntryToNBT(IBlockState state, ItemStorage storage) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTUtil.func_190009_a((NBTTagCompound)compound, (IBlockState)state);
        storage.getItemStack().func_77955_b(compound);
        return compound;
    }

    private static Tuple<IBlockState, ItemStorage> readLeaveSaplingEntryFromNBT(NBTTagCompound compound) {
        return new Tuple((Object)NBTUtil.func_190008_d((NBTTagCompound)compound), (Object)new ItemStorage(new ItemStack(compound), false, true));
    }
}

