/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.traits;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import landmaster.plustic.api.Toggle;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class Ignoble
extends AbstractTrait {
    public static final Ignoble ignoble = new Ignoble();
    public static final float MAX_IGNOBILITY = 40.0f;
    public static final String ENTITIES_TAG = "IgnobleEntities";
    public static final String METER_TAG = "IgnobleMeter";

    public Ignoble() {
        super("ignoble", 2556211);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Toggle.toggleable.add(this.identifier);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void tooltip(ItemTooltipEvent event) {
        NBTTagCompound nbt0 = TagUtil.getTagSafe((ItemStack)event.getItemStack());
        if (event.isCanceled() || event.getItemStack() == null || !TinkerUtil.hasTrait((NBTTagCompound)nbt0, (String)this.getIdentifier())) {
            return;
        }
        event.getToolTip().add(I18n.func_135052_a((String)"tooltip.plustic.ignoblemodifier.info", (Object[])new Object[]{Float.valueOf(nbt0.func_74760_g(METER_TAG))}));
    }

    public void onHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, boolean isCritical) {
        NBTTagCompound nbt = TagUtil.getTagSafe((ItemStack)tool);
        if (Toggle.getToggleState(nbt, this.identifier) && player.func_70093_af()) {
            float damageToDeal = Math.min(nbt.func_74760_g(METER_TAG), target.func_110138_aP());
            target.func_70097_a(new EntityDamageSource("ignoble", (Entity)player).func_76348_h().func_151518_m().func_82726_p(), damageToDeal);
            nbt.func_74776_a(METER_TAG, nbt.func_74760_g(METER_TAG) - damageToDeal);
        }
    }

    public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K && entity instanceof EntityLivingBase) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            NBTTagCompound nbt = TagUtil.getTagSafe((ItemStack)tool);
            NBTTagCompound ignoble = TagUtil.getTagSafe((NBTTagCompound)nbt, (String)ENTITIES_TAG);
            Iterator it = ignoble.func_150296_c().iterator();
            while (it.hasNext()) {
                String uuidString = (String)it.next();
                UUID uuid = UUID.fromString(uuidString);
                Entity victim = server.func_175576_a(uuid);
                if (victim == null) {
                    it.remove();
                    continue;
                }
                if (victim.func_70089_S()) continue;
                float initialHealth = ignoble.func_74760_g(uuidString);
                float diff = initialHealth - ((EntityLivingBase)entity).func_110143_aJ();
                if (diff > 0.0f) {
                    nbt.func_74776_a(METER_TAG, MathHelper.func_76131_a((float)(nbt.func_74760_g(METER_TAG) + diff), (float)0.0f, (float)40.0f));
                }
                it.remove();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void defend(LivingHurtEvent event) {
        if (!event.getEntity().func_130014_f_().field_72995_K) {
            Arrays.stream(EnumHand.values()).map(arg_0 -> ((EntityLivingBase)event.getEntityLiving()).func_184586_b(arg_0)).filter(stack -> TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)stack), (String)this.identifier)).findFirst().ifPresent(stack -> Ignoble.getAttacker(event.getSource()).ifPresent(attacker -> {
                String uuidString;
                NBTTagCompound nbt = TagUtil.getTagSafe((ItemStack)stack);
                NBTTagCompound ignoble = TagUtil.getTagSafe((NBTTagCompound)nbt, (String)ENTITIES_TAG);
                if (!ignoble.func_74764_b(uuidString = attacker.func_110124_au().toString())) {
                    ignoble.func_74776_a(uuidString, event.getEntityLiving().func_110143_aJ());
                }
                nbt.func_74782_a(ENTITIES_TAG, (NBTBase)ignoble);
                stack.func_77982_d(nbt);
            }));
        }
    }

    @Nonnull
    private static Optional<Entity> getAttacker(DamageSource source) {
        if (source instanceof EntityDamageSource) {
            return Optional.ofNullable(((EntityDamageSource)source).func_76346_g());
        }
        return Optional.empty();
    }
}

