/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.traits;

import java.util.Arrays;
import java.util.function.Predicate;
import landmaster.plustic.api.Portal;
import landmaster.plustic.api.Toggle;
import landmaster.plustic.util.Coord4D;
import landmaster.plustic.util.Utils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public abstract class DeathSaveTrait
extends AbstractTrait {
    private final int cost;
    private final Predicate<ItemStack> stackMatcher;
    private final String unlocSaveMessage;

    public DeathSaveTrait(String identifier, int color, int cost, Predicate<ItemStack> stackMatcher, String unlocSaveMessage) {
        super(identifier, color);
        this.cost = cost;
        this.stackMatcher = stackMatcher;
        this.unlocSaveMessage = unlocSaveMessage;
        MinecraftForge.EVENT_BUS.register((Object)this);
        Toggle.toggleable.add(identifier);
        Portal.portalable.add(identifier);
    }

    public String getLocalizedDesc() {
        return String.format(super.getLocalizedDesc(), this.cost);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void timing(LivingHurtEvent event) {
        if (event.getEntity().func_130014_f_().field_72995_K || !(event.getEntity() instanceof EntityPlayerMP) || event.getEntityLiving().func_110143_aJ() > event.getAmount()) {
            return;
        }
        Arrays.stream(EnumHand.values()).map(arg_0 -> ((EntityLivingBase)event.getEntityLiving()).func_184586_b(arg_0)).map(TagUtil::getTagSafe).filter(nbt -> TinkerUtil.hasTrait((NBTTagCompound)nbt, (String)this.identifier) && Toggle.getToggleState(nbt, this.identifier) && nbt.func_150297_b("nickoftime", 10)).map(nbt -> nbt.func_74775_l("nickoftime")).map(Coord4D::fromNBT).filter(coord -> Utils.canTeleportTo((EntityPlayer)event.getEntity(), coord)).findFirst().ifPresent(coord -> {
            IItemHandler ih = (IItemHandler)event.getEntity().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int i = 0; i < ih.getSlots(); ++i) {
                ItemStack is = ih.extractItem(i, this.cost, true);
                if (!this.stackMatcher.test(is) || is.func_190916_E() < this.cost) continue;
                Utils.teleportPlayerTo((EntityPlayerMP)event.getEntity(), coord);
                ih.extractItem(i, this.cost, false);
                event.setCanceled(true);
                event.getEntityLiving().func_70674_bp();
                event.getEntityLiving().func_70066_B();
                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76426_n, 160));
                event.getEntity().func_145747_a((ITextComponent)new TextComponentTranslation(this.unlocSaveMessage, new Object[0]));
                return;
            }
        });
    }
}

