/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.proxy;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import landmaster.plustic.entity.EntityBlindBandit;
import landmaster.plustic.entity.EntitySupremeLeader;
import landmaster.plustic.entity.render.RenderBlindBandit;
import landmaster.plustic.entity.render.RenderSupremeLeader;
import landmaster.plustic.modules.ModuleTools;
import landmaster.plustic.proxy.CommonProxy;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import slimeknights.tconstruct.common.ModelRegisterUtil;
import slimeknights.tconstruct.library.TinkerRegistryClient;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.ToolBuildGuiInfo;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.tools.ToolCore;

public class ClientProxy
extends CommonProxy {
    private static Map<String, KeyBinding> keyBindings;

    @Override
    public void registerItemRenderer(Item item, int meta, String id) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("plustic:" + id, "inventory"));
    }

    @Override
    public void setRenderInfo(Material mat, int color) {
        mat.setRenderInfo(color);
    }

    @Override
    public void setRenderInfo(Material mat, int lo, int mid, int hi) {
        mat.setRenderInfo((MaterialRenderInfo)new MaterialRenderInfo.MultiColor(lo, mid, hi));
    }

    @Override
    public void registerFluidModels(Fluid fluid) {
        if (fluid == null) {
            return;
        }
        Block block = fluid.getBlock();
        if (block != null) {
            Item item = Item.func_150898_a((Block)block);
            FluidStateMapper mapper = new FluidStateMapper(fluid);
            if (item != null) {
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
                ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
            }
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
        }
    }

    @Override
    public void registerKeyBindings() {
        keyBindings = ImmutableMap.of((Object)"release_entity", (Object)new KeyBinding("key.plustic_release_entity.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, 11, "key.categories.plustic"), (Object)"toggle_gui", (Object)new KeyBinding("key.plustic_toggle_gui.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, 23, "key.categories.plustic"), (Object)"set_portal", (Object)new KeyBinding("key.plustic_set_portal.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, 49, "key.categories.plustic"), (Object)"brown_magic", (Object)new KeyBinding("key.plustic_brown_magic.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, 24, "key.categories.plustic"), (Object)"toggle_tool", (Object)new KeyBinding("key.plustic_toggle_tool.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.ALT, 51, "key.categories.plustic"));
        for (KeyBinding kb : keyBindings.values()) {
            ClientRegistry.registerKeyBinding((KeyBinding)kb);
        }
    }

    @Override
    public void registerToolModel(ToolCore tc) {
        ModelRegisterUtil.registerToolModel((ToolCore)tc);
    }

    @Override
    public void registerModifierModel(IModifier mod, ResourceLocation rl) {
        ModelRegisterUtil.registerModifierModel((IModifier)mod, (ResourceLocation)rl);
    }

    @Override
    public <T extends Item> void registerToolPartModel(T part) {
        ModelRegisterUtil.registerPartModel(part);
    }

    @Override
    public void initEntities() {
        super.initEntities();
        RenderingRegistry.registerEntityRenderingHandler(EntityBlindBandit.class, RenderBlindBandit::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySupremeLeader.class, RenderSupremeLeader::new);
    }

    @Override
    public void initToolGuis() {
        if (ModuleTools.katana != null) {
            ToolBuildGuiInfo katanaInfo = new ToolBuildGuiInfo((TinkersItem)ModuleTools.katana);
            katanaInfo.addSlotPosition(33, 60);
            katanaInfo.addSlotPosition(53, 22);
            katanaInfo.addSlotPosition(33, 42);
            katanaInfo.addSlotPosition(15, 60);
            TinkerRegistryClient.addToolBuilding((ToolBuildGuiInfo)katanaInfo);
        }
        if (ModuleTools.laserGun != null) {
            ToolBuildGuiInfo laserGunInfo = new ToolBuildGuiInfo((TinkersItem)ModuleTools.laserGun);
            laserGunInfo.addSlotPosition(7, 64);
            laserGunInfo.addSlotPosition(25, 38);
            laserGunInfo.addSlotPosition(49, 38);
            laserGunInfo.addSlotPosition(7, 38);
            TinkerRegistryClient.addToolBuilding((ToolBuildGuiInfo)laserGunInfo);
        }
    }

    @Override
    public boolean isControlPressed(String control) {
        return keyBindings.get(control).func_151468_f();
    }

    public static class FluidStateMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        public final Fluid fluid;
        public final ModelResourceLocation location;

        public FluidStateMapper(Fluid fluid) {
            this.fluid = fluid;
            this.location = new ModelResourceLocation(new ResourceLocation("plustic", "fluid_block"), fluid.getName());
        }

        @Nonnull
        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            return this.location;
        }

        @Nonnull
        public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
            return this.location;
        }
    }
}

