/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.api;

import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import landmaster.plustic.PlusTiC;
import landmaster.plustic.net.PacketHandleToggleGui;
import landmaster.plustic.net.PacketHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class Toggle {
    public static final Set<String> toggleable;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void testAndToggle(InputEvent.KeyInputEvent event) {
        if (PlusTiC.proxy.isControlPressed("toggle_gui") && Toggle.canToggle(Minecraft.func_71410_x().field_71439_g.func_184614_ca())) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new Gui((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void tooltip(ItemTooltipEvent event) {
        if (event.getItemStack() == null || !(event.getItemStack().func_77973_b() instanceof ToolCore)) {
            return;
        }
        NBTTagCompound nbt = TagUtil.getTagSafe((ItemStack)event.getItemStack());
        NBTTagList traits = TagUtil.getTraitsTagList((NBTTagCompound)nbt);
        NBTTagCompound toggle = TagUtil.getTagSafe((NBTTagCompound)nbt, (String)"PlusTiC_toggle");
        for (int i = 0; i < traits.func_74745_c(); ++i) {
            String identifier = traits.func_150307_f(i);
            if (!toggleable.contains(identifier)) continue;
            boolean enabled = !toggle.func_74764_b(identifier);
            event.getToolTip().add(I18n.func_135052_a((String)("tooltip.plustic.toggle.state." + enabled), (Object[])new Object[]{TinkerRegistry.getModifier((String)identifier).getLocalizedName()}));
        }
    }

    public static boolean canToggle(ItemStack is) {
        return Toggle.canToggle(TagUtil.getTagSafe((ItemStack)is));
    }

    public static boolean canToggle(NBTTagCompound nbt) {
        NBTTagList traits = TagUtil.getTraitsTagList((NBTTagCompound)nbt);
        for (int i = 0; i < traits.func_74745_c(); ++i) {
            if (!toggleable.contains(traits.func_150307_f(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean getToggleState(ItemStack is, String identifier) {
        NBTTagCompound nbt = TagUtil.getTagSafe((ItemStack)is);
        return Toggle.getToggleState(nbt, identifier);
    }

    public static boolean getToggleState(NBTTagCompound nbt, String identifier) {
        NBTTagCompound toggle = TagUtil.getTagSafe((NBTTagCompound)nbt, (String)"PlusTiC_toggle");
        return !(!TinkerUtil.hasTrait((NBTTagCompound)nbt, (String)identifier) && !TinkerUtil.hasModifier((NBTTagCompound)nbt, (String)identifier) || toggleable.contains(identifier) && toggle.func_74764_b(identifier));
    }

    public static void setToggleState(NBTTagCompound nbt, String identifier, boolean value) {
        if (!toggleable.contains(identifier) || !TinkerUtil.hasTrait((NBTTagCompound)nbt, (String)identifier) && !TinkerUtil.hasModifier((NBTTagCompound)nbt, (String)identifier)) {
            return;
        }
        NBTTagCompound toggle = TagUtil.getTagSafe((NBTTagCompound)nbt, (String)"PlusTiC_toggle");
        if (value) {
            toggle.func_82580_o(identifier);
        } else {
            toggle.func_74757_a(identifier, false);
        }
        nbt.func_74782_a("PlusTiC_toggle", (NBTBase)toggle);
    }

    static {
        MinecraftForge.EVENT_BUS.register(Toggle.class);
        toggleable = new HashSet<String>();
    }

    public static class Gui
    extends GuiScreen {
        public static final int OPTIONS_PER_PAGE = 6;
        private final ResourceLocation background = new ResourceLocation("plustic", "textures/gui/toggle.png");
        private int page;
        private EntityPlayer player;
        private List<String> identifiers;
        private BooleanList enableds;
        private int xSize = 176;
        private int ySize = 128;
        private int guiLeft;
        private int guiTop;

        public Gui(EntityPlayer player) {
            this.player = player;
            this.page = 0;
            this.identifiers = new ArrayList<String>();
            this.enableds = new BooleanArrayList();
            NBTTagCompound nbt = TagUtil.getTagSafe((ItemStack)this.player.func_184614_ca());
            NBTTagList traits = TagUtil.getTraitsTagList((NBTTagCompound)nbt);
            for (int i = 0; i < traits.func_74745_c(); ++i) {
                String identifier = traits.func_150307_f(i);
                if (!toggleable.contains(identifier)) continue;
                this.identifiers.add(identifier);
                this.enableds.add(Toggle.getToggleState(nbt, identifier));
            }
        }

        public void func_73866_w_() {
            super.func_73866_w_();
            this.guiLeft = (this.field_146294_l - this.xSize) / 2;
            this.guiTop = (this.field_146295_m - this.ySize) / 2;
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            int i;
            super.func_73863_a(mouseX, mouseY, partialTicks);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179141_d();
            GL11.glEnable((int)3042);
            this.field_146297_k.field_71446_o.func_110577_a(this.background);
            this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.header.toggle", (Object[])new Object[0]), this.guiLeft + 5, this.guiTop + 5, 0xFFFFFF);
            this.field_146297_k.field_71446_o.func_110577_a(this.background);
            for (i = 0; i < Math.min(6, this.identifiers.size() - this.page * 6); ++i) {
                this.func_73729_b(this.guiLeft + 7, this.guiTop + 18 * (i + 1), 0, 128, 114, 16);
            }
            for (i = this.page * 6; i < Math.min((this.page + 1) * 6, this.identifiers.size()); ++i) {
                String identifier = this.identifiers.get(i);
                boolean enabled = (Boolean)this.enableds.get(i);
                this.field_146289_q.func_78276_b(TinkerRegistry.getModifier((String)identifier).getLocalizedName(), this.guiLeft + 10, this.guiTop + 18 * (i + 1) + 3, 0xFFFFFF);
                this.field_146297_k.field_71446_o.func_110577_a(this.background);
                this.func_73729_b(this.guiLeft + 96, this.guiTop + 18 * (i + 1) + 1, 176 + (enabled ? 0 : 12), 0, 12, 12);
                if (!this.isPointInRegion(7, 18 * (i + 1), 114, 16, mouseX, mouseY)) continue;
                this.func_146283_a(Arrays.asList(I18n.func_135052_a((String)"tooltip.plustic.toggle.info", (Object[])new Object[0]), I18n.func_135052_a((String)("tooltip.plustic.toggle.state." + enabled), (Object[])new Object[]{TinkerRegistry.getModifier((String)identifier).getLocalizedName()})), mouseX, mouseY);
            }
        }

        public void func_73864_a(int mouseX, int mouseY, int mouseButton) {
            try {
                super.func_73864_a(mouseX, mouseY, mouseButton);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (int i = 0; i < Math.min(6, this.identifiers.size() - this.page * 6); ++i) {
                if (!this.isPointInRegion(7, 18 * (i + 1), 114, 16, mouseX, mouseY)) continue;
                String identifier = this.identifiers.get(this.page * 6 + i);
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketHandleToggleGui(identifier));
                return;
            }
        }

        protected boolean isPointInRegion(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
            int i = this.guiLeft;
            int j = this.guiTop;
            return (pointX -= i) >= rectX - 1 && pointX < rectX + rectWidth + 1 && (pointY -= j) >= rectY - 1 && pointY < rectY + rectHeight + 1;
        }

        public void update(String identifier, boolean value) {
            int ind = this.identifiers.indexOf(identifier);
            if (ind >= 0) {
                this.enableds.set(ind, value);
            }
        }
    }
}

