/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import landmaster.plustic.config.Config;
import landmaster.plustic.modules.IModule;
import landmaster.plustic.modules.ModuleActAdd;
import landmaster.plustic.modules.ModuleAdvRocketry;
import landmaster.plustic.modules.ModuleAppEng2;
import landmaster.plustic.modules.ModuleArmorPlus;
import landmaster.plustic.modules.ModuleAvaritia;
import landmaster.plustic.modules.ModuleBase;
import landmaster.plustic.modules.ModuleBoP;
import landmaster.plustic.modules.ModuleBotania;
import landmaster.plustic.modules.ModuleDraconicEvolution;
import landmaster.plustic.modules.ModuleEnvironTech;
import landmaster.plustic.modules.ModuleGalacticraft;
import landmaster.plustic.modules.ModuleGemsPlus;
import landmaster.plustic.modules.ModuleLandCore;
import landmaster.plustic.modules.ModuleLandCraft;
import landmaster.plustic.modules.ModuleMFR;
import landmaster.plustic.modules.ModuleMekanism;
import landmaster.plustic.modules.ModuleModifiers;
import landmaster.plustic.modules.ModuleNatura;
import landmaster.plustic.modules.ModuleProjectE;
import landmaster.plustic.modules.ModulePsi;
import landmaster.plustic.modules.ModuleSurvivalist;
import landmaster.plustic.modules.ModuleTF;
import landmaster.plustic.modules.ModuleTools;
import landmaster.plustic.net.PacketHandler;
import landmaster.plustic.proxy.CommonProxy;
import landmaster.plustic.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.tools.TinkerMaterials;

@Mod.EventBusSubscriber
@Mod(modid="plustic", name="PlusTiC", version="6.5.0.0", dependencies="required-after:mantle;required-after:tconstruct@[1.12-2.7.2.15,);required-after:forge@[14.21.1.2387,);after:mekanism;after:biomesoplenty;after:botania;after:libvulpes;after:redstoneflux;after:armorplus;after:enderio;after:projectred-exploration;after:thermalfoundation;after:substratum;after:draconicevolution;after:landcore;after:tesla;after:baubles;after:actuallyadditions;after:natura@[1.12.2-4.3.2.42,);after:psi;after:avaritia;after:landcore;after:landcraft;after:galacticraftcore;after:galacticraftplanets;after:minefactoryreloaded;after:botanicaladdons;after:survivalist;after:modernmetals;after:basemetals;after:projecte;after:gemsplus;after:appliedenergistics2;after:environmentaltech;after:industrialforegoing;after:twilightforest@[3.7,);", useMetadata=true, acceptedMinecraftVersions="[1.12, 1.13)")
public class PlusTiC {
    public static Config config;
    @Mod.Instance(value="plustic")
    public static PlusTiC INSTANCE;
    @SidedProxy(serverSide="landmaster.plustic.proxy.CommonProxy", clientSide="landmaster.plustic.proxy.ClientProxy")
    public static CommonProxy proxy;
    public static final Logger log;
    public static final Map<String, Material> materials;
    public static final Map<String, MaterialIntegration> materialIntegrations;
    public static final Map<String, CompletionStage<?>> materialIntegrationStages;
    public static final Map<String, String> materialOreDicts;
    public static final BowMaterialStats justWhy;
    private static final String[] renamesToHandle;

    @SubscribeEvent
    public static void missingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        event.getMappings().forEach(mapping -> {
            for (String name : renamesToHandle) {
                if (!mapping.key.equals((Object)new ResourceLocation("plustic", "plustic.molten_" + name))) continue;
                Optional.ofNullable(FluidRegistry.getFluid((String)name)).map(Fluid::getBlock).ifPresent(arg_0 -> ((RegistryEvent.MissingMappings.Mapping)mapping).remap(arg_0));
            }
            if (mapping.key.equals((Object)new ResourceLocation("plustic", "plustic.molten_fiery"))) {
                Optional.ofNullable(FluidRegistry.getFluid((String)"fierymetal")).map(Fluid::getBlock).ifPresent(arg_0 -> ((RegistryEvent.MissingMappings.Mapping)mapping).remap(arg_0));
            }
        });
    }

    @SubscribeEvent
    public static void missingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        event.getMappings().forEach(mapping -> {
            for (String name : renamesToHandle) {
                if (mapping.key.equals((Object)new ResourceLocation("plustic", "plustic.molten_" + name))) {
                    Optional.ofNullable(FluidRegistry.getFluid((String)name)).map(Fluid::getBlock).map(Item::func_150898_a).ifPresent(arg_0 -> ((RegistryEvent.MissingMappings.Mapping)mapping).remap(arg_0));
                }
                if (!mapping.key.equals((Object)new ResourceLocation("plustic", "plustic.molten_fiery"))) continue;
                Optional.ofNullable(FluidRegistry.getFluid((String)"fierymetal")).map(Fluid::getBlock).map(Item::func_150898_a).ifPresent(arg_0 -> ((RegistryEvent.MissingMappings.Mapping)mapping).remap(arg_0));
            }
        });
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Config(event);
        config.init1();
        proxy.initEntities();
        IModule.modules.addAll(Arrays.asList(new ModuleBase(), new ModuleNatura(), new ModuleBoP(), new ModuleMekanism(), new ModuleAdvRocketry(), new ModuleBotania(), new ModuleArmorPlus(), new ModuleTF(), new ModuleDraconicEvolution(), new ModuleActAdd(), new ModulePsi(), new ModuleAvaritia(), new ModuleLandCraft(), new ModuleLandCore(), new ModuleGalacticraft(), new ModuleSurvivalist(), new ModuleProjectE(), new ModuleGemsPlus(), new ModuleAppEng2(), new ModuleEnvironTech(), new ModuleMFR(), new ModuleTools(), new ModuleModifiers()));
        IModule.modules.forEach(IModule::init);
        config.init2(materials);
        config.update();
        PlusTiC.preIntegrate();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.initToolGuis();
        proxy.registerKeyBindings();
        PacketHandler.init();
        IModule.modules.forEach(IModule::init2);
        PlusTiC.postIntegrate();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        IModule.modules.forEach(IModule::init3);
    }

    private static void preIntegrate() {
        materials.forEach((k, v) -> {
            if (!materialIntegrations.containsKey(k)) {
                ((CompletionStage)materialIntegrationStages.getOrDefault(k, CompletableFuture.completedFuture(null))).thenRun(() -> {
                    MaterialIntegration mi = v.getRepresentativeItem().func_77973_b() == Items.field_151166_bC ? new MaterialIntegration(v, v.getFluid()) : (v.getFluid() != null ? new MaterialIntegration(v, v.getFluid(), StringUtils.capitalize((String)k)).toolforge() : new MaterialIntegration(v));
                    if (materialOreDicts.containsKey(k)) {
                        mi.representativeItem = materialOreDicts.get(k);
                    }
                    TinkerRegistry.integrate((MaterialIntegration)mi).preInit();
                    materialIntegrations.put((String)k, mi);
                });
            }
        });
    }

    private static void postIntegrate() {
        Utils.displace(TinkerMaterials.wood.getIdentifier());
    }

    static {
        log = LogManager.getLogger((String)"plustic".toUpperCase(Locale.US));
        materials = new Object2ObjectOpenHashMap();
        materialIntegrations = new Object2ObjectOpenHashMap();
        materialIntegrationStages = new Object2ObjectOpenHashMap();
        materialOreDicts = new Object2ObjectOpenHashMap();
        justWhy = new BowMaterialStats(0.2f, 0.4f, -1.0f);
        renamesToHandle = new String[]{"osmium", "titanium", "iridium", "enderium", "lumium", "platinum", "signalum", "invar"};
    }
}

