/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.rwtema.extrautils2.backend.IXUItem;
import com.rwtema.extrautils2.backend.XUItem;
import com.rwtema.extrautils2.backend.model.BoxDoubleSided;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.PassthruModelItem;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.backend.model.Transforms;
import com.rwtema.extrautils2.compatibility.CompatHelper;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.transfernodes.FacingHelper;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.blockaccess.CompatBlockAccess;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class ItemSnowglobe
extends XUItem {
    public static final int REQUIRED_BIOMES = 7;
    @CapabilityInject(value=BiomeMarker.class)
    public static Capability<BiomeMarker> markerCapability;
    public Map<BiomeDictionary.Type, String> nbt_keys;
    public Map<BiomeDictionary.Type, String> translate_keys;
    List<BiomeDictionary.Type> types = ImmutableList.of((Object)BiomeDictionary.Type.END, (Object)BiomeDictionary.Type.NETHER, (Object)BiomeDictionary.Type.OCEAN, (Object)BiomeDictionary.Type.PLAINS, (Object)BiomeDictionary.Type.MOUNTAIN, (Object)BiomeDictionary.Type.FOREST, (Object)BiomeDictionary.Type.SWAMP, (Object)BiomeDictionary.Type.SANDY, (Object)BiomeDictionary.Type.SNOWY, (Object)BiomeDictionary.Type.MAGICAL, (Object)BiomeDictionary.Type.JUNGLE, (Object)BiomeDictionary.Type.HILLS, (Object[])new BiomeDictionary.Type[0]);

    public ItemSnowglobe() {
        this.translate_keys = this.types.stream().collect(Collectors.toMap(k -> k, k -> "extrautils2.text.globe.biome." + k.toString().toLowerCase(Locale.ENGLISH)));
        this.nbt_keys = this.types.stream().collect(Collectors.toMap(k -> k, k -> k.toString().toLowerCase(Locale.ENGLISH)));
        this.translate_keys.forEach((k, v) -> Lang.translate(v, StringHelper.capFirst(k.toString().toLowerCase(Locale.ENGLISH))));
        this.func_77625_d(1);
        this.func_77627_a(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        Textures.register("globe_bottom", "globe_side", "globe_top");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBaseTexture() {
        return Textures.getSprite("globe_side");
    }

    @Override
    public void getSubItemsBase(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.add(new ItemStack(itemIn, 1, 0));
        subItems.add(new ItemStack(itemIn, 1, 1));
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, playerIn, tooltip, advanced);
        tooltip.add(TextFormatting.AQUA + Lang.translate("An entire world contained within a small glass globe. Perhaps our universe is not so different?") + TextFormatting.GRAY);
        if (stack.func_77960_j() == 1) {
            tooltip.add(Lang.translate("The snow globe has gathered enough information about our world and is now active."));
        } else {
            NBTTagCompound tagCompound = stack.func_77978_p() == null ? new NBTTagCompound() : stack.func_77978_p();
            tooltip.add(Lang.translateArgs("To activate this globe, it must travel to any %s of the following biome types:", 7));
            this.translate_keys.entrySet().stream().map(e -> Pair.of(e.getKey(), (Object)I18n.func_74838_a((String)((String)e.getValue())))).sorted(Comparator.comparing(Pair::getValue)).forEach(e -> {
                String right = (String)e.getRight();
                if (tagCompound.func_74767_n(this.nbt_keys.get(e.getKey()))) {
                    tooltip.add(" - " + TextFormatting.DARK_BLUE.toString() + TextFormatting.STRIKETHROUGH.toString() + right + TextFormatting.RESET.toString() + TextFormatting.BLUE.toString() + " " + Lang.translate("(visited)") + TextFormatting.RESET.toString());
                } else {
                    tooltip.add(" - " + TextFormatting.BLUE.toString() + right + TextFormatting.RESET.toString());
                }
            });
            tooltip.add(Lang.translate("You can either hold the globe in your inventory or throw it on the ground."));
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        final BiomeMarker marker = new BiomeMarker();
        return new ICapabilityProvider(){

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == markerCapability;
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                return (T)(capability == markerCapability ? markerCapability.cast((Object)marker) : null);
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addItemColors(ItemColors itemColors, BlockColors blockColors) {
        itemColors.func_186730_a((stack, tintIndex) -> tintIndex, new Item[]{this});
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77960_j() == 1;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.itemUpdate(worldIn, new BlockPos(entityIn), stack);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        ItemStack itemStack = this.itemUpdate(entityItem.func_130014_f_(), new BlockPos((Entity)entityItem), entityItem.func_92059_d());
        if (itemStack != null) {
            entityItem.func_92058_a(itemStack);
        }
        return false;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public ItemStack itemUpdate(World world, BlockPos pos, ItemStack input) {
        BiomeMarker marker;
        if (world.field_72995_K && (marker = (BiomeMarker)input.getCapability(markerCapability, null)) != null) {
            marker.pos = pos;
            marker.b = world.func_180494_b(pos);
        }
        if (input.func_77960_j() == 1) {
            return null;
        }
        NBTTagCompound tagCompound = input.func_77978_p();
        boolean needsUpdate = false;
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        Biome biome = world.func_180494_b(pos);
        for (BiomeDictionary.Type type : this.types) {
            String key;
            if (!CompatHelper.BiomeHasType(biome, type) || tagCompound.func_74767_n(key = this.nbt_keys.get(type))) continue;
            needsUpdate = true;
            tagCompound.func_74757_a(key, true);
        }
        if (needsUpdate) {
            input.func_77982_d(tagCompound);
            int numBiomes = 0;
            for (String s : this.nbt_keys.values()) {
                if (tagCompound.func_74767_n(s) && ++numBiomes >= 7) break;
            }
            if (numBiomes >= 7) {
                input.func_77964_b(1);
                input.func_77982_d(null);
            }
            return input;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBakedModel createModel(int metadata) {
        return new PassthruModelItem((IXUItem)this, Transforms.blockTransforms);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderHand(RenderSpecificHandEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.func_184587_cr() && player.func_184605_cv() > 0 && player.func_184600_cs() == event.getHand() && StackHelper.isNonNull(event.getItemStack()) && event.getItemStack().func_77973_b() == this) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179089_o();
            boolean flag1 = event.getHand() == EnumHand.MAIN_HAND == (player.func_184591_cq() == EnumHandSide.RIGHT);
            int j = flag1 ? 1 : -1;
            GlStateManager.func_179109_b((float)((float)j * -0.2785682f), (float)0.39344388f, (float)0.15731531f);
            Minecraft.func_71410_x().func_175597_ag().func_187457_a((AbstractClientPlayer)player, event.getPartialTicks(), event.getInterpolatedPitch(), event.getHand(), event.getSwingProgress(), event.getItemStack(), event.getEquipProgress());
            GlStateManager.func_179121_F();
            event.setCanceled(true);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addQuads(PassthruModelItem.ModelLayer model, ItemStack stack, World world, EntityLivingBase entity) {
        EntityPlayerSP player;
        model.clear();
        BoxModel boxes = new BoxModel();
        boxes.add(new BoxDoubleSided(2, 0, 2, 14, 12, 14, false));
        boxes.setTexture("globe_side").setTextures(EnumFacing.UP, "globe_top", EnumFacing.DOWN, "globe_bottom");
        model.addBoxModel(boxes);
        Biome biome = Biomes.field_76772_c;
        BiomeMarker marker = (BiomeMarker)stack.getCapability(markerCapability, null);
        if (marker != null) {
            biome = marker.b;
        }
        if (biome == null && (player = Minecraft.func_71410_x().field_71439_g) != null && player.field_70170_p != null) {
            biome = player.field_70170_p.func_180494_b(new BlockPos((Entity)player));
        }
        GlobeAccess blockStateAccess = new GlobeAccess(biome);
        BlockRendererDispatcher blockRendererDispatcher = Minecraft.func_71410_x().func_175602_ab();
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        for (BlockPos.MutableBlockPos pos : BlockPos.MutableBlockPos.func_177975_b((BlockPos)GlobeAccess.CENTER, (BlockPos)GlobeAccess.CENTER2)) {
            IBlockState state = blockStateAccess.func_180495_p((BlockPos)pos);
            if (state.func_185901_i() != EnumBlockRenderType.MODEL) continue;
            state = state.func_185899_b((IBlockAccess)blockStateAccess, (BlockPos)pos);
            IBakedModel displayModel = blockRendererDispatcher.func_184389_a(state);
            state = state.func_177230_c().getExtendedState(state, (IBlockAccess)blockStateAccess, (BlockPos)pos);
            long rand = MathHelper.func_180186_a((Vec3i)pos);
            BlockRenderLayer renderLayer = MinecraftForgeClient.getRenderLayer();
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                if (!state.func_177230_c().canRenderInLayer(state, layer)) continue;
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                for (EnumFacing facing : FacingHelper.facingPlusNull) {
                    if (facing != null && !state.func_185894_c((IBlockAccess)blockStateAccess, (BlockPos)pos, facing)) continue;
                    List quads = displayModel.func_188616_a(state, facing, rand);
                    for (BakedQuad quad : quads) {
                        VertexFormat format = quad.getFormat();
                        int[] vertex = Arrays.copyOf(quad.func_178209_a(), quad.func_178209_a().length);
                        for (int i = 0; i < 4; ++i) {
                            float v = 0.1875f;
                            vertex[i * 7] = Float.floatToRawIntBits(0.1875f + 0.625f * (Float.intBitsToFloat(vertex[i * 7]) + (float)pos.func_177958_n() - (float)GlobeAccess.CENTER.func_177958_n()) / (float)GlobeAccess.MAX_X);
                            vertex[i * 7 + 1] = Float.floatToRawIntBits(0.01f + 0.625f * (Float.intBitsToFloat(vertex[i * 7 + 1]) + (float)pos.func_177956_o() - (float)GlobeAccess.CENTER.func_177956_o()) / (float)GlobeAccess.MAX_Y);
                            vertex[i * 7 + 2] = Float.floatToRawIntBits(0.1875f + 0.625f * (Float.intBitsToFloat(vertex[i * 7 + 2]) + (float)pos.func_177952_p() - (float)GlobeAccess.CENTER.func_177952_p()) / (float)GlobeAccess.MAX_Z);
                        }
                        ForgeHooksClient.fillNormal((int[])vertex, (EnumFacing)quad.func_178210_d());
                        int tint = quad.func_178212_b() ? blockColors.func_186724_a(state, (IBlockAccess)blockStateAccess, (BlockPos)pos, quad.func_178211_c()) : -1;
                        BakedQuad bakedQuad = new BakedQuad(vertex, tint, quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), format);
                        model.addQuad(bakedQuad);
                    }
                }
            }
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)renderLayer);
        }
    }

    @Override
    public int getMaxMetadata() {
        return 0;
    }

    static {
        CapabilityManager.INSTANCE.register(BiomeMarker.class, (Capability.IStorage)new Capability.IStorage<BiomeMarker>(){

            @Nullable
            public NBTBase writeNBT(Capability<BiomeMarker> capability, BiomeMarker instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<BiomeMarker> capability, BiomeMarker instance, EnumFacing side, NBTBase nbt) {
            }
        }, () -> {
            throw new RuntimeException();
        });
    }

    public static class GlobeAccess
    extends CompatBlockAccess {
        public static final BlockPos CENTER = new BlockPos(0, 128, 0);
        public static final String[][] globe_data = new String[][]{{"gggggggggg", "gggggggggg", "gggggggggg", "gggggggggg", "gggggggggg", "gggggggggg", "gggggggggg", "gggggggggg", "gggggggggg"}, {"ssssssssss", "ssssssssss", "ssWsssssss", "ssssssssss", "ssssswppws", "sssssd  ps", "sssssp  ps", "ssssswppws", "ssssssssss"}, {"          ", "          ", "  W       ", "          ", "     wppw ", "     D  p ", "     p  p ", "     wppw ", "          "}, {"          ", " lll      ", " lWl      ", " lll      ", "     wppw ", "     p  p ", "     p  p ", "     wppw ", "          "}, {"          ", " lll      ", " lWl      ", " lll      ", "     swws ", "     wppw ", "     wppw ", "     swws ", "          "}, {"          ", " sls      ", " lll      ", " sls      ", "      ss  ", "     ssss ", "     ssss ", "      ss  ", "          "}, {"          ", "  s       ", " sls      ", "  s       ", "          ", "          ", "          ", "          ", "          "}, {"          ", "          ", "  s       ", "          ", "          ", "          ", "          ", "          ", "          "}, {"          ", "          ", "          ", "          ", "          ", "          ", "          ", "          ", "          "}, {"          ", "          ", "          ", "          ", "          ", "          ", "          ", "          ", "          "}};
        public static final int MAX_X = globe_data[0].length;
        public static final int MAX_Y = globe_data.length;
        public static final int MAX_Z = globe_data[0][0].length();
        public static final BlockPos CENTER2 = CENTER.func_177982_a(MAX_X - 1, MAX_Y - 1, MAX_Z - 1);
        public static List<Pair<List<BiomeDictionary.Type>, Map<Block, Function<IBlockState, IBlockState>>>> BUILDING_REPLACEMENTS = ImmutableList.of((Object)Pair.of((Object)ImmutableList.of((Object)BiomeDictionary.Type.DRY, (Object)BiomeDictionary.Type.HOT, (Object)BiomeDictionary.Type.SANDY), (Object)ImmutableMap.builder().put((Object)Blocks.field_150364_r, s -> Blocks.field_150322_A.func_176223_P()).put((Object)Blocks.field_150363_s, s -> Blocks.field_150322_A.func_176223_P()).put((Object)Blocks.field_150347_e, s -> Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.DEFAULT)).put((Object)Blocks.field_150344_f, s -> Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH)).put((Object)Blocks.field_150476_ad, s -> Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, s.func_177229_b((IProperty)BlockStairs.field_176309_a))).put((Object)Blocks.field_150446_ar, s -> Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, s.func_177229_b((IProperty)BlockStairs.field_176309_a))).put((Object)Blocks.field_150349_c, s -> Blocks.field_150354_m.func_176223_P()).build()), (Object)Pair.of((Object)ImmutableList.of((Object)BiomeDictionary.Type.CONIFEROUS), (Object)ImmutableMap.builder().put((Object)Blocks.field_150364_r, s -> Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE).func_177226_a((IProperty)BlockLog.field_176299_a, s.func_177229_b((IProperty)BlockLog.field_176299_a))).put((Object)Blocks.field_150363_s, s -> Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE).func_177226_a((IProperty)BlockLog.field_176299_a, s.func_177229_b((IProperty)BlockLog.field_176299_a))).put((Object)Blocks.field_150344_f, s -> Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE)).put((Object)Blocks.field_150476_ad, s -> Blocks.field_150485_bF.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, s.func_177229_b((IProperty)BlockStairs.field_176309_a))).put((Object)Blocks.field_180407_aO, s -> Blocks.field_180408_aP.func_176223_P()).put((Object)Blocks.field_180413_ao, s -> GlobeAccess.getEquivalent(s, Blocks.field_180414_ap.func_176223_P())).build()), (Object)Pair.of((Object)ImmutableList.of((Object)BiomeDictionary.Type.SAVANNA), (Object)ImmutableMap.builder().put((Object)Blocks.field_150364_r, s -> Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA).func_177226_a((IProperty)BlockLog.field_176299_a, s.func_177229_b((IProperty)BlockLog.field_176299_a))).put((Object)Blocks.field_150363_s, s -> Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA).func_177226_a((IProperty)BlockLog.field_176299_a, s.func_177229_b((IProperty)BlockLog.field_176299_a))).put((Object)Blocks.field_150344_f, s -> Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.ACACIA)).put((Object)Blocks.field_150476_ad, s -> Blocks.field_150400_ck.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, s.func_177229_b((IProperty)BlockStairs.field_176309_a))).put((Object)Blocks.field_180407_aO, s -> Blocks.field_180405_aT.func_176223_P()).put((Object)Blocks.field_180413_ao, s -> GlobeAccess.getEquivalent(s, Blocks.field_180410_as.func_176223_P())).build()), (Object)Pair.of((Object)ImmutableList.of((Object)BiomeDictionary.Type.JUNGLE), (Object)ImmutableMap.builder().put((Object)Blocks.field_150364_r, s -> Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLog.field_176299_a, s.func_177229_b((IProperty)BlockLog.field_176299_a))).put((Object)Blocks.field_150363_s, s -> Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLog.field_176299_a, s.func_177229_b((IProperty)BlockLog.field_176299_a))).put((Object)Blocks.field_150344_f, s -> Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.JUNGLE)).put((Object)Blocks.field_150476_ad, s -> Blocks.field_150481_bH.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, s.func_177229_b((IProperty)BlockStairs.field_176309_a))).put((Object)Blocks.field_180407_aO, s -> Blocks.field_180403_aR.func_176223_P()).put((Object)Blocks.field_180413_ao, s -> GlobeAccess.getEquivalent(s, Blocks.field_180411_ar.func_176223_P())).build()), (Object)Pair.of((Object)ImmutableList.of((Object)BiomeDictionary.Type.END), (Object)ImmutableMap.builder().put((Object)Blocks.field_150364_r, s -> Blocks.field_185768_cU.func_176223_P().func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)EnumFacing.Axis.Y)).put((Object)Blocks.field_150363_s, s -> Blocks.field_185768_cU.func_176223_P().func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)EnumFacing.Axis.Y)).put((Object)Blocks.field_150344_f, s -> Blocks.field_185772_cY.func_176223_P()).put((Object)Blocks.field_150476_ad, s -> Blocks.field_185769_cV.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, s.func_177229_b((IProperty)BlockStairs.field_176309_a))).put((Object)Blocks.field_180407_aO, s -> Blocks.field_185771_cX.func_176223_P()).put((Object)Blocks.field_150355_j, s -> Blocks.field_150343_Z.func_176223_P()).put((Object)Blocks.field_150358_i, s -> Blocks.field_150343_Z.func_176223_P()).put((Object)Blocks.field_150349_c, s -> Blocks.field_150377_bs.func_176223_P()).build()), (Object)Pair.of((Object)ImmutableList.of((Object)BiomeDictionary.Type.NETHER), (Object)ImmutableMap.builder().put((Object)Blocks.field_150364_r, s -> Blocks.field_150385_bj.func_176223_P()).put((Object)Blocks.field_150363_s, s -> Blocks.field_150385_bj.func_176223_P()).put((Object)Blocks.field_150344_f, s -> Blocks.field_150425_aM.func_176223_P()).put((Object)Blocks.field_150476_ad, s -> Blocks.field_150387_bl.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, s.func_177229_b((IProperty)BlockStairs.field_176309_a))).put((Object)Blocks.field_180407_aO, s -> Blocks.field_150386_bk.func_176223_P()).put((Object)Blocks.field_180413_ao, s -> Blocks.field_150350_a.func_176223_P()).put((Object)Blocks.field_150355_j, s -> GlobeAccess.getEquivalent(s, Blocks.field_150353_l.func_176223_P())).put((Object)Blocks.field_150358_i, s -> GlobeAccess.getEquivalent(s, Blocks.field_150356_k.func_176223_P())).put((Object)Blocks.field_150349_c, s -> Blocks.field_150424_aL.func_176223_P()).build()), (Object)Pair.of((Object)ImmutableList.of((Object)BiomeDictionary.Type.MUSHROOM), (Object)ImmutableMap.builder().put((Object)Blocks.field_150349_c, s -> Blocks.field_150391_bh.func_176223_P()).build()), (Object)Pair.of((Object)ImmutableList.of((Object)BiomeDictionary.Type.OCEAN), (Object)ImmutableMap.builder().put((Object)Blocks.field_150349_c, s -> Blocks.field_150355_j.func_176223_P()).build()));
        public static List<Pair<List<BiomeDictionary.Type>, Map<Block, Function<IBlockState, IBlockState>>>> TREE_REPLACEMENTS = ImmutableList.of((Object)Pair.of((Object)ImmutableList.of((Object)BiomeDictionary.Type.DRY, (Object)BiomeDictionary.Type.HOT, (Object)BiomeDictionary.Type.SANDY), (Object)ImmutableMap.builder().put((Object)Blocks.field_150364_r, s -> Blocks.field_150434_aF.func_176223_P()).put((Object)Blocks.field_150363_s, s -> Blocks.field_150434_aF.func_176223_P()).put((Object)Blocks.field_150362_t, s -> Blocks.field_150350_a.func_176223_P()).put((Object)Blocks.field_150361_u, s -> Blocks.field_150350_a.func_176223_P()).build()), (Object)Pair.of((Object)ImmutableList.of((Object)BiomeDictionary.Type.CONIFEROUS), (Object)ImmutableMap.builder().put((Object)Blocks.field_150364_r, s -> Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE).func_177226_a((IProperty)BlockLog.field_176299_a, s.func_177229_b((IProperty)BlockLog.field_176299_a))).put((Object)Blocks.field_150363_s, s -> Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE).func_177226_a((IProperty)BlockLog.field_176299_a, s.func_177229_b((IProperty)BlockLog.field_176299_a))).put((Object)Blocks.field_150362_t, s -> Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.SPRUCE)).put((Object)Blocks.field_150361_u, s -> Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.SPRUCE)).build()), (Object)Pair.of((Object)ImmutableList.of((Object)BiomeDictionary.Type.SAVANNA), (Object)ImmutableMap.builder().put((Object)Blocks.field_150364_r, s -> Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA).func_177226_a((IProperty)BlockLog.field_176299_a, s.func_177229_b((IProperty)BlockLog.field_176299_a))).put((Object)Blocks.field_150363_s, s -> Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA).func_177226_a((IProperty)BlockLog.field_176299_a, s.func_177229_b((IProperty)BlockLog.field_176299_a))).put((Object)Blocks.field_150362_t, s -> Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)BlockPlanks.EnumType.ACACIA)).put((Object)Blocks.field_150361_u, s -> Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)BlockPlanks.EnumType.ACACIA)).build()), (Object)Pair.of((Object)ImmutableList.of((Object)BiomeDictionary.Type.JUNGLE), (Object)ImmutableMap.builder().put((Object)Blocks.field_150364_r, s -> Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLog.field_176299_a, s.func_177229_b((IProperty)BlockLog.field_176299_a))).put((Object)Blocks.field_150363_s, s -> Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLog.field_176299_a, s.func_177229_b((IProperty)BlockLog.field_176299_a))).put((Object)Blocks.field_150362_t, s -> Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE)).put((Object)Blocks.field_150361_u, s -> Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE)).build()), (Object)Pair.of((Object)ImmutableList.of((Object)BiomeDictionary.Type.END), (Object)ImmutableMap.builder().put((Object)Blocks.field_150364_r, s -> Blocks.field_185765_cR.func_176223_P()).put((Object)Blocks.field_150363_s, s -> Blocks.field_185765_cR.func_176223_P()).put((Object)Blocks.field_150362_t, s -> Blocks.field_150350_a.func_176223_P()).put((Object)Blocks.field_150361_u, s -> Blocks.field_150350_a.func_176223_P()).build()), (Object)Pair.of((Object)ImmutableList.of((Object)BiomeDictionary.Type.NETHER), (Object)ImmutableMap.builder().put((Object)Blocks.field_150364_r, s -> Blocks.field_150371_ca.func_176223_P()).put((Object)Blocks.field_150363_s, s -> Blocks.field_150371_ca.func_176223_P()).put((Object)Blocks.field_150362_t, s -> Blocks.field_150449_bY.func_176223_P()).put((Object)Blocks.field_150361_u, s -> Blocks.field_150449_bY.func_176223_P()).build()), (Object)Pair.of((Object)ImmutableList.of((Object)BiomeDictionary.Type.MUSHROOM), (Object)ImmutableMap.builder().put((Object)Blocks.field_150364_r, s -> Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.STEM)).put((Object)Blocks.field_150363_s, s -> Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.STEM)).put((Object)Blocks.field_150362_t, s -> Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.ALL_OUTSIDE)).put((Object)Blocks.field_150361_u, s -> Blocks.field_150419_aX.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.ALL_OUTSIDE)).build()));
        private final Biome biome;

        public GlobeAccess(Biome biome) {
            this.biome = biome;
        }

        public static IBlockState getEquivalent(IBlockState from, IBlockState to) {
            for (IProperty property : to.func_177227_a()) {
                if (!from.func_177227_a().contains(property)) continue;
                to = to.func_177226_a(property, from.func_177229_b(property));
            }
            return to;
        }

        public static IBlockState getBuildingReplacement(IBlockState state, Biome biome) {
            BiomeEvent.GetVillageBlockID event = new BiomeEvent.GetVillageBlockID(biome, state);
            MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
            if (event.getResult() == Event.Result.DENY) {
                return event.getReplacement();
            }
            return GlobeAccess.getReplacementFromMap(state, biome, BUILDING_REPLACEMENTS);
        }

        private static IBlockState getReplacementFromMap(IBlockState state, Biome biome, List<Pair<List<BiomeDictionary.Type>, Map<Block, Function<IBlockState, IBlockState>>>> replacementsMap) {
            block0: for (Pair<List<BiomeDictionary.Type>, Map<Block, Function<IBlockState, IBlockState>>> pair : replacementsMap) {
                for (BiomeDictionary.Type type : (List)pair.getKey()) {
                    if (CompatHelper.BiomeHasType(biome, type)) continue;
                    continue block0;
                }
                Function func = (Function)((Map)pair.getRight()).get(state.func_177230_c());
                if (func == null) continue;
                return (IBlockState)func.apply(state);
            }
            return state;
        }

        @Nonnull
        public IBlockState func_180495_p(@Nonnull BlockPos pos) {
            int dx = pos.func_177958_n() - CENTER.func_177958_n();
            int dy = pos.func_177956_o() - CENTER.func_177956_o();
            int dz = pos.func_177952_p() - CENTER.func_177952_p();
            if (dy < 0) {
                return Blocks.field_150357_h.func_176223_P();
            }
            if (dy >= MAX_Y || dx < 0 || dx >= MAX_X || dz < 0 || dz >= MAX_Z) {
                return Blocks.field_150350_a.func_176223_P();
            }
            dx = MAX_X - 1 - dx;
            dz = MAX_Z - 1 - dz;
            String[] datum = globe_data[dy];
            String s = datum[dx];
            char c = s.charAt(dz);
            switch (c) {
                case 'g': {
                    return GlobeAccess.getBuildingReplacement(Blocks.field_150349_c.func_176223_P(), this.biome);
                }
                case 'w': {
                    return GlobeAccess.getBuildingReplacement(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y), this.biome);
                }
                case 'p': {
                    return GlobeAccess.getBuildingReplacement(Blocks.field_150344_f.func_176223_P(), this.biome);
                }
                case 's': {
                    return this.biome.func_76746_c() || this.biome.func_76738_d() ? Blocks.field_150431_aC.func_176223_P() : Blocks.field_150350_a.func_176223_P();
                }
                case 'd': {
                    return GlobeAccess.getBuildingReplacement(Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(false)), this.biome);
                }
                case 'D': {
                    return GlobeAccess.getBuildingReplacement(Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(false)), this.biome);
                }
                case 'W': {
                    return GlobeAccess.getReplacementFromMap(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y), this.biome, TREE_REPLACEMENTS);
                }
                case 'l': {
                    return GlobeAccess.getReplacementFromMap(Blocks.field_150362_t.func_176223_P(), this.biome, TREE_REPLACEMENTS);
                }
            }
            return Blocks.field_150350_a.func_176223_P();
        }

        @Nullable
        public TileEntity func_175625_s(@Nonnull BlockPos pos) {
            return null;
        }

        public int func_175626_b(@Nonnull BlockPos pos, int lightValue) {
            return 0xF000F0;
        }

        public boolean func_175623_d(@Nonnull BlockPos pos) {
            IBlockState state = this.func_180495_p(pos);
            return state.func_177230_c().isAir(state, (IBlockAccess)this, pos);
        }

        @Nonnull
        public Biome func_180494_b(@Nonnull BlockPos pos) {
            return this.biome;
        }

        public int func_175627_a(@Nonnull BlockPos pos, @Nonnull EnumFacing direction) {
            return 0;
        }

        @Nonnull
        public WorldType func_175624_G() {
            return WorldType.field_77137_b;
        }

        public boolean isSideSolid(@Nonnull BlockPos pos, @Nonnull EnumFacing side, boolean _default) {
            IBlockState state = this.func_180495_p(pos);
            return state.isSideSolid((IBlockAccess)this, pos, side);
        }

        static {
            for (int i = 0; i < globe_data.length; ++i) {
                String[] globe_datum = globe_data[i];
                if (globe_datum.length != MAX_X) {
                    throw new RuntimeException("X[" + i + "]");
                }
                for (int j = 0; j < globe_datum.length; ++j) {
                    if (globe_datum[j].length() == MAX_Z) continue;
                    throw new RuntimeException("X[" + i + "],Z[" + j + "] - " + globe_datum[j]);
                }
            }
        }
    }

    public static class BiomeMarker {
        @Nullable
        BlockPos pos;
        @Nullable
        Biome b;
    }
}

