/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.XUItemFlat;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.render.IVertexBuffer;
import com.rwtema.extrautils2.utils.PositionPool;
import com.rwtema.extrautils2.utils.helpers.PlayerHelper;
import com.rwtema.extrautils2.utils.helpers.SideHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public abstract class ItemSelectionWand
extends XUItemFlat {
    static double[][][] edgeLines;
    public final String texture;
    public final String name;
    public final int range;
    public final float[] col;

    public ItemSelectionWand(String texture, String name, float[] col, int range) {
        this.texture = texture;
        this.name = name;
        this.col = col;
        this.range = range;
        this.func_77625_d(1);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public int getMaxMetadata() {
        return 0;
    }

    public List<BlockPos> getPotentialBlocks(EntityPlayer player, World world, BlockPos pos, EnumFacing side, int maxBlocks, ItemStack pickBlock1, IBlockState blockState, Block block) {
        BlockPos p;
        EnumFacing horizontalFacing;
        if (pos.func_177956_o() >= 255 || pos.func_177956_o() < 0 || world.func_175623_d(pos) || !world.field_72995_K && !PlayerHelper.isPlayerReal(player)) {
            return ImmutableList.of();
        }
        if (StackHelper.isNull(pickBlock1)) {
            return ImmutableList.of();
        }
        if (this.initialCheck(world, pos, side, pickBlock1, blockState)) {
            return ImmutableList.of();
        }
        int data = block.func_180651_a(blockState);
        boolean grassBlock = block == Blocks.field_150349_c || block == Blocks.field_150391_bh;
        int numBlocks = this.getNumBlocks(player, maxBlocks, pickBlock1, grassBlock);
        if (numBlocks == 0) {
            return ImmutableList.of();
        }
        EnumSet<EnumFacing> dirs2Search = EnumSet.allOf(EnumFacing.class);
        dirs2Search.remove(side);
        dirs2Search.remove(side.func_176734_d());
        boolean sneaking = player.func_70093_af();
        if (ExtraUtils2.proxy.isAltSneaking(player)) {
            if (side.func_96559_d() != 0) {
                horizontalFacing = player.func_174811_aO().func_176746_e();
                dirs2Search.remove(horizontalFacing);
                dirs2Search.remove(horizontalFacing.func_176734_d());
            } else {
                dirs2Search.remove(EnumFacing.WEST);
                dirs2Search.remove(EnumFacing.EAST);
                dirs2Search.remove(EnumFacing.SOUTH);
                dirs2Search.remove(EnumFacing.NORTH);
            }
        } else if (sneaking) {
            if (side.func_96559_d() != 0) {
                horizontalFacing = player.func_174811_aO();
                dirs2Search.remove(horizontalFacing);
                dirs2Search.remove(horizontalFacing.func_176734_d());
            } else {
                dirs2Search.remove(EnumFacing.DOWN);
                dirs2Search.remove(EnumFacing.UP);
            }
        }
        if (dirs2Search.isEmpty()) {
            return ImmutableList.of();
        }
        LinkedHashSet<BlockPos> vecs = new LinkedHashSet<BlockPos>();
        for (EnumFacing enumFacing : dirs2Search) {
            vecs.add(BlockPos.field_177992_a.func_177972_a(enumFacing));
        }
        for (EnumFacing enumFacing : dirs2Search) {
            for (EnumFacing otherEnumFacing : dirs2Search) {
                BlockPos offset = BlockPos.field_177992_a.func_177972_a(enumFacing).func_177972_a(otherEnumFacing);
                if (Math.abs(offset.func_177958_n()) >= 2 || Math.abs(offset.func_177956_o()) >= 2 || Math.abs(offset.func_177952_p()) >= 2) continue;
                vecs.add(offset);
            }
        }
        HashSet<IBlockState> states = new HashSet<IBlockState>();
        states.add(blockState);
        for (IBlockState otherState : block.func_176194_O().func_177619_a()) {
            if (block.func_180651_a(otherState) != data) continue;
            states.add(otherState);
        }
        if (grassBlock) {
            states.addAll((Collection<IBlockState>)Blocks.field_150346_d.func_176194_O().func_177619_a());
        } else if (block == Blocks.field_150346_d) {
            states.addAll((Collection<IBlockState>)Blocks.field_150349_c.func_176194_O().func_177619_a());
            states.addAll((Collection<IBlockState>)Blocks.field_150391_bh.func_176194_O().func_177619_a());
        }
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>(numBlocks);
        queue.add(pos);
        checkedBlocks.add(pos);
        PositionPool pool = new PositionPool();
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        while ((p = (BlockPos)queue.poll()) != null && blocks.size() < numBlocks) {
            if (!states.contains(world.func_180495_p(p)) || !this.checkAndAddBlocks(player, world, side, pickBlock1, block, blockState, pool, p, blocks)) continue;
            block5: for (Vec3i vec3i : vecs) {
                BlockPos p2 = pool.add(p, vec3i);
                if (checkedBlocks.contains(p2)) continue;
                checkedBlocks.add(p2);
                int d = Math.max(Math.max(Math.abs(p2.func_177958_n() - pos.func_177958_n()), Math.abs(p2.func_177956_o() - pos.func_177956_o())), Math.abs(p2.func_177952_p() - pos.func_177952_p()));
                ListIterator<BlockPos> listIterator = queue.listIterator();
                while (listIterator.hasNext()) {
                    BlockPos next = (BlockPos)listIterator.next();
                    int d2 = Math.max(Math.max(Math.abs(next.func_177958_n() - pos.func_177958_n()), Math.abs(next.func_177956_o() - pos.func_177956_o())), Math.abs(next.func_177952_p() - pos.func_177952_p()));
                    if (d2 < d) continue;
                    listIterator.add(p2);
                    continue block5;
                }
                queue.add(p2);
            }
        }
        return blocks;
    }

    protected abstract boolean initialCheck(World var1, BlockPos var2, EnumFacing var3, ItemStack var4, IBlockState var5);

    protected abstract int getNumBlocks(EntityPlayer var1, int var2, ItemStack var3, boolean var4);

    protected abstract boolean checkAndAddBlocks(EntityPlayer var1, World var2, EnumFacing var3, ItemStack var4, Block var5, IBlockState var6, PositionPool var7, BlockPos var8, List<BlockPos> var9);

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRenderLayers(@Nullable ItemStack itemStack) {
        return 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderLayerIn3D(ItemStack stack, int renderPass) {
        return renderPass == 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        Textures.register(this.texture + "0");
        Textures.register(this.texture + "1");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTexture(@Nullable ItemStack itemStack, int renderPass) {
        return this.texture + renderPass;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderAsTool() {
        return true;
    }

    public ItemStack getStack(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        Item item = Item.func_150898_a((Block)block);
        if (item == StackHelper.nullItem()) {
            return StackHelper.empty();
        }
        return new ItemStack(item, 1, block.func_180651_a(state));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawSelection(DrawBlockHighlightEvent event) {
        ItemStack currentItem = event.getPlayer().func_184614_ca();
        RayTraceResult target = event.getTarget();
        if (StackHelper.isNull(currentItem) || currentItem.func_77973_b() != this || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        event.setCanceled(true);
        BlockPos blockPos = target.func_178782_a();
        EntityPlayer player = event.getPlayer();
        IBlockState blockState = player.field_70170_p.func_180495_p(blockPos);
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150350_a) {
            return;
        }
        ItemStack pickBlock = this.getStack(player.field_70170_p, blockPos);
        List<BlockPos> potentialBlocks = this.getPotentialBlocks(player, player.field_70170_p, blockPos, target.field_178784_b, this.range, pickBlock, blockState, block);
        if (potentialBlocks.isEmpty()) {
            return;
        }
        LinkedHashSet<BlockPos> posSet = new LinkedHashSet<BlockPos>(potentialBlocks);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        Tessellator tessellator = Tessellator.func_178181_a();
        IVertexBuffer worldrenderer = IVertexBuffer.getVertexBuffer(tessellator);
        float scale = 0.52f;
        float partialTicks = event.getPartialTicks();
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        PositionPool pool = new PositionPool();
        int prevType = -1;
        EnumFacing[][] edges1 = SideHelper.edges;
        for (int i = 0; i < edges1.length; ++i) {
            EnumFacing[] edges = edges1[i];
            double[][] line = edgeLines[i];
            for (BlockPos pos : posSet) {
                int type;
                BlockPos o1 = pool.offset(pos, edges[0]);
                boolean a = posSet.contains(o1);
                boolean b = posSet.contains(pool.offset(pos, edges[1]));
                if (a && b) {
                    if (posSet.contains(pool.offset(o1, edges[1]))) continue;
                    type = 1;
                } else {
                    type = !a && !b ? 1 : 2;
                }
                if (type != prevType) {
                    if (prevType != -1) {
                        tessellator.func_78381_a();
                    }
                    worldrenderer.begin(1, DefaultVertexFormats.field_181705_e);
                    if (type == 1) {
                        GlStateManager.func_179131_c((float)this.col[0], (float)this.col[1], (float)this.col[2], (float)0.8f);
                        GL11.glLineWidth((float)4.0f);
                    } else {
                        GlStateManager.func_179131_c((float)this.col[0], (float)this.col[1], (float)this.col[2], (float)0.1f);
                        GL11.glLineWidth((float)2.0f);
                    }
                    prevType = type;
                }
                for (double[] vec : line) {
                    worldrenderer.pos((double)pos.func_177958_n() - d0 + vec[0], (double)pos.func_177956_o() - d1 + vec[1], (double)pos.func_177952_p() - d2 + vec[2]).endVertex();
                }
            }
        }
        if (prevType != -1) {
            tessellator.func_78381_a();
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    static {
        float offset = 0.50097656f;
        edgeLines = new double[12][2][3];
        for (int i = 0; i < SideHelper.edges.length; ++i) {
            EnumFacing[] edge = SideHelper.edges[i];
            EnumFacing a = edge[0];
            EnumFacing b = edge[1];
            EnumFacing c = edge[2];
            ItemSelectionWand.edgeLines[i] = new double[][]{{0.5f + (float)(a.func_82601_c() + b.func_82601_c() + c.func_82601_c()) * offset, 0.5f + (float)(a.func_96559_d() + b.func_96559_d() + c.func_96559_d()) * offset, 0.5f + (float)(a.func_82599_e() + b.func_82599_e() + c.func_82599_e()) * offset}, {0.5f + (float)(a.func_82601_c() + b.func_82601_c() - c.func_82601_c()) * offset, 0.5f + (float)(a.func_96559_d() + b.func_96559_d() - c.func_96559_d()) * offset, 0.5f + (float)(a.func_82599_e() + b.func_82599_e() - c.func_82599_e()) * offset}};
        }
    }
}

