/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui.backend;

import com.google.common.collect.ImmutableList;
import com.mojang.realmsclient.gui.ChatFormatting;
import com.rwtema.extrautils2.gui.backend.WidgetProgressArrowNetworkBase;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.text.NumberFormat;
import java.util.List;

public abstract class WidgetProgressArrowTimer
extends WidgetProgressArrowNetworkBase {
    float clientTime;
    float clientMaxTime;

    public WidgetProgressArrowTimer(int x, int y) {
        super(x, y);
    }

    protected abstract float getTime();

    protected abstract float getMaxTime();

    @Override
    protected byte readProgressData(XUPacketBuffer packet) {
        this.clientTime = packet.readFloat();
        this.clientMaxTime = packet.readFloat();
        if (this.clientMaxTime < 0.0f) {
            return -1;
        }
        if (this.clientTime == 0.0f) {
            return 0;
        }
        return WidgetProgressArrowTimer.getAdjustedWidth(this.clientTime / this.clientMaxTime);
    }

    @Override
    protected void writeProgressData(XUPacketBuffer packet) {
        packet.writeFloat(this.getTime());
        packet.writeFloat(this.getMaxTime());
    }

    @Override
    public List<String> getToolTip() {
        if (this.curWidth == -1) {
            return this.getErrorMessage();
        }
        int clientMaxTime = (int)this.clientMaxTime;
        if (clientMaxTime == 0) {
            return null;
        }
        return ImmutableList.of((Object)String.format("%s / %s ", StringHelper.formatDurationSeconds((int)this.clientTime, true), StringHelper.formatDurationSeconds(clientMaxTime, false)), (Object)(ChatFormatting.GRAY + NumberFormat.getPercentInstance().format(this.clientTime / this.clientMaxTime) + ChatFormatting.RESET));
    }
}

