/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.compatibility;

import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class NBTSerializableRegisteredValue<V extends IForgeRegistryEntry<V>>
implements INBTSerializable<NBTTagString> {
    private static final ResourceLocation emptyNeverToBeFound = new ResourceLocation("EmptyNeverToBeFound");
    final IForgeRegistry<V> registry;
    public V value;

    public NBTSerializableRegisteredValue(IForgeRegistry<V> registry) {
        this.registry = registry;
        this.value = registry.getValue(emptyNeverToBeFound);
    }

    public NBTTagString serializeNBT() {
        return NBTSerializable.NBTResourceLocationSerializable.serialize(this.registry.getKey(this.value));
    }

    public void deserializeNBT(NBTTagString nbt) {
        ResourceLocation location = NBTSerializable.NBTResourceLocationSerializable.deserialize(nbt);
        this.value = location == null ? this.registry.getValue(emptyNeverToBeFound) : this.registry.getValue(location);
    }
}

