/*
 * Decompiled with CFR 0.152.
 */
package org.softc.armoryexpansion.dynamic_systems.dynamic_materials;

import c4.conarm.lib.materials.CoreMaterialStats;
import c4.conarm.lib.materials.PlatesMaterialStats;
import c4.conarm.lib.materials.TrimMaterialStats;
import org.softc.armoryexpansion.ArmoryExpansion;
import org.softc.armoryexpansion.dynamic_systems.dynamic_materials.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.tools.TinkerMaterials;

public class MaterialRegistration {
    private static void registerCoreMaterialStat(Material material) {
        HeadMaterialStats materialHead = (HeadMaterialStats)material.getStats("head");
        HeadMaterialStats ironHead = (HeadMaterialStats)TinkerMaterials.iron.getStats("head");
        CoreMaterialStats ironCore = (CoreMaterialStats)TinkerMaterials.iron.getStats("core");
        TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new CoreMaterialStats(ironCore.durability * (float)materialHead.durability / (float)ironHead.durability, 1.5f * ironCore.defense * materialHead.attack / ironHead.attack));
    }

    private static void registerPlatesMaterialStat(Material material) {
        HandleMaterialStats materialHandle = (HandleMaterialStats)material.getStats("handle");
        HandleMaterialStats ironHandle = (HandleMaterialStats)TinkerMaterials.iron.getStats("handle");
        PlatesMaterialStats ironPlates = (PlatesMaterialStats)TinkerMaterials.iron.getStats("plates");
        float ironPlatesToughness = ironPlates.toughness > 0.0f ? ironPlates.toughness : 1.0f;
        TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new PlatesMaterialStats(materialHandle.modifier, ironPlates.durability * (float)materialHandle.durability / (float)ironHandle.durability, 3.0f * ironPlatesToughness * (float)materialHandle.durability / (float)ironHandle.durability));
    }

    private static void registerTrimMaterialStat(Material material) {
        ExtraMaterialStats materialExtra = (ExtraMaterialStats)material.getStats("extra");
        ExtraMaterialStats ironExtra = (ExtraMaterialStats)TinkerMaterials.iron.getStats("extra");
        TrimMaterialStats ironTrim = (TrimMaterialStats)TinkerMaterials.iron.getStats("trim");
        TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new TrimMaterialStats(2.0f * ironTrim.extraDurability * (float)materialExtra.extraDurability / (float)ironExtra.extraDurability));
    }

    public static void registerFromToolMaterialStat() {
        for (int i = 0; i < Config.propertiesMaterials.size(); ++i) {
            Material material = TinkerRegistry.getMaterial((String)Config.propertiesMaterials.get(i).getName().replaceAll("enable_", ""));
            if (!Config.propertiesMaterials.get(i).getBoolean() || material == null) continue;
            ArmoryExpansion.logger.info("Registering parts for " + material.getLocalizedName());
            if (Config.propertiesCore.get(i) != null && Config.propertiesCore.get(i).getBoolean() && !material.hasStats("core")) {
                MaterialRegistration.registerCoreMaterialStat(material);
            }
            if (Config.propertiesPlates.get(i) != null && Config.propertiesPlates.get(i).getBoolean() && !material.hasStats("plates")) {
                MaterialRegistration.registerPlatesMaterialStat(material);
            }
            if (Config.propertiesTrim.get(i) == null || !Config.propertiesTrim.get(i).getBoolean() || material.hasStats("trim")) continue;
            MaterialRegistration.registerTrimMaterialStat(material);
        }
    }
}

