/*
 * Decompiled with CFR 0.152.
 */
package nihiltres.engineersdoors.common.module;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.world.VillageEngineersHouse;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import nihiltres.engineersdoors.EngineersDoors;
import nihiltres.engineersdoors.common.block.BlockEDDoor;
import nihiltres.engineersdoors.common.item.ItemEDDoor;
import nihiltres.engineersdoors.common.module.Module;
import nihiltres.engineersdoors.common.world.FancyDoorVillageEngineersHouse;

public class Doors
implements Module {
    public static final BlockEDDoor BLOCK_DOOR_CONCRETE = new BlockEDDoor(Material.field_151576_e, "door_concrete", "doorConcrete", true).setBlockProperties(2.5f, 10.0f, "pickaxe", 1);
    public static final BlockEDDoor BLOCK_DOOR_CONCRETE_ORNATE = new BlockEDDoor("door_concrete_ornate", BLOCK_DOOR_CONCRETE).setTranslucent();
    public static final BlockEDDoor BLOCK_DOOR_CONCRETE_REINFORCED = new BlockEDDoor("door_concrete_reinforced", BLOCK_DOOR_CONCRETE);
    public static final BlockEDDoor BLOCK_DOOR_STEEL = new BlockEDDoor(Material.field_151573_f, "door_steel", "doorSteel", false).setBlockProperties(3.0f, 15.0f, "pickaxe", 2);
    public static final BlockEDDoor BLOCK_DOOR_STEEL_ORNATE = new BlockEDDoor("door_steel_ornate", BLOCK_DOOR_STEEL);
    public static final BlockEDDoor BLOCK_DOOR_STEEL_REINFORCED = new BlockEDDoor("door_steel_reinforced", BLOCK_DOOR_STEEL);
    public static final BlockEDDoor BLOCK_DOOR_TREATED = new BlockEDDoor(Material.field_151575_d, "door_treated", "doorTreatedWood", true).setBlockProperties(2.0f, 5.0f, "axe", 0);
    public static final BlockEDDoor BLOCK_DOOR_TREATED_ORNATE = new BlockEDDoor("door_treated_ornate", BLOCK_DOOR_TREATED);
    public static final BlockEDDoor BLOCK_DOOR_TREATED_REINFORCED = new BlockEDDoor("door_treated_reinforced", BLOCK_DOOR_TREATED);
    public static final ItemEDDoor ITEM_DOOR_CONCRETE = Doors.BLOCK_DOOR_CONCRETE.item;
    public static final ItemEDDoor ITEM_DOOR_CONCRETE_ORNATE = Doors.BLOCK_DOOR_CONCRETE_ORNATE.item.setVariantTooltip("ornate");
    public static final ItemEDDoor ITEM_DOOR_CONCRETE_REINFORCED = Doors.BLOCK_DOOR_CONCRETE_REINFORCED.item.setVariantTooltip("reinforced");
    public static final ItemEDDoor ITEM_DOOR_STEEL = Doors.BLOCK_DOOR_STEEL.item;
    public static final ItemEDDoor ITEM_DOOR_STEEL_ORNATE = Doors.BLOCK_DOOR_STEEL_ORNATE.item.setVariantTooltip("ornate");
    public static final ItemEDDoor ITEM_DOOR_STEEL_REINFORCED = Doors.BLOCK_DOOR_STEEL_REINFORCED.item.setVariantTooltip("reinforced");
    public static final ItemEDDoor ITEM_DOOR_TREATED = Doors.BLOCK_DOOR_TREATED.item;
    public static final ItemEDDoor ITEM_DOOR_TREATED_ORNATE = Doors.BLOCK_DOOR_TREATED_ORNATE.item.setVariantTooltip("ornate");
    public static final ItemEDDoor ITEM_DOOR_TREATED_REINFORCED = Doors.BLOCK_DOOR_TREATED_REINFORCED.item.setVariantTooltip("reinforced");
    private static final String name = "doors";
    private static final Block[] blocks = new Block[]{BLOCK_DOOR_CONCRETE, BLOCK_DOOR_CONCRETE_ORNATE, BLOCK_DOOR_CONCRETE_REINFORCED, BLOCK_DOOR_STEEL, BLOCK_DOOR_STEEL_ORNATE, BLOCK_DOOR_STEEL_REINFORCED, BLOCK_DOOR_TREATED, BLOCK_DOOR_TREATED_ORNATE, BLOCK_DOOR_TREATED_REINFORCED};
    private static final Item[] items = new Item[]{ITEM_DOOR_CONCRETE, ITEM_DOOR_CONCRETE_ORNATE, ITEM_DOOR_CONCRETE_REINFORCED, ITEM_DOOR_STEEL, ITEM_DOOR_STEEL_ORNATE, ITEM_DOOR_STEEL_REINFORCED, ITEM_DOOR_TREATED, ITEM_DOOR_TREATED_ORNATE, ITEM_DOOR_TREATED_REINFORCED};
    private static final SoundEvent[] soundEvents = new SoundEvent[]{BlockEDDoor.STONE_DOOR_OPEN, BlockEDDoor.STONE_DOOR_CLOSE};

    @Override
    public Block[] getBlocks() {
        return blocks;
    }

    @Override
    public Item[] getItems() {
        return items;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public SoundEvent[] getSoundEvents() {
        return soundEvents;
    }

    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        if (Config.IEConfig.villagerHouse) {
            EngineersDoors.log("Overwriting door generation in IE village engineer's house (IEVEH)");
            Class<VillageEngineersHouse> vehClass = VillageEngineersHouse.class;
            boolean fieldAccess = false;
            try {
                VillagerRegistry villageRegistry = VillagerRegistry.instance();
                Field vchField = VillagerRegistry.class.getDeclaredField("villageCreationHandlers");
                fieldAccess = vchField.isAccessible();
                vchField.setAccessible(true);
                Map registryMap = (Map)vchField.get(villageRegistry);
                registryMap.remove(vehClass);
                vchField.setAccessible(fieldAccess);
                EngineersDoors.log("Demapped base IEVEH in VillagerRegistry");
                villageRegistry.registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new FancyDoorVillageEngineersHouse.FancyDoorVillageManager());
                EngineersDoors.log("Registered modified IEVEH in VillagerRegistry");
                Field[] fields = MapGenStructureIO.class.getDeclaredFields();
                String ieId = "immersiveengineering:EngineersHouse";
                Class<VillageEngineersHouse> ieClass = VillageEngineersHouse.class;
                int demaps = 0;
                for (Field f : fields) {
                    if (f.getType().isAssignableFrom(Map.class)) {
                        fieldAccess = f.isAccessible();
                        f.setAccessible(true);
                        Map map = (Map)f.get(0);
                        try {
                            if (map.containsKey(ieId)) {
                                map.remove(ieId);
                                ++demaps;
                                EngineersDoors.log("Demapped base IEVEH from NtC map in MapGenStructureIO");
                            }
                        }
                        catch (ClassCastException classCastException) {
                            // empty catch block
                        }
                        try {
                            if (map.containsKey(ieClass)) {
                                map.remove(ieClass);
                                ++demaps;
                                EngineersDoors.log("Demapped base IEVEH from CtN map in MapGenStructureIO");
                            }
                        }
                        catch (ClassCastException classCastException) {
                            // empty catch block
                        }
                        f.setAccessible(fieldAccess);
                    }
                    if (demaps >= 2) break;
                }
                if (demaps < 2) {
                    EngineersDoors.debug("Failed to fully remove base IEVEH MapGenStructureIO mappings!");
                }
                MapGenStructureIO.func_143031_a(FancyDoorVillageEngineersHouse.class, (String)ieId);
                EngineersDoors.log("Registered modified IEVEH in MapGenStructureIO");
            }
            catch (IllegalAccessException e) {
                EngineersDoors.debug(e);
            }
            catch (NoSuchFieldException e) {
                EngineersDoors.debug(e);
            }
        }
    }

    @Override
    public void postInit() {
        BlockEDDoor.checkForQuarkDoubleDoors();
    }
}

