/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class Scan {
    private byte[] rledata;
    private List<IBlockState> materialPalette = new ArrayList<IBlockState>();
    private BlockPos dataDim;
    private BlockPos dataOffset = new BlockPos(0, 0, 0);
    private int dirtyCounter = 0;
    public int dirtyRequestTimeout = 0;
    public static final byte[] EMPTY = new byte[0];

    public byte[] getRledata() {
        if (this.rledata == null) {
            return EMPTY;
        }
        return this.rledata;
    }

    public byte[] getDataInt() {
        return this.rledata;
    }

    public void setData(byte[] data, List<IBlockState> materialPalette, BlockPos dim, BlockPos offset) {
        this.rledata = data;
        this.materialPalette = materialPalette;
        this.dataDim = dim;
        this.dataOffset = offset;
        ++this.dirtyCounter;
    }

    public void setDirtyCounter(int dirtyCounter) {
        this.dirtyCounter = dirtyCounter;
    }

    public int getDirtyCounter() {
        return this.dirtyCounter;
    }

    public List<IBlockState> getMaterialPalette() {
        return this.materialPalette;
    }

    public BlockPos getDataDim() {
        return this.dataDim;
    }

    public BlockPos getDataOffset() {
        return this.dataOffset;
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("dirty", this.dirtyCounter);
    }

    public void writeToNBTExternal(NBTTagCompound tagCompound) {
        tagCompound.func_74773_a("data", this.rledata == null ? new byte[]{} : this.rledata);
        NBTTagList pal = new NBTTagList();
        for (IBlockState state : this.materialPalette) {
            NBTTagCompound tc = new NBTTagCompound();
            Block block = state.func_177230_c();
            if (block == null || block.getRegistryName() == null) {
                tc.func_74778_a("r", Blocks.field_150348_b.getRegistryName().toString());
                tc.func_74768_a("m", 0);
            } else {
                tc.func_74778_a("r", block.getRegistryName().toString());
                tc.func_74768_a("m", block.func_176201_c(state));
            }
            pal.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("scanpal", (NBTBase)pal);
        if (this.dataDim != null) {
            tagCompound.func_74768_a("scandimx", this.dataDim.func_177958_n());
            tagCompound.func_74768_a("scandimy", this.dataDim.func_177956_o());
            tagCompound.func_74768_a("scandimz", this.dataDim.func_177952_p());
        }
        if (this.dataOffset != null) {
            tagCompound.func_74768_a("scanoffx", this.dataOffset.func_177958_n());
            tagCompound.func_74768_a("scanoffy", this.dataOffset.func_177956_o());
            tagCompound.func_74768_a("scanoffz", this.dataOffset.func_177952_p());
        }
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.dirtyCounter = tagCompound.func_74762_e("dirty");
    }

    public void readFromNBTExternal(NBTTagCompound tagCompound) {
        NBTTagList list = tagCompound.func_150295_c("scanpal", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tc = list.func_150305_b(i);
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tc.func_74779_i("r")));
            if (block == null) {
                block = Blocks.field_150348_b;
            }
            this.materialPalette.add(block.func_176203_a(tc.func_74762_e("m")));
        }
        this.rledata = tagCompound.func_74770_j("data");
        this.dataDim = new BlockPos(tagCompound.func_74762_e("scandimx"), tagCompound.func_74762_e("scandimy"), tagCompound.func_74762_e("scandimz"));
        this.dataOffset = new BlockPos(tagCompound.func_74762_e("scanoffx"), tagCompound.func_74762_e("scanoffy"), tagCompound.func_74762_e("scanoffz"));
    }
}

