/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.jei;

import io.netty.buffer.ByteBuf;
import java.util.List;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftools.blocks.storage.ModularStorageItemContainer;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.blocks.storage.RemoteStorageItemContainer;
import mcjty.rftools.blocks.storagemonitor.StorageScannerContainer;
import mcjty.rftools.jei.JEIRecipeAcceptor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSendRecipe
implements IMessage {
    private ItemStackList stacks;
    private BlockPos pos;

    public void fromBytes(ByteBuf buf) {
        int l = buf.readInt();
        this.stacks = ItemStackList.create((int)l);
        for (int i = 0; i < l; ++i) {
            if (buf.readBoolean()) {
                this.stacks.set(i, (Object)NetworkTools.readItemStack((ByteBuf)buf));
                continue;
            }
            this.stacks.set(i, (Object)ItemStack.field_190927_a);
        }
        this.pos = buf.readBoolean() ? NetworkTools.readPos((ByteBuf)buf) : null;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.stacks.size());
        for (ItemStack stack : this.stacks) {
            if (!stack.func_190926_b()) {
                buf.writeBoolean(true);
                NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)stack);
                continue;
            }
            buf.writeBoolean(false);
        }
        if (this.pos != null) {
            buf.writeBoolean(true);
            NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        } else {
            buf.writeBoolean(false);
        }
    }

    public PacketSendRecipe() {
    }

    public PacketSendRecipe(ItemStackList stacks, BlockPos pos) {
        this.stacks = stacks;
        this.pos = pos;
    }

    public static class Handler
    implements IMessageHandler<PacketSendRecipe, IMessage> {
        public IMessage onMessage(PacketSendRecipe message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketSendRecipe message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = player.func_130014_f_();
            if (message.pos == null) {
                ItemStack mainhand = player.func_184614_ca();
                if (!mainhand.func_190926_b() && mainhand.func_77973_b() == ModularStorageSetup.storageModuleTabletItem) {
                    if (player.field_71070_bA instanceof ModularStorageItemContainer) {
                        ModularStorageItemContainer storageItemContainer = (ModularStorageItemContainer)player.field_71070_bA;
                        storageItemContainer.getJEIRecipeAcceptor().setGridContents((List<ItemStack>)message.stacks);
                    } else if (player.field_71070_bA instanceof RemoteStorageItemContainer) {
                        RemoteStorageItemContainer storageItemContainer = (RemoteStorageItemContainer)player.field_71070_bA;
                        storageItemContainer.getJEIRecipeAcceptor().setGridContents((List<ItemStack>)message.stacks);
                    } else if (player.field_71070_bA instanceof StorageScannerContainer) {
                        StorageScannerContainer storageItemContainer = (StorageScannerContainer)player.field_71070_bA;
                        storageItemContainer.getStorageScannerTileEntity().setGridContents((List<ItemStack>)message.stacks);
                    }
                }
            } else {
                TileEntity te = world.func_175625_s(message.pos);
                if (te instanceof JEIRecipeAcceptor) {
                    JEIRecipeAcceptor acceptor = (JEIRecipeAcceptor)te;
                    acceptor.setGridContents((List<ItemStack>)message.stacks);
                }
            }
        }
    }
}

