/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.screenmodules;

import java.util.List;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.api.screens.IModuleGuiBuilder;
import mcjty.rftools.api.screens.IModuleProvider;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.modules.EnergyBarScreenModule;
import mcjty.rftools.blocks.screens.modulesclient.EnergyBarClientScreenModule;
import mcjty.rftools.items.GenericRFToolsItem;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnergyModuleItem
extends GenericRFToolsItem
implements IModuleProvider,
INBTPreservingIngredient {
    public EnergyModuleItem() {
        super("energy_module");
        this.func_77625_d(1);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public Class<EnergyBarScreenModule> getServerScreenModule() {
        return EnergyBarScreenModule.class;
    }

    public Class<EnergyBarClientScreenModule> getClientScreenModule() {
        return EnergyBarClientScreenModule.class;
    }

    @Override
    public String getName() {
        return "RF";
    }

    @Override
    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.label("Label:").text("text", "Label text").color("color", "Color for the label").nl().label("RF+:").color("rfcolor", "Color for the RF text").label("RF-:").color("rfcolor_neg", "Color for the negative", "RF/tick ratio").nl().toggleNegative("hidebar", "Bar", "Toggle visibility of the", "energy bar").mode("RF").format("format").nl().choices("align", "Label alignment", "Left", "Center", "Right").nl().label("Block:").block("monitor").nl();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        list.add(TextFormatting.GREEN + "Uses " + ScreenConfiguration.ENERGY_RFPERTICK + " RF/tick");
        boolean hasTarget = false;
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add(TextFormatting.YELLOW + "Label: " + tagCompound.func_74779_i("text"));
            if (tagCompound.func_74764_b("monitorx")) {
                int monitorx = tagCompound.func_74762_e("monitorx");
                int monitory = tagCompound.func_74762_e("monitory");
                int monitorz = tagCompound.func_74762_e("monitorz");
                String monitorname = tagCompound.func_74779_i("monitorname");
                list.add(TextFormatting.YELLOW + "Monitoring: " + monitorname + " (at " + monitorx + "," + monitory + "," + monitorz + ")");
                hasTarget = true;
            }
        }
        if (!hasTarget) {
            list.add(TextFormatting.YELLOW + "Sneak right-click on a machine to set the");
            list.add(TextFormatting.YELLOW + "target for this energy module");
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (EnergyTools.isEnergyTE((TileEntity)te, (EnumFacing)facing)) {
            tagCompound.func_74768_a("monitordim", world.field_73011_w.getDimension());
            tagCompound.func_74768_a("monitorx", pos.func_177958_n());
            tagCompound.func_74768_a("monitory", pos.func_177956_o());
            tagCompound.func_74768_a("monitorz", pos.func_177952_p());
            tagCompound.func_74768_a("monitorside", facing.func_176745_a());
            IBlockState state = player.func_130014_f_().func_180495_p(pos);
            Block block = state.func_177230_c();
            String name = "<invalid>";
            if (block != null && !block.isAir(state, (IBlockAccess)world, pos)) {
                name = BlockTools.getReadableName((World)world, (BlockPos)pos);
            }
            tagCompound.func_74778_a("monitorname", name);
            if (world.field_72995_K) {
                Logging.message((EntityPlayer)player, (String)("Energy module is set to block '" + name + "'"));
            }
        } else {
            tagCompound.func_82580_o("monitordim");
            tagCompound.func_82580_o("monitorx");
            tagCompound.func_82580_o("monitory");
            tagCompound.func_82580_o("monitorz");
            tagCompound.func_82580_o("monitorside");
            tagCompound.func_82580_o("monitorname");
            if (world.field_72995_K) {
                Logging.message((EntityPlayer)player, (String)"Energy module is cleared");
            }
        }
        stack.func_77982_d(tagCompound);
        return EnumActionResult.SUCCESS;
    }
}

