/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.craftinggrid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mcjty.lib.container.InventoryHelper;
import mcjty.rftools.craftinggrid.IItemKey;
import mcjty.rftools.craftinggrid.IItemSource;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class InventoriesItemSource
implements IItemSource {
    private List<Pair<IInventory, Integer>> inventories = new ArrayList<Pair<IInventory, Integer>>();

    public InventoriesItemSource add(IInventory inventory, int offset) {
        this.inventories.add((Pair<IInventory, Integer>)Pair.of((Object)inventory, (Object)offset));
        return this;
    }

    @Override
    public Iterable<Pair<IItemKey, ItemStack>> getItems() {
        return () -> new Iterator<Pair<IItemKey, ItemStack>>(){
            private int inventoryIndex = 0;
            private int slotIndex = 0;

            private boolean firstValidItem() {
                while (this.inventoryIndex < InventoriesItemSource.this.inventories.size()) {
                    IInventory inventory = (IInventory)((Pair)InventoriesItemSource.this.inventories.get(this.inventoryIndex)).getLeft();
                    int offset = (Integer)((Pair)InventoriesItemSource.this.inventories.get(this.inventoryIndex)).getRight();
                    if (this.slotIndex < offset) {
                        this.slotIndex = offset;
                    }
                    if (this.slotIndex < inventory.func_70302_i_()) {
                        return true;
                    }
                    this.slotIndex = 0;
                    ++this.inventoryIndex;
                }
                return false;
            }

            @Override
            public boolean hasNext() {
                return this.firstValidItem();
            }

            @Override
            public Pair<IItemKey, ItemStack> next() {
                IInventory inventory = (IInventory)((Pair)InventoriesItemSource.this.inventories.get(this.inventoryIndex)).getLeft();
                ItemKey key = new ItemKey(inventory, this.slotIndex);
                Pair result = Pair.of((Object)key, (Object)inventory.func_70301_a(this.slotIndex));
                ++this.slotIndex;
                return result;
            }
        };
    }

    @Override
    public ItemStack decrStackSize(IItemKey key, int amount) {
        ItemKey realKey = (ItemKey)key;
        ItemStack stack = realKey.getInventory().func_70301_a(realKey.getSlot());
        ItemStack result = stack.func_77979_a(amount);
        if (stack.func_190926_b()) {
            realKey.getInventory().func_70299_a(realKey.getSlot(), ItemStack.field_190927_a);
        }
        return result;
    }

    @Override
    public boolean insertStack(IItemKey key, ItemStack stack) {
        ItemKey realKey = (ItemKey)key;
        IInventory inventory = realKey.getInventory();
        ItemStack origStack = inventory.func_70304_b(realKey.getSlot());
        if (!origStack.func_190926_b()) {
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)origStack, (ItemStack)stack)) {
                if (stack.func_190916_E() + origStack.func_190916_E() > stack.func_77976_d()) {
                    return false;
                }
                stack.func_190917_f(origStack.func_190916_E());
            } else {
                return false;
            }
        }
        inventory.func_70299_a(realKey.getSlot(), stack);
        return true;
    }

    @Override
    public int insertStackAnySlot(IItemKey key, ItemStack stack) {
        ItemKey realKey = (ItemKey)key;
        IInventory inventory = realKey.getInventory();
        return InventoryHelper.mergeItemStack((IInventory)inventory, (boolean)true, (ItemStack)stack, (int)0, (int)inventory.func_70302_i_(), null);
    }

    private static class ItemKey
    implements IItemKey {
        private IInventory inventory;
        private int slot;

        public ItemKey(IInventory inventory, int slot) {
            this.inventory = inventory;
            this.slot = slot;
        }

        public IInventory getInventory() {
            return this.inventory;
        }

        public int getSlot() {
            return this.slot;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemKey itemKey = (ItemKey)o;
            if (this.slot != itemKey.slot) {
                return false;
            }
            return this.inventory.equals(itemKey.inventory);
        }

        public int hashCode() {
            int result = this.inventory.hashCode();
            result = 31 * result + this.slot;
            return result;
        }
    }
}

